/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.lib;

import com.sun.javatest.Command;
import com.sun.javatest.Status;
import com.sun.javatest.util.StringArray;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public class ProcessCommand
extends Command {
    private static boolean useFailedOnException = Boolean.getBoolean("javatest.processCommand.useFailedOnException");
    private static int serial;
    private boolean verbose;
    private Map<Integer, Status> statusTable;
    private Status defaultStatus;
    private File execDir;
    private boolean inheritEnv = Boolean.getBoolean("javatest.processCommand.inheritEnv");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String ... args) {
        Status s;
        PrintWriter log = new PrintWriter(new OutputStreamWriter((OutputStream)System.err, StandardCharsets.UTF_8));
        PrintWriter ref = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8));
        try {
            ProcessCommand cmd = new ProcessCommand();
            s = ((Command)cmd).run(args, log, ref);
        }
        finally {
            log.flush();
            ref.flush();
        }
        s.exit();
    }

    public void setStatusForExit(int exitCode, Status status) {
        if (this.statusTable == null) {
            this.statusTable = new Hashtable<Integer, Status>();
            if (this.defaultStatus == null) {
                this.defaultStatus = Status.error("unrecognized exit code");
            }
        }
        this.statusTable.put(exitCode, status);
    }

    public void setDefaultStatus(Status status) {
        if (this.statusTable == null) {
            this.statusTable = new Hashtable<Integer, Status>();
        }
        this.defaultStatus = status;
    }

    public File getExecDir() {
        return this.execDir;
    }

    public void setExecDir(File dir) {
        this.execDir = dir;
    }

    private void setStatus(String exitSpec, Status status) {
        if (exitSpec.equals("default")) {
            this.setDefaultStatus(status);
        } else {
            this.setStatusForExit(Integer.parseInt(exitSpec), status);
        }
    }

    @Override
    public Status run(String[] args, PrintWriter log, PrintWriter ref) {
        int i;
        for (i = 0; i < args.length && args[i].startsWith("-"); ++i) {
            if (args[i].equals("-v")) {
                this.verbose = true;
                continue;
            }
            if (args[i].equals("-execDir") && i + 1 < args.length) {
                this.execDir = new File(args[++i]);
                continue;
            }
            if (args[i].equals("-pass") && i + 2 < args.length) {
                this.setStatus(args[++i], Status.passed(args[++i]));
                continue;
            }
            if (args[i].equals("-fail") && i + 2 < args.length) {
                this.setStatus(args[++i], Status.failed(args[++i]));
                continue;
            }
            if (args[i].equals("-error") && i + 2 < args.length) {
                this.setStatus(args[++i], Status.error(args[++i]));
                continue;
            }
            if (args[i].equals("-inheritEnv")) {
                this.inheritEnv = true;
                continue;
            }
            if (args[i].equals("-end")) {
                ++i;
                break;
            }
            return Status.error("Unrecognized option: " + args[i]);
        }
        int cmdEnvStart = i;
        while (i < args.length && args[i].indexOf(61) != -1) {
            ++i;
        }
        String[] cmdEnv = new String[i - cmdEnvStart];
        System.arraycopy(args, cmdEnvStart, cmdEnv, 0, cmdEnv.length);
        if (i == args.length) {
            return Status.error("no command specified for " + this.getClass().getName());
        }
        String[] cmd = new String[args.length - i];
        System.arraycopy(args, i, cmd, 0, cmd.length);
        return this.exec(cmd, cmdEnv, log, ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status exec(String[] cmd, String[] cmdEnv, PrintWriter log, PrintWriter ref) {
        Process p = null;
        Status s = null;
        Reader inReader = null;
        Reader errReader = null;
        try {
            if (this.inheritEnv) {
                ArrayList<String> out = new ArrayList<String>();
                Map<String, String> sysenv = System.getenv();
                Set<String> keys = sysenv.keySet();
                for (String key : keys) {
                    String value = sysenv.get(key);
                    key = key.replaceAll(" ", "_");
                    key = key.replaceAll("=", ">");
                    out.add(key + "=" + (value == null ? "" : value));
                }
                if (cmdEnv != null && cmdEnv.length != 0) {
                    for (String str : cmdEnv) {
                        out.add(str);
                    }
                }
                cmdEnv = out.toArray(new String[cmdEnv.length]);
            } else if (cmdEnv != null && cmdEnv.length == 0) {
                String[] envWithDummyEntry = new String[]{"="};
                cmdEnv = envWithDummyEntry;
            }
            if (this.verbose) {
                log.println("Command is: " + StringArray.join(cmd));
                if (cmdEnv == null) {
                    log.println("Command environment is inherited from parent process");
                } else if (cmdEnv.length == 0) {
                    log.println("Command environment is empty");
                } else {
                    log.println("Command environment is:");
                    for (String aCmdEnv : cmdEnv) {
                        log.println(aCmdEnv);
                    }
                }
                if (this.execDir != null) {
                    log.println("Execution directory is " + this.execDir);
                }
            }
            Runtime r = Runtime.getRuntime();
            p = this.execDir == null ? r.exec(cmd, cmdEnv) : r.exec(cmd, cmdEnv, this.execDir);
            inReader = new InputStreamReader(p.getInputStream());
            StreamCopier refConnector = new StreamCopier(inReader, ref);
            refConnector.start();
            errReader = new InputStreamReader(p.getErrorStream());
            StreamCopier logConnector = new StreamCopier(errReader, log);
            logConnector.start();
            OutputStream out = p.getOutputStream();
            if (out != null) {
                out.close();
            }
            refConnector.waitUntilDone();
            logConnector.waitUntilDone();
            int exitCode = p.waitFor();
            Status status = this.getStatus(exitCode, logConnector.exitStatus());
            return status;
        }
        catch (InterruptedException e) {
            if (p != null) {
                p.destroy();
            }
            String msg = "Program `" + cmd[0] + "' interrupted! (timed out?)";
            s = useFailedOnException ? Status.failed(msg) : Status.error(msg);
        }
        catch (IOException e) {
            String msg = "Error invoking program `" + cmd[0] + "': " + e;
            s = useFailedOnException ? Status.failed(msg) : Status.error(msg);
        }
        finally {
            try {
                if (inReader != null) {
                    inReader.close();
                }
            }
            catch (Exception e) {}
            try {
                if (errReader != null) {
                    errReader.close();
                }
            }
            catch (Exception e) {}
        }
        return s;
    }

    protected Status getStatus(int exitCode, Status logStatus) {
        if (logStatus != null) {
            return logStatus;
        }
        if (this.statusTable != null) {
            Status s = this.statusTable.get(exitCode);
            return s == null ? this.defaultStatus.augment("exit code: " + exitCode) : s;
        }
        if (exitCode == 0) {
            return Status.passed("exit code 0");
        }
        return Status.failed("exit code " + exitCode);
    }

    static class StreamCopier
    extends Thread {
        private BufferedReader in;
        private PrintWriter out;
        private String lastStatusLine;
        private boolean done;

        StreamCopier(Reader from, PrintWriter to) {
            super(Thread.currentThread().getName() + "_StreamCopier_" + serial++);
            this.in = new BufferedReader(from);
            this.out = to;
            this.lastStatusLine = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                String line;
                while ((line = this.in.readLine()) != null) {
                    if (line.startsWith("STATUS:")) {
                        this.lastStatusLine = line = Status.decode(line);
                    }
                    this.out.println(line);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            StreamCopier streamCopier = this;
            synchronized (streamCopier) {
                this.done = true;
                this.notifyAll();
            }
        }

        public synchronized boolean isDone() {
            return this.done;
        }

        public synchronized void waitUntilDone() throws InterruptedException {
            boolean interrupted = false;
            while (!(interrupted = Thread.interrupted()) && !this.done) {
                this.wait(1000L);
            }
            if (interrupted) {
                throw new InterruptedException();
            }
        }

        public Status exitStatus() {
            if (this.lastStatusLine == null) {
                return null;
            }
            return Status.parse(this.lastStatusLine.substring("STATUS:".length()));
        }
    }
}

