/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.jsonp.api.jsonbuilderfactorytests;

import ee.jakarta.tck.jsonp.api.common.TestResult;
import ee.jakarta.tck.jsonp.api.jsonbuilderfactorytests.BuilderFactory;
import ee.jakarta.tck.jsonp.common.JSONP_Util;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import java.util.Map;
import java.util.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClientTests {
    private static final Logger LOGGER = Logger.getLogger(ClientTests.class.getName());

    @Test
    public void jsonBuilderFactoryTest1() {
        boolean pass = true;
        try {
            LOGGER.info("Create JsonBuilderFactory with Map<String, ?> with EMPTY config");
            JsonBuilderFactory builderFactory = Json.createBuilderFactory((Map)JSONP_Util.getEmptyConfig());
            LOGGER.info("Checking factory configuration properties");
            Map config = builderFactory.getConfigInUse();
            if (!JSONP_Util.doConfigCheck((Map)config, (int)0)) {
                pass = false;
            }
            LOGGER.info("---------------------------------------------------");
            LOGGER.info("TEST CASE [JsonBuilderFactory.createArrayBuilder()]");
            LOGGER.info("---------------------------------------------------");
            LOGGER.info("Create JsonArrayBuilder using JsonBuilderFactory");
            JsonArray expJsonArray = JSONP_Util.createJsonArrayFromString((String)"[0,2]");
            JsonArray actJsonArray = builderFactory.createArrayBuilder().add(0).add(2).build();
            if (!JSONP_Util.assertEqualsJsonArrays((JsonArray)expJsonArray, (JsonArray)actJsonArray)) {
                pass = false;
            }
            LOGGER.info("----------------------------------------------------");
            LOGGER.info("TEST CASE [JsonBuilderFactory.createObjectBuilder()]");
            LOGGER.info("----------------------------------------------------");
            LOGGER.info("Create JsonObjectBuilder using JsonBuilderFactory");
            JsonObject expJsonObject = JSONP_Util.createJsonObjectFromString((String)"{\"foo\":\"bar\"}");
            JsonObject actJsonObject = builderFactory.createObjectBuilder().add("foo", "bar").build();
            if (!JSONP_Util.assertEqualsJsonObjects((JsonObject)expJsonObject, (JsonObject)actJsonObject)) {
                pass = false;
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonBuilderFactoryTest1 Failed: ", (Throwable)e);
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonBuilderFactoryTest1 Failed");
    }

    @Test
    public void jsonBuilderFactoryTest2() {
        boolean pass = true;
        try {
            LOGGER.info("----------------------------------------------");
            LOGGER.info("Test scenario1: no supported provider property");
            LOGGER.info("----------------------------------------------");
            LOGGER.info("Create JsonBuilderFactory with Map<String, ?> with EMPTY config");
            JsonBuilderFactory builderFactory = Json.createBuilderFactory((Map)JSONP_Util.getEmptyConfig());
            Map config = builderFactory.getConfigInUse();
            if (!JSONP_Util.doConfigCheck((Map)config, (int)0)) {
                pass = false;
            }
            LOGGER.info("-----------------------------------------------");
            LOGGER.info("Test scenario2: non supported provider property");
            LOGGER.info("-----------------------------------------------");
            LOGGER.info("Create JsonBuilderFactory with Map<String, ?> with FOO config");
            builderFactory = Json.createBuilderFactory((Map)JSONP_Util.getFooConfig());
            config = builderFactory.getConfigInUse();
            if (!JSONP_Util.doConfigCheck((Map)config, (int)0)) {
                pass = false;
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonBuilderFactoryTest2 Failed: ", (Throwable)e);
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonBuilderFactoryTest2 Failed");
    }

    @Test
    public void jsonBuilderFactory11Test() {
        BuilderFactory factoryTest = new BuilderFactory();
        TestResult result = factoryTest.test();
        result.eval();
    }
}

