/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.framework.junit.extensions;

import ee.jakarta.tck.concurrent.common.managed.task.listener.ListenerEvent;
import ee.jakarta.tck.concurrent.common.managed.task.listener.ManagedTaskListenerImpl;
import ee.jakarta.tck.concurrent.common.transaction.CancelledTransactedTask;
import ee.jakarta.tck.concurrent.framework.TestConstants;
import java.time.Duration;
import java.util.concurrent.Future;
import java.util.function.IntSupplier;
import org.junit.jupiter.api.Assertions;

public final class Wait {
    private Wait() {
    }

    public static <T> T waitForTaskComplete(Future<T> future) {
        return Wait.waitForTaskComplete(future, TestConstants.waitTimeout);
    }

    public static <T> T waitForTaskComplete(Future<T> future, Duration timeout) {
        return (T)Assertions.assertTimeoutPreemptively((Duration)timeout, () -> future.get());
    }

    public static void waitForListenerComplete(ManagedTaskListenerImpl managedTaskListener) {
        Wait.waitForListenerComplete(managedTaskListener, TestConstants.waitTimeout, TestConstants.pollInterval);
    }

    public static void waitForListenerComplete(ManagedTaskListenerImpl managedTaskListener, Duration timeout, Duration pollInterval) {
        Assertions.assertTimeoutPreemptively((Duration)timeout, () -> {
            while (!managedTaskListener.eventCalled(ListenerEvent.DONE)) {
                Wait.sleep(TestConstants.pollInterval);
            }
        });
    }

    public static <T extends Throwable> void waitTillFutureThrowsException(Future<?> future, Class<T> expected) {
        Assertions.assertThrows(expected, () -> Assertions.assertTimeoutPreemptively((Duration)TestConstants.waitTimeout, () -> {
            while (true) {
                future.get();
                Wait.sleep(TestConstants.pollInterval);
            }
        }));
    }

    public static void waitCancelFuture(Future<?> future) {
        Assertions.assertTimeoutPreemptively((Duration)TestConstants.waitTimeout, () -> {
            future.cancel(true);
            while (!future.isDone()) {
                Wait.sleep(TestConstants.pollInterval);
            }
        });
    }

    public static void waitTillThreadFinish(Thread thread) {
        Assertions.assertTimeoutPreemptively((Duration)TestConstants.waitTimeout, () -> {
            while (thread.isAlive()) {
                Wait.sleep(TestConstants.pollInterval);
            }
        });
    }

    public static void waitForTransactionBegan(CancelledTransactedTask task) {
        Assertions.assertTimeoutPreemptively((Duration)TestConstants.waitTimeout, () -> {
            while (!task.getBeginTransaction().get()) {
                Wait.sleep(TestConstants.pollInterval);
            }
        });
    }

    public static void waitForCounter(IntSupplier counter, int expected) {
        Assertions.assertTimeoutPreemptively((Duration)TestConstants.waitTimeout, () -> {
            while (expected != counter.getAsInt()) {
                Wait.sleep(TestConstants.pollInterval);
            }
        });
    }

    public static void sleep(Duration time) {
        try {
            Thread.sleep(time.toMillis());
        }
        catch (InterruptedException e) {
            throw new AssertionError("Interrupted while sleeping", e);
        }
    }
}

