/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.lang.model.tck;

import jakarta.enterprise.lang.model.declarations.ClassInfo;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Modifier;
import org.jboss.cdi.lang.model.tck.LangModelUtils;
import org.jboss.cdi.lang.model.tck.PlainClassMembers;
import org.jboss.cdi.lang.model.tck.SimpleAnnotation;
import org.jboss.cdi.lang.model.tck.SimpleEnum;

@Retention(value=RetentionPolicy.RUNTIME)
public @interface AnnotationMembers {
    public static final String publicStaticFinalField = "";
    public static final String publicStaticField = "";
    public static final String publicFinalField = "";
    public static final String publicField = "";
    public static final String staticFinalField = "";
    public static final String staticField = "";
    public static final String finalField = "";
    public static final String field = "";

    public boolean booleanMember() default true;

    public byte byteMember() default 1;

    public short shortMember() default 2;

    public int intMember() default 3;

    public long longMember() default 4L;

    public float floatMember() default 5.0f;

    public double doubleMember() default 6.0;

    public char charMember() default 65;

    public String stringMember() default "BB";

    public Class<?> classMember() default AnnotationMembers.class;

    public SimpleEnum enumMember() default SimpleEnum.YES;

    public SimpleAnnotation annotationMember() default @SimpleAnnotation(value="CCC");

    public boolean[] booleanArrayMember() default {true, false};

    public byte[] byteArrayMember() default {1, 2};

    public short[] shortArrayMember() default {3, 4};

    public int[] intArrayMember() default {5, 6};

    public long[] longArrayMember() default {7L, 8L};

    public float[] floatArrayMember() default {9.0f, 10.0f};

    public double[] doubleArrayMember() default {11.0, 12.0};

    public char[] charArrayMember() default {65, 66};

    public String[] stringArrayMember() default {"CC", "DD"};

    public Class<?>[] classArrayMember() default {SimpleAnnotation.class, SimpleEnum.class};

    public SimpleEnum[] enumArrayMember() default {SimpleEnum.YES, SimpleEnum.NO};

    public SimpleAnnotation[] annotationArrayMember() default {@SimpleAnnotation(value="EEE"), @SimpleAnnotation(value="FFF")};

    public static class Verifier {
        public static void verify(ClassInfo clazz) {
            assert (clazz.name().equals("org.jboss.cdi.lang.model.tck.AnnotationMembers"));
            assert (clazz.simpleName().equals("AnnotationMembers"));
            assert (!clazz.isPlainClass());
            assert (!clazz.isInterface());
            assert (!clazz.isEnum());
            assert (clazz.isAnnotation());
            assert (!clazz.isRecord());
            assert (clazz.isAbstract());
            assert (!clazz.isFinal());
            assert (Modifier.isPublic(clazz.modifiers()));
            assert (!Modifier.isProtected(clazz.modifiers()));
            assert (!Modifier.isPrivate(clazz.modifiers()));
            Verifier.verifyFields(clazz);
            Verifier.verifyMethods(clazz);
            assert (clazz.constructors().isEmpty());
            assert (clazz.annotations().size() == 1);
            assert (clazz.hasAnnotation(Retention.class));
        }

        private static void verifyFields(ClassInfo clazz) {
            assert (clazz.fields().size() == 8);
            PlainClassMembers.Verifier.assertField(clazz, "publicStaticFinalField", 1, true, true, true);
            PlainClassMembers.Verifier.assertField(clazz, "publicStaticField", 1, true, true, true);
            PlainClassMembers.Verifier.assertField(clazz, "publicFinalField", 1, true, true, true);
            PlainClassMembers.Verifier.assertField(clazz, "publicField", 1, true, true, true);
            PlainClassMembers.Verifier.assertField(clazz, "staticFinalField", 1, true, true, true);
            PlainClassMembers.Verifier.assertField(clazz, "staticField", 1, true, true, true);
            PlainClassMembers.Verifier.assertField(clazz, "finalField", 1, true, true, true);
            PlainClassMembers.Verifier.assertField(clazz, "field", 1, true, true, true);
        }

        private static void verifyMethods(ClassInfo clazz) {
            assert (clazz.methods().size() >= 24);
            LangModelUtils.singleMethod(clazz, "booleanMember");
            LangModelUtils.singleMethod(clazz, "byteMember");
            LangModelUtils.singleMethod(clazz, "shortMember");
            LangModelUtils.singleMethod(clazz, "intMember");
            LangModelUtils.singleMethod(clazz, "longMember");
            LangModelUtils.singleMethod(clazz, "floatMember");
            LangModelUtils.singleMethod(clazz, "doubleMember");
            LangModelUtils.singleMethod(clazz, "charMember");
            LangModelUtils.singleMethod(clazz, "stringMember");
            LangModelUtils.singleMethod(clazz, "classMember");
            LangModelUtils.singleMethod(clazz, "enumMember");
            LangModelUtils.singleMethod(clazz, "annotationMember");
            LangModelUtils.singleMethod(clazz, "booleanArrayMember");
            LangModelUtils.singleMethod(clazz, "byteArrayMember");
            LangModelUtils.singleMethod(clazz, "shortArrayMember");
            LangModelUtils.singleMethod(clazz, "intArrayMember");
            LangModelUtils.singleMethod(clazz, "longArrayMember");
            LangModelUtils.singleMethod(clazz, "floatArrayMember");
            LangModelUtils.singleMethod(clazz, "doubleArrayMember");
            LangModelUtils.singleMethod(clazz, "charArrayMember");
            LangModelUtils.singleMethod(clazz, "stringArrayMember");
            LangModelUtils.singleMethod(clazz, "classArrayMember");
            LangModelUtils.singleMethod(clazz, "enumArrayMember");
            LangModelUtils.singleMethod(clazz, "annotationArrayMember");
        }
    }
}

