/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.build.compatible.extensions.priority;

import jakarta.annotation.Priority;
import jakarta.enterprise.inject.build.compatible.spi.BeanInfo;
import jakarta.enterprise.inject.build.compatible.spi.BuildCompatibleExtension;
import jakarta.enterprise.inject.build.compatible.spi.ClassConfig;
import jakarta.enterprise.inject.build.compatible.spi.Discovery;
import jakarta.enterprise.inject.build.compatible.spi.Enhancement;
import jakarta.enterprise.inject.build.compatible.spi.Messages;
import jakarta.enterprise.inject.build.compatible.spi.Registration;
import jakarta.enterprise.inject.build.compatible.spi.Validation;
import java.util.LinkedHashSet;
import java.util.List;

public class PriorityExtension
implements BuildCompatibleExtension {
    private final LinkedHashSet<String> invocations = new LinkedHashSet();

    @Discovery
    @Priority(value=10)
    public void first() {
        this.invocations.add("1");
    }

    @Discovery
    @Priority(value=20)
    public void second() {
        this.invocations.add("2");
    }

    @Enhancement(types={Object.class}, withSubtypes=true)
    @Priority(value=15)
    public void third(ClassConfig clazz) {
        this.invocations.add("3");
    }

    @Registration(types={Object.class})
    @Priority(value=5)
    public void fourth(BeanInfo clazz) {
        this.invocations.add("4");
    }

    @Validation
    @Priority(value=1000)
    public void fifth() {
        this.invocations.add("5");
    }

    @Validation
    public void sixth() {
        this.invocations.add("6");
    }

    @Validation
    @Priority(value=10000)
    public void seventh() {
        this.invocations.add("7");
    }

    @Validation
    @Priority(value=1000000)
    public void test(Messages msg) {
        if (!List.of("1", "2", "3", "4", "5", "6", "7").equals(List.copyOf(this.invocations))) {
            msg.error("Incorrect invocation order of extension methods");
        }
    }
}

