/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.build.compatible.extensions.inspectAnnotatedSubtypes;

import jakarta.enterprise.inject.build.compatible.spi.BuildCompatibleExtension;
import jakarta.enterprise.inject.build.compatible.spi.ClassConfig;
import jakarta.enterprise.inject.build.compatible.spi.Discovery;
import jakarta.enterprise.inject.build.compatible.spi.Enhancement;
import jakarta.enterprise.inject.build.compatible.spi.Messages;
import jakarta.enterprise.inject.build.compatible.spi.ScannedClasses;
import jakarta.enterprise.inject.build.compatible.spi.Validation;
import java.util.HashSet;
import java.util.Set;
import org.jboss.cdi.tck.tests.build.compatible.extensions.inspectAnnotatedSubtypes.MyAnnotation;
import org.jboss.cdi.tck.tests.build.compatible.extensions.inspectAnnotatedSubtypes.MyService;
import org.jboss.cdi.tck.tests.build.compatible.extensions.inspectAnnotatedSubtypes.MyServiceBar;
import org.jboss.cdi.tck.tests.build.compatible.extensions.inspectAnnotatedSubtypes.MyServiceBaz;
import org.jboss.cdi.tck.tests.build.compatible.extensions.inspectAnnotatedSubtypes.MyServiceFoo;

public class InspectAnnotatedSubtypesExtension
implements BuildCompatibleExtension {
    private final Set<String> seenAnnotatedSubtypes = new HashSet<String>();

    @Discovery
    public void discovery(ScannedClasses scan) {
        scan.add(MyServiceBaz.class.getName());
    }

    @Enhancement(types={MyService.class}, withSubtypes=true, withAnnotations={MyAnnotation.class})
    public void enhancement(ClassConfig clazz) {
        this.seenAnnotatedSubtypes.add(clazz.info().simpleName());
    }

    @Validation
    public void validation(Messages msg) {
        if (this.seenAnnotatedSubtypes.size() != 2) {
            msg.error("Must have seen 2 subtypes of MyService with MyAnnotation");
        }
        if (!this.seenAnnotatedSubtypes.contains(MyServiceFoo.class.getSimpleName())) {
            msg.error("Must have seen MyServiceFoo");
        }
        if (this.seenAnnotatedSubtypes.contains(MyServiceBar.class.getSimpleName())) {
            msg.error("Must NOT have seen MyServiceBar");
        }
        if (!this.seenAnnotatedSubtypes.contains(MyServiceBaz.class.getSimpleName())) {
            msg.error("Must have seen MyServiceBaz");
        }
    }
}

