/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.lookup.injection.non.contextual;

import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.spi.AnnotatedConstructor;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.inject.Inject;
import jakarta.servlet.Filter;
import jakarta.servlet.GenericServlet;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.jsp.tagext.JspTag;
import jakarta.servlet.jsp.tagext.SimpleTag;
import jakarta.servlet.jsp.tagext.SimpleTagSupport;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.EventListener;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.ee.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.Farm;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.ProcessAnnotatedTypeObserver;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.SessionBean;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.Sheep;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.TagLibraryListener;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.TestFilter;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.TestListener;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.TestServlet;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.TestTagHandler;
import org.jboss.shrinkwrap.api.BeanDiscoveryMode;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.BeansXml;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class ContainerEventTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(ContainerEventTest.class)).withWebXml("web.xml")).withClasses(new Class[]{Farm.class, ProcessAnnotatedTypeObserver.class, Sheep.class, TagLibraryListener.class, TestFilter.class, TestListener.class, TestServlet.class, TestTagHandler.class, SessionBean.class})).withExtension(ProcessAnnotatedTypeObserver.class)).withWebResource("ManagedBeanTestPage.jsp", "ManagedBeanTestPage.jsp")).withWebResource("TagPage.jsp", "TagPage.jsp")).withWebResource("faces-config.xml", "/WEB-INF/faces-config.xml")).withWebResource("TestLibrary.tld", "WEB-INF/TestLibrary.tld")).withDefaultPersistenceXml()).withBeansXml(new BeansXml(BeanDiscoveryMode.ALL))).build();
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="type_bean_discovery_ee", id="bb")
    public void testProcessAnnotatedTypeEventFiredForSessionBean() {
        AnnotatedType<SessionBean> annotatedType = ProcessAnnotatedTypeObserver.getSessionBeanEvent();
        Assert.assertNotNull(annotatedType);
        Assert.assertEquals((Object)annotatedType.getBaseType(), SessionBean.class);
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="type_bean_discovery_ee", id="be")
    public void testProcessAnnotatedTypeEventFiredForServletListener() {
        Assert.assertNotNull(ProcessAnnotatedTypeObserver.getListenerEvent());
        this.validateServletListenerAnnotatedType(ProcessAnnotatedTypeObserver.getListenerEvent());
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="type_bean_discovery_ee", id="bf")
    public void testProcessAnnotatedTypeEventFiredForTagHandler() {
        Assert.assertNotNull(ProcessAnnotatedTypeObserver.getTagHandlerEvent());
        this.validateTagHandlerAnnotatedType(ProcessAnnotatedTypeObserver.getTagHandlerEvent());
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="type_bean_discovery_ee", id="bg")
    public void testProcessAnnotatedTypeEventFiredForTagLibraryListener() {
        Assert.assertNotNull(ProcessAnnotatedTypeObserver.getTagLibraryListenerEvent());
        this.validateTagLibraryListenerAnnotatedType(ProcessAnnotatedTypeObserver.getTagLibraryListenerEvent());
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="type_bean_discovery_ee", id="bj")
    public void testProcessAnnotatedTypeEventFiredForServlet() {
        Assert.assertNotNull(ProcessAnnotatedTypeObserver.getServletEvent());
        this.validateServletAnnotatedType(ProcessAnnotatedTypeObserver.getServletEvent());
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="type_bean_discovery_ee", id="bk")
    public void testProcessAnnotatedTypeEventFiredForFilter() {
        Assert.assertNotNull(ProcessAnnotatedTypeObserver.getFilterEvent());
        this.validateFilterAnnotatedType(ProcessAnnotatedTypeObserver.getFilterEvent());
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="type_bean_discovery_ee", id="bd")
    public void testProcessAnnotatedTypeEventFiredForJsfManagedBean() {
        Assert.assertNotNull(ProcessAnnotatedTypeObserver.getJsfManagedBeanEvent());
        this.validateJsfManagedBeanAnnotatedType(ProcessAnnotatedTypeObserver.getJsfManagedBeanEvent());
    }

    private void validateServletListenerAnnotatedType(AnnotatedType<TestListener> type) {
        Assert.assertEquals((Object)type.getBaseType(), TestListener.class);
        Assert.assertTrue((boolean)type.getAnnotations().isEmpty());
        Assert.assertEquals((int)type.getFields().size(), (int)2);
        Assert.assertTrue((boolean)type.getMethods().stream().anyMatch(m -> m.getJavaMember().getName().equals("contextInitialized")));
        int initializers = 0;
        for (AnnotatedMethod method : type.getMethods()) {
            Assert.assertEquals((int)method.getParameters().size(), (int)1);
            Assert.assertEquals((Object)method.getBaseType(), Void.TYPE);
            if (!method.isAnnotationPresent(Inject.class)) continue;
            ++initializers;
        }
        Assert.assertEquals((int)initializers, (int)1);
    }

    private void validateTagHandlerAnnotatedType(AnnotatedType<TestTagHandler> type) {
        Assert.assertEquals((Object)type.getBaseType(), TestTagHandler.class);
        Assert.assertTrue((boolean)this.typeSetMatches(type.getTypeClosure(), new Type[]{TestTagHandler.class, SimpleTagSupport.class, SimpleTag.class, JspTag.class, Object.class}));
        Assert.assertEquals((int)type.getAnnotations().size(), (int)1);
        Assert.assertTrue((boolean)type.isAnnotationPresent(Any.class));
    }

    private void validateTagLibraryListenerAnnotatedType(AnnotatedType<TagLibraryListener> type) {
        Assert.assertEquals((Object)type.getBaseType(), TagLibraryListener.class);
        Assert.assertTrue((boolean)this.typeSetMatches(type.getTypeClosure(), new Type[]{TagLibraryListener.class, ServletContextListener.class, EventListener.class, Object.class}));
        Assert.assertEquals((int)type.getFields().size(), (int)2);
        Assert.assertEquals((int)type.getConstructors().size(), (int)1);
        Assert.assertTrue((boolean)type.getMethods().stream().anyMatch(m -> m.getJavaMember().getName().equals("contextInitialized")));
    }

    private void validateServletAnnotatedType(AnnotatedType<TestServlet> type) {
        Assert.assertEquals((Object)type.getBaseType(), TestServlet.class);
        Assert.assertTrue((boolean)this.typeSetMatches(type.getTypeClosure(), new Type[]{TestServlet.class, HttpServlet.class, GenericServlet.class, Servlet.class, ServletConfig.class, Serializable.class, Object.class}));
        Assert.assertTrue((boolean)type.getAnnotations().isEmpty());
    }

    private void validateFilterAnnotatedType(AnnotatedType<TestFilter> type) {
        Assert.assertEquals((Object)type.getBaseType(), TestFilter.class);
        Assert.assertTrue((boolean)this.typeSetMatches(type.getTypeClosure(), new Type[]{TestFilter.class, Filter.class, Object.class}));
        Assert.assertEquals((int)type.getFields().size(), (int)12);
        Assert.assertEquals((int)type.getConstructors().size(), (int)1);
        Assert.assertTrue((boolean)((AnnotatedConstructor)type.getConstructors().iterator().next()).getParameters().isEmpty());
        Assert.assertTrue((boolean)type.getMethods().stream().anyMatch(m -> m.getJavaMember().getName().equals("doFilter")));
    }

    private void validateJsfManagedBeanAnnotatedType(AnnotatedType<Farm> type) {
        assert (type.getFields().size() == 2);
        for (AnnotatedField field : type.getFields()) {
            if (field.getJavaMember().getName().equals("sheep")) {
                Assert.assertTrue((boolean)field.isAnnotationPresent(Inject.class));
                Assert.assertFalse((boolean)field.isStatic());
                continue;
            }
            if (field.getJavaMember().getName().equals("initializerCalled")) {
                Assert.assertFalse((boolean)field.isStatic());
                Assert.assertTrue((boolean)field.getBaseType().equals(Boolean.TYPE));
                continue;
            }
            Assert.fail();
        }
        Assert.assertEquals((int)type.getMethods().size(), (int)3);
    }
}

