/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.full.context.dependent;

import jakarta.enterprise.inject.spi.Bean;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.full.context.dependent.Fox;
import org.jboss.cdi.tck.tests.full.context.dependent.FoxRun;
import org.jboss.cdi.tck.tests.full.context.dependent.SensitiveFox;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@Test(groups={"cdi-full"})
@SpecVersion(spec="cdi", version="2.0")
public class DependentContextTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(DependentContextTest.class)).build();
    }

    @Test
    @SpecAssertion(section="dependent_context_ee", id="ca")
    public void testInstanceUsedForElEvaluationNotShared() throws Exception {
        Set<Bean<Fox>> foxBeans = this.getBeans(Fox.class, new Annotation[0]);
        assert (foxBeans.size() == 1);
        Fox fox1 = (Fox)this.getCurrentConfiguration().getEl().evaluateValueExpression(this.getCurrentManager(), "#{fox}", Fox.class);
        Fox fox2 = (Fox)this.getCurrentConfiguration().getEl().evaluateValueExpression(this.getCurrentManager(), "#{fox}", Fox.class);
        assert (!fox1.equals(fox2));
    }

    @Test
    @SpecAssertion(section="dependent_destruction_ee", id="eee")
    public void testDependentsDestroyedWhenElEvaluationCompletes() throws Exception {
        Fox.reset();
        FoxRun.setDestroyed(false);
        this.getCurrentConfiguration().getEl().evaluateValueExpression(this.getCurrentManager(), "#{foxRun}", FoxRun.class);
        assert (FoxRun.isDestroyed());
        assert (Fox.isDestroyed());
    }

    @Test
    @SpecAssertion(section="dependent_context", id="g")
    public void testContextIsActiveWhenEvaluatingElExpression() {
        String foxName = (String)this.getCurrentConfiguration().getEl().evaluateMethodExpression(this.getCurrentManager(), "#{sensitiveFox.getName}", String.class, new Class[0], new Object[0]);
        assert (foxName != null);
        assert (SensitiveFox.isDependentContextActiveDuringEval());
    }
}

