/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.request.event.timeout;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Destroyed;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.cdi.tck.tests.context.request.event.timeout.RequestScopedObserver;

@ApplicationScoped
public class ApplicationScopedObserver {
    @Inject
    private RequestScopedObserver observer;
    private final CountDownLatch latch = new CountDownLatch(1);
    private final AtomicBoolean destroyedCalled = new AtomicBoolean();

    void observeRequestDestroyed(@Observes @Destroyed(value=RequestScoped.class) Object event) {
        this.destroyedCalled.set(true);
    }

    void reset() {
        this.destroyedCalled.set(false);
    }

    boolean isDestroyedCalled() {
        return this.destroyedCalled.get();
    }

    public void countDown() {
        if (this.observer.isInitializedObserved()) {
            this.latch.countDown();
        }
    }

    public Boolean await(long timeout, TimeUnit timeUnit) {
        Boolean result = new Boolean(false);
        try {
            result = this.latch.await(timeout, timeUnit);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return result;
    }
}

