/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.handly.util.Property;

public class PropertyTest
extends TestCase {
    public void test1() {
        Property p1 = Property.get((String)"p1", String.class);
        PropertyTest.assertEquals((String)"p1", (String)p1.getName());
        PropertyTest.assertEquals(String.class, (Object)p1.getType());
        PropertyTest.assertEquals(String.class, (Object)p1.getRawType());
        PropertyTest.assertNull((Object)p1.defaultValue());
    }

    public void test2() {
        Property p2 = Property.get((String)"p2", String[].class);
        PropertyTest.assertEquals((String)"p2", (String)p2.getName());
        PropertyTest.assertEquals(String[].class, (Object)p2.getType());
        PropertyTest.assertEquals(String[].class, (Object)p2.getRawType());
        PropertyTest.assertNull((Object)p2.defaultValue());
    }

    public void test3() {
        Property p3 = new Property<List<String>>("p3"){}.withDefault(Collections.unmodifiableList(Arrays.asList("1", "2", "3")));
        PropertyTest.assertEquals((String)"p3", (String)p3.getName());
        PropertyTest.assertEquals((String)"java.util.List<java.lang.String>", (String)p3.getType().getTypeName());
        PropertyTest.assertEquals(List.class, (Object)p3.getRawType());
        PropertyTest.assertEquals(Arrays.asList("1", "2", "3"), (Object)p3.defaultValue());
    }

    public void test4() {
        Property<List<String>[]> p4 = new Property<List<String>[]>("p4"){};
        PropertyTest.assertEquals((String)"p4", (String)p4.getName());
        PropertyTest.assertEquals((String)"java.util.List<java.lang.String>[]", (String)p4.getType().getTypeName());
        PropertyTest.assertEquals(List[].class, (Object)p4.getRawType());
        PropertyTest.assertNull((Object)p4.defaultValue());
    }

    public void test5() {
        Property p5 = Property.get((String)"p5", List.class).withDefault(null).withDefault((Object)Collections.EMPTY_LIST);
        PropertyTest.assertEquals((String)"p5", (String)p5.getName());
        PropertyTest.assertEquals(List.class, (Object)p5.getType());
        PropertyTest.assertEquals(List.class, (Object)p5.getRawType());
        PropertyTest.assertEquals((Object)Collections.EMPTY_LIST, (Object)p5.defaultValue());
    }

    public void test6() {
        try {
            new Property("p6"){};
            PropertyTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

