/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.snapshot;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.handly.junit.WorkspaceTestCase;
import org.eclipse.handly.snapshot.TextFileSnapshotWs;

public class TextFileSnapshotWsTest
extends WorkspaceTestCase {
    private IFile file;
    private TextFileSnapshotWs snapshot;

    protected void setUp() throws Exception {
        super.setUp();
        IProject p = this.setUpProject("Test002");
        this.file = p.getFile("x.txt");
        this.snapshot = new TextFileSnapshotWs(this.file);
    }

    public void test1() throws Exception {
        TextFileSnapshotWsTest.assertEquals((String)"hello", (String)this.snapshot.getContents());
        TextFileSnapshotWsTest.assertEquals((String)"hello", (String)this.snapshot.getContents());
        long modificationStamp = this.file.getModificationStamp();
        this.file.touch(null);
        TextFileSnapshotWsTest.assertNull((Object)this.snapshot.getContents());
        this.file.revertModificationStamp(modificationStamp);
        TextFileSnapshotWsTest.assertEquals((String)"hello", (String)this.snapshot.getContents());
    }

    public void test2() {
        TextFileSnapshotWsTest.assertEquals((String)"hello", (String)this.snapshot.getContents());
        TextFileSnapshotWsTest.assertTrue((boolean)this.file.getLocation().toFile().delete());
        TextFileSnapshotWsTest.assertEquals((String)"hello", (String)this.snapshot.getContents());
    }

    public void test3() {
        TextFileSnapshotWsTest.assertTrue((boolean)this.file.getLocation().toFile().delete());
        TextFileSnapshotWsTest.assertNull((Object)this.snapshot.getContents());
        TextFileSnapshotWsTest.assertNull((Object)this.snapshot.getContents());
    }

    public void test4() {
        TextFileSnapshotWsTest.assertEquals((String)"hello", (String)this.snapshot.getContents());
        this.snapshot.clearContents();
        TextFileSnapshotWsTest.assertEquals((String)"hello", (String)this.snapshot.getContents());
    }

    public void test5() {
        TextFileSnapshotWsTest.assertEquals((String)"hello", (String)this.snapshot.getContents());
        TextFileSnapshotWsTest.assertTrue((boolean)this.file.getLocation().toFile().delete());
        this.snapshot.clearContents();
        TextFileSnapshotWsTest.assertNull((Object)this.snapshot.getContents());
    }
}

