/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.utils;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.eclipse.glsp.server.disposable.IDisposable;

public class Debouncer<T>
implements Consumer<T>,
IDisposable {
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private final Map<T, ScheduledFuture<?>> scheduledExecutions = new ConcurrentHashMap();
    private final Consumer<T> consumer;
    private final long delay;
    private final TimeUnit timeUnit;

    public Debouncer(Consumer<T> consumer, long delay, TimeUnit timeUnit) {
        this.consumer = consumer;
        this.delay = delay;
        this.timeUnit = timeUnit;
    }

    @Override
    public void accept(T argument) {
        this.scheduledExecutions.compute(argument, this::scheduleExecution);
    }

    private ScheduledFuture<?> scheduleExecution(T argument, ScheduledFuture<?> previousExecution) {
        if (previousExecution != null) {
            previousExecution.cancel(true);
        }
        return !this.isDisposed() ? this.executorService.schedule(() -> this.execute(argument), this.delay, this.timeUnit) : null;
    }

    private void execute(T argument) {
        this.scheduledExecutions.remove(argument);
        this.consumer.accept(argument);
    }

    @Override
    public void dispose() {
        this.executorService.shutdownNow();
    }

    @Override
    public boolean isDisposed() {
        return this.executorService.isShutdown();
    }
}

