/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.actions;

import java.util.Optional;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.types.ServerStatus;
import org.eclipse.glsp.server.types.Severity;

public class ServerMessageAction
extends Action {
    public static final String KIND = "serverMessage";
    private static final int NO_TIMEOUT = -1;
    private String severity;
    private String message;
    private String details;
    private int timeout;

    public ServerMessageAction() {
        super(KIND);
    }

    public ServerMessageAction(Severity severity, String message) {
        this(severity, message, null, -1);
    }

    public ServerMessageAction(Severity severity, String message, int timeout) {
        this(severity, message, null, timeout);
    }

    public ServerMessageAction(Severity severity, String message, String details) {
        this(severity, message, details, -1);
    }

    public ServerMessageAction(ServerStatus status) {
        this(status.getSeverity(), status.getMessage(), status.getDetails(), -1);
    }

    public ServerMessageAction(Severity severity, String message, String details, int timeout) {
        this();
        this.severity = Severity.toString(severity);
        this.message = message;
        this.details = details;
        this.timeout = timeout;
    }

    public String getSeverity() {
        return this.severity;
    }

    public String getMessage() {
        return this.message;
    }

    public Optional<String> getDetails() {
        return Optional.ofNullable(this.details);
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

