/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.process.impl;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.gendoc.process.IProcess;
import org.eclipse.gendoc.process.impl.ProcessesExtensionPoint;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.ILogger;

public class ProcessExtension
implements Comparable<ProcessExtension> {
    private final IConfigurationElement configElement;
    private VisitState visitState = VisitState.NOT_STARTED;
    private final String id;
    private final String label;
    private final boolean parallel;
    private final Priority priority;
    private final List<String> predecessors = new LinkedList<String>();
    private final List<String> successors = new LinkedList<String>();
    private final List<ProcessExtension> dependencies = new LinkedList<ProcessExtension>();

    public ProcessExtension(IConfigurationElement configElement) {
        String ref;
        this.configElement = configElement;
        this.id = configElement.getAttribute(ProcessesExtensionPoint.PROCESS_ID);
        this.label = configElement.getAttribute(ProcessesExtensionPoint.PROCESS_LABEL);
        this.parallel = Boolean.parseBoolean(configElement.getAttribute(ProcessesExtensionPoint.PROCESS_PARALLEL));
        this.priority = Priority.valueOf(configElement.getAttribute(ProcessesExtensionPoint.PROCESS_PRIORITY));
        IConfigurationElement[] iConfigurationElementArray = configElement.getChildren(ProcessesExtensionPoint.PREDECESSOR);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement predecessor = iConfigurationElementArray[n2];
            ref = predecessor.getAttribute(ProcessesExtensionPoint.PREDECESSOR_REF);
            if (ref != null) {
                this.predecessors.add(ref);
            }
            ++n2;
        }
        iConfigurationElementArray = configElement.getChildren(ProcessesExtensionPoint.SUCCESSOR);
        n = iConfigurationElementArray.length;
        n2 = 0;
        while (n2 < n) {
            IConfigurationElement successor = iConfigurationElementArray[n2];
            ref = successor.getAttribute(ProcessesExtensionPoint.SUCCESSOR_REF);
            if (ref != null) {
                this.successors.add(ref);
            }
            ++n2;
        }
    }

    @Override
    public int compareTo(ProcessExtension o) {
        return this.priority.compareTo(o.getPriority());
    }

    public boolean findCyclicDependencies(StringBuffer message) {
        switch (this.visitState) {
            case NOT_STARTED: {
                this.visitState = VisitState.IN_PROGRESS;
                for (ProcessExtension dependency : this.dependencies) {
                    if (!dependency.findCyclicDependencies(message)) continue;
                    message.append(" <- " + this.id);
                    return true;
                }
                this.visitState = VisitState.FINISHED;
                break;
            }
            case IN_PROGRESS: {
                message.append(this.id);
                return true;
            }
        }
        return false;
    }

    public List<ProcessExtension> getDependencies() {
        return this.dependencies;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public List<String> getPredecessors() {
        return this.predecessors;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public IProcess getProcess() {
        try {
            return (IProcess)this.configElement.createExecutableExtension(ProcessesExtensionPoint.PROCESS_PROCESSOR);
        }
        catch (CoreException coreException) {
            String message = "Failed to create process " + this.id + " from " + this.configElement.getDeclaringExtension().getNamespaceIdentifier();
            ((ILogger)GendocServices.getDefault().getService(ILogger.class)).log(message, 4);
            return null;
        }
    }

    public List<String> getSuccessors() {
        return this.successors;
    }

    public boolean isParallel() {
        return this.parallel;
    }

    static enum Priority {
        HIGH,
        ABOVE_NORMAL,
        NORMAL,
        BELOW_NORMAL,
        LOW;

    }

    static enum VisitState {
        NOT_STARTED,
        IN_PROGRESS,
        FINISHED;

    }
}

