/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.preferences.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.gendoc.preferences.internal.GendocPreferenceUtils;
import org.eclipse.gendoc.preferences.internal.GendocTemplateDialog;
import org.eclipse.gendoc.preferences.internal.PreferenceGendocRunner;
import org.eclipse.gendoc.preferences.internal.TableFieldEditor;
import org.eclipse.gendoc.wizard.IGendocRunner;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class GendocTemplateFieldEditor
extends TableFieldEditor {
    private IProject owner;

    public GendocTemplateFieldEditor() {
    }

    public GendocTemplateFieldEditor(IProject owner, String name, String labelText, Composite parent) {
        super(name, labelText, parent);
        this.owner = owner;
    }

    @Override
    protected Table createTableControl(Composite parent) {
        Table t = super.createTableControl(parent);
        t.setHeaderVisible(true);
        TableColumn col = new TableColumn(t, 16384);
        col.setText("Template Name");
        col.setWidth(150);
        col = new TableColumn(t, 16384);
        col.setText("Description");
        col.setWidth(300);
        return t;
    }

    protected IGendocRunner getNewInputObject() {
        GendocTemplateDialog dlg = new GendocTemplateDialog(Display.getCurrent().getActiveShell());
        dlg.setInput((IGendocRunner)new PreferenceGendocRunner(this.owner, "New Template Type"));
        int res = dlg.open();
        if (res == 0) {
            return dlg.getInput();
        }
        return null;
    }

    @Override
    protected Object editInputObject(Object input) {
        GendocTemplateDialog dlg = new GendocTemplateDialog(Display.getCurrent().getActiveShell());
        try {
            dlg.setInput((IGendocRunner)((PreferenceGendocRunner)((PreferenceGendocRunner)input).clone()));
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        int res = dlg.open();
        if (res == 0) {
            return dlg.getInput();
        }
        return null;
    }

    @Override
    protected ITableLabelProvider createLabelProvider() {
        return new LabelProvider();
    }

    @Override
    protected String createList(Object[] objs) {
        ArrayList<Object> l = new ArrayList<Object>();
        l.addAll(Arrays.asList(objs));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            GendocPreferenceUtils.marshallTemplates(l.toArray(new IGendocRunner[0]), out);
            return out.toString("UTF-8");
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    protected Object[] parseString(String s) {
        try {
            return GendocPreferenceUtils.unmarshallTemplates(new ByteArrayInputStream(s.getBytes(Charset.forName("UTF-8"))));
        }
        catch (ParseException parseException) {
            return new IGendocRunner[0];
        }
    }

    @Override
    protected void adjustForNumColumns(int numColumns) {
        super.adjustForNumColumns(numColumns);
        ((GridData)super.getTable().getLayoutData()).heightHint = 500;
    }

    private class LabelProvider
    extends BaseLabelProvider
    implements ITableLabelProvider {
        private LabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ((IGendocRunner)element).getLabel();
                }
                case 1: {
                    if (!(element instanceof PreferenceGendocRunner)) break;
                    return ((PreferenceGendocRunner)element).getDescription();
                }
            }
            return "";
        }
    }
}

