/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.dsl.debug.ide;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gemoc.dsl.debug.ide.IDSLDebugger;
import org.eclipse.gemoc.dsl.debug.ide.ThreadController;
import org.eclipse.gemoc.dsl.debug.ide.event.IDSLDebugEvent;
import org.eclipse.gemoc.dsl.debug.ide.event.IDSLDebugEventProcessor;
import org.eclipse.gemoc.dsl.debug.ide.event.debugger.BreakpointReply;
import org.eclipse.gemoc.dsl.debug.ide.event.debugger.DeleteVariableReply;
import org.eclipse.gemoc.dsl.debug.ide.event.debugger.PopStackFrameReply;
import org.eclipse.gemoc.dsl.debug.ide.event.debugger.PushStackFrameReply;
import org.eclipse.gemoc.dsl.debug.ide.event.debugger.ResumingReply;
import org.eclipse.gemoc.dsl.debug.ide.event.debugger.SetCurrentInstructionReply;
import org.eclipse.gemoc.dsl.debug.ide.event.debugger.SetVariableValueReply;
import org.eclipse.gemoc.dsl.debug.ide.event.debugger.SpawnRunningThreadReply;
import org.eclipse.gemoc.dsl.debug.ide.event.debugger.StepIntoResumingReply;
import org.eclipse.gemoc.dsl.debug.ide.event.debugger.StepOverResumingReply;
import org.eclipse.gemoc.dsl.debug.ide.event.debugger.StepReturnResumingReply;
import org.eclipse.gemoc.dsl.debug.ide.event.debugger.SteppedReply;
import org.eclipse.gemoc.dsl.debug.ide.event.debugger.SuspendedReply;
import org.eclipse.gemoc.dsl.debug.ide.event.debugger.TerminatedReply;
import org.eclipse.gemoc.dsl.debug.ide.event.debugger.VariableReply;
import org.eclipse.gemoc.dsl.debug.ide.event.model.AbstractBreakpointRequest;
import org.eclipse.gemoc.dsl.debug.ide.event.model.AbstractStepRequest;
import org.eclipse.gemoc.dsl.debug.ide.event.model.AddBreakpointRequest;
import org.eclipse.gemoc.dsl.debug.ide.event.model.ChangeBreakPointRequest;
import org.eclipse.gemoc.dsl.debug.ide.event.model.DisconnectRequest;
import org.eclipse.gemoc.dsl.debug.ide.event.model.RemoveBreakpointRequest;
import org.eclipse.gemoc.dsl.debug.ide.event.model.ResumeRequest;
import org.eclipse.gemoc.dsl.debug.ide.event.model.SetVariableValueRequest;
import org.eclipse.gemoc.dsl.debug.ide.event.model.StartRequest;
import org.eclipse.gemoc.dsl.debug.ide.event.model.StepIntoRequest;
import org.eclipse.gemoc.dsl.debug.ide.event.model.StepOverRequest;
import org.eclipse.gemoc.dsl.debug.ide.event.model.StepReturnRequest;
import org.eclipse.gemoc.dsl.debug.ide.event.model.SuspendRequest;
import org.eclipse.gemoc.dsl.debug.ide.event.model.TerminateRequest;
import org.eclipse.gemoc.dsl.debug.ide.event.model.ValidateVariableValueRequest;

public abstract class AbstractDSLDebugger
implements IDSLDebugger {
    protected final IDSLDebugEventProcessor target;
    protected final Map<String, EObject> currentInstructions = new HashMap<String, EObject>();
    private boolean terminated;
    private final Map<String, ThreadController> controllers = new ConcurrentHashMap<String, ThreadController>();
    private final Map<URI, Map<String, Serializable>> breakpoints = new HashMap<URI, Map<String, Serializable>>();

    public AbstractDSLDebugger(IDSLDebugEventProcessor target) {
        this.target = target;
    }

    @Override
    public Object handleEvent(IDSLDebugEvent event) {
        Object res = null;
        if (event instanceof DisconnectRequest) {
            this.disconnect();
        } else if (event instanceof AbstractStepRequest) {
            this.handleStepRequest((AbstractStepRequest)event);
        } else if (event instanceof ResumeRequest) {
            this.handleResumeRequest((ResumeRequest)event);
        } else if (event instanceof SuspendRequest) {
            this.handleSuspendRequest((SuspendRequest)event);
        } else if (event instanceof TerminateRequest) {
            this.handleTerminateRequest((TerminateRequest)event);
        } else if (event instanceof AbstractBreakpointRequest) {
            this.handleBreakpointRequest((AbstractBreakpointRequest)event);
        } else if (event instanceof ValidateVariableValueRequest) {
            res = this.handleValidateVariableValueRequest((ValidateVariableValueRequest)event);
        } else if (event instanceof SetVariableValueRequest) {
            this.handleSetVariableValueRequest((SetVariableValueRequest)event);
        } else if (event instanceof StartRequest) {
            this.start();
        }
        return res;
    }

    private void handleSetVariableValueRequest(SetVariableValueRequest event) {
        Object value = this.getVariableValue(event.getThreadName(), event.getStackName(), event.getVariableName(), event.getValue());
        this.setVariableValue(event.getThreadName(), event.getStackName(), event.getVariableName(), value);
        this.target.handleEvent(new SetVariableValueReply(event.getThreadName(), event.getStackName(), event.getVariableName(), value));
    }

    private Object handleValidateVariableValueRequest(ValidateVariableValueRequest event) {
        return this.validateVariableValue(event.getThreadName(), event.getVariableName(), event.getValue());
    }

    private void handleBreakpointRequest(AbstractBreakpointRequest breakpointRequest) {
        if (breakpointRequest instanceof AddBreakpointRequest) {
            this.addBreakPoint(breakpointRequest.getURI());
        } else if (breakpointRequest instanceof RemoveBreakpointRequest) {
            this.removeBreakPoint(breakpointRequest.getURI());
        } else if (breakpointRequest instanceof ChangeBreakPointRequest) {
            this.changeBreakPoint(breakpointRequest.getURI(), ((ChangeBreakPointRequest)breakpointRequest).getAttribute(), ((ChangeBreakPointRequest)breakpointRequest).getValue());
        }
    }

    private void handleTerminateRequest(TerminateRequest terminateRequest) {
        String threadName = terminateRequest.getThreadName();
        if (threadName != null) {
            this.terminate(threadName);
        } else {
            this.terminate();
            this.target.handleEvent(new TerminatedReply());
        }
    }

    private void handleSuspendRequest(SuspendRequest suspendRequest) {
        String threadName = suspendRequest.getThreadName();
        if (threadName != null) {
            this.suspend(threadName);
        } else {
            this.suspend();
        }
    }

    private void handleResumeRequest(ResumeRequest resumeRequest) {
        String threadName = resumeRequest.getThreadName();
        if (threadName != null) {
            this.resume(threadName);
        } else {
            this.resume();
        }
    }

    private void handleStepRequest(AbstractStepRequest stepRequest) {
        String threadName = stepRequest.getThreadName();
        if (stepRequest.getInstrcution() != this.currentInstructions.get(threadName)) {
            throw new IllegalStateException("instruction desynchronization.");
        }
        if (stepRequest instanceof StepIntoRequest) {
            this.stepInto(threadName);
        } else if (stepRequest instanceof StepOverRequest) {
            this.stepOver(threadName);
        } else if (stepRequest instanceof StepReturnRequest) {
            this.stepReturn(threadName);
        }
    }

    @Override
    public void stepped(String threadName) {
        this.target.handleEvent(new SteppedReply(threadName));
    }

    @Override
    public void suspended(String threadName) {
        this.target.handleEvent(new SuspendedReply(threadName));
    }

    @Override
    public void breaked(String threadName) {
        this.target.handleEvent(new BreakpointReply(threadName));
    }

    @Override
    public void resuming(String threadName) {
        this.target.handleEvent(new ResumingReply(threadName));
    }

    @Override
    public void steppingInto(String threadName) {
        this.target.handleEvent(new StepIntoResumingReply(threadName));
    }

    @Override
    public void steppingOver(String threadName) {
        this.target.handleEvent(new StepOverResumingReply(threadName));
    }

    @Override
    public void steppingReturn(String threadName) {
        this.target.handleEvent(new StepReturnResumingReply(threadName));
    }

    @Override
    public void terminated() {
        this.target.handleEvent(new TerminatedReply());
    }

    @Override
    public void spawnRunningThread(String threadName, EObject context) {
        this.target.handleEvent(new SpawnRunningThreadReply(threadName, context));
        this.controllers.put(threadName, this.createThreadHandler(threadName));
    }

    protected ThreadController createThreadHandler(String threadName) {
        return new ThreadController(this, threadName);
    }

    @Override
    public void setTerminated(boolean terminated) {
        this.terminated = terminated;
    }

    @Override
    public boolean isTerminated() {
        return this.terminated;
    }

    @Override
    public EObject getNextInstruction(String threadName, EObject currentInstruction, IDSLDebugger.Stepping stepping) {
        return null;
    }

    @Override
    public boolean shouldBreak(EObject instruction) {
        boolean res = this.getBreakpointAttributes(instruction, "org.eclipse.debug.core.enabled") == Boolean.TRUE;
        return res;
    }

    protected Serializable getBreakpointAttributes(EObject instruction, String attribute) {
        Map<String, Serializable> attributes = this.breakpoints.get(EcoreUtil.getURI((EObject)instruction));
        Serializable res = attributes != null ? attributes.get(attribute) : null;
        return res;
    }

    @Override
    public void addBreakPoint(URI instruction) {
        this.breakpoints.put(instruction, new HashMap());
    }

    @Override
    public void removeBreakPoint(URI instruction) {
        this.breakpoints.remove(instruction);
    }

    @Override
    public void changeBreakPoint(URI instruction, String attribute, Serializable value) {
        Map<String, Serializable> attributes = this.breakpoints.get(instruction);
        attributes.put(attribute, value);
    }

    @Override
    public boolean control(String threadName, EObject instruction) {
        boolean res = !this.isTerminated() ? this.controllers.get(threadName).control(instruction) : false;
        return res;
    }

    @Override
    public void resume(String threadName) {
        this.controllers.get(threadName).resume();
    }

    @Override
    public void stepInto(String threadName) {
        this.controllers.get(threadName).stepInto();
    }

    @Override
    public void stepOver(String threadName) {
        this.controllers.get(threadName).stepOver();
    }

    @Override
    public void stepReturn(String threadName) {
        this.controllers.get(threadName).stepReturn();
    }

    @Override
    public void suspend(String threadName) {
        this.controllers.get(threadName).suspend();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate() {
        this.setTerminated(true);
        Iterator<ThreadController> iterator = this.controllers.values().iterator();
        while (iterator.hasNext()) {
            ThreadController controler;
            ThreadController threadController = controler = iterator.next();
            synchronized (threadController) {
                controler.wakeUp();
            }
        }
        this.controllers.clear();
    }

    @Override
    public void terminate(String threadName) {
        this.controllers.get(threadName).terminate();
    }

    @Override
    public void suspend() {
        for (ThreadController controler : this.controllers.values()) {
            controler.suspend();
        }
    }

    @Override
    public void resume() {
        for (ThreadController controler : this.controllers.values()) {
            controler.resume();
        }
    }

    @Override
    public void variable(String threadName, String stackName, String declarationTypeName, String variableName, Object value, boolean supportModifications) {
        this.target.handleEvent(new VariableReply(threadName, stackName, declarationTypeName, variableName, value, supportModifications));
    }

    @Override
    public void deleteVariable(String threadName, String name) {
        this.target.handleEvent(new DeleteVariableReply(threadName, name));
    }

    @Override
    public void pushStackFrame(String threadName, String frameName, EObject context, EObject instruction) {
        this.currentInstructions.put(threadName, instruction);
        this.target.handleEvent(new PushStackFrameReply(threadName, frameName, context, instruction, this.canStepInto(threadName, instruction)));
    }

    @Override
    public void popStackFrame(String threadName) {
        this.target.handleEvent(new PopStackFrameReply(threadName));
    }

    @Override
    public void setCurrentInstruction(String threadName, EObject instruction) {
        this.currentInstructions.put(threadName, instruction);
        this.target.handleEvent(new SetCurrentInstructionReply(threadName, instruction, this.canStepInto(threadName, instruction)));
    }

    @Override
    public void terminated(String threadName) {
        this.target.handleEvent(new TerminatedReply(threadName));
        this.controllers.remove(threadName);
        if (this.controllers.size() == 0) {
            this.setTerminated(true);
            this.terminated();
        }
    }

    @Override
    public boolean isTerminated(String threadName) {
        return !this.controllers.containsKey(threadName);
    }
}

