/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures.util;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.sirius.ext.draw2d.figure.ImageFigureWithAlpha;

public class OpaquePixelFinder {
    private int alphaLimit = 15;

    public OpaquePixelFinder() {
    }

    public OpaquePixelFinder(int alphaLimit) {
        this.setAlphaLimit(alphaLimit);
    }

    public void setAlphaLimit(int alphaLimit) {
        this.alphaLimit = alphaLimit;
    }

    public Point searchFirstOpaquePoint(int orientation, Point initialCursorLocation, ImageFigureWithAlpha imageFigure, Rectangle box) {
        if (box != null && box.width > 0 && box.height > 0) {
            int sideToStartSearchFrom = this.computeSideToStartFrom(orientation, initialCursorLocation, box);
            Point searchCursor = new Point(0, 0);
            Point primaryScanStep = new Point(0, 0);
            Point secondaryScanStep = new Point(0, 0);
            switch (sideToStartSearchFrom) {
                case 1: {
                    primaryScanStep.x = 1;
                    secondaryScanStep.y = 1;
                    searchCursor.y = initialCursorLocation.y - box.getTopLeft().y;
                    break;
                }
                case 4: {
                    primaryScanStep.x = -1;
                    secondaryScanStep.y = 1;
                    searchCursor.setLocation(box.width - 1, initialCursorLocation.y - box.getTopLeft().y);
                    break;
                }
                case 8: {
                    primaryScanStep.y = 1;
                    secondaryScanStep.x = 1;
                    searchCursor.x = initialCursorLocation.x - box.getTopLeft().x;
                    break;
                }
                case 32: {
                    primaryScanStep.y = -1;
                    secondaryScanStep.x = 1;
                    searchCursor.setLocation(initialCursorLocation.x - box.getTopLeft().x, box.height - 1);
                    break;
                }
            }
            if (primaryScanStep.x != 0 || primaryScanStep.y != 0) {
                searchCursor = this.searchFirstOpaquePoint(searchCursor, sideToStartSearchFrom, primaryScanStep, secondaryScanStep, imageFigure, box);
            }
            return box.getTopLeft().getCopy().translate(searchCursor.x, searchCursor.y);
        }
        return initialCursorLocation;
    }

    public Point searchFirstOpaquePoint(Point initialCursor, int startSearchFromSide, Point primaryScanStep, Point secondaryScanStep, ImageFigureWithAlpha imageFigure, Rectangle box) {
        boolean foundAnOpaquePixel = false;
        int nbIteration = 0;
        Point searchCursor = new Point(initialCursor);
        while (!(foundAnOpaquePixel || nbIteration != 0 && this.isOut(box, secondaryScanStep.getScaled((double)nbIteration)) && this.isOut(box, secondaryScanStep.getNegated().getScaled((double)nbIteration)))) {
            searchCursor.translate(secondaryScanStep.getScaled((double)nbIteration));
            searchCursor = this.searchFirstOpaquePointOnPrimaryAxis(searchCursor, primaryScanStep, imageFigure, box);
            if (this.isOut(box, searchCursor)) {
                searchCursor.setLocation(initialCursor);
                searchCursor.translate(secondaryScanStep.getNegated().getScaled((double)nbIteration));
                searchCursor = this.searchFirstOpaquePointOnPrimaryAxis(searchCursor, primaryScanStep, imageFigure, box);
            }
            if (this.isOut(box, searchCursor)) {
                ++nbIteration;
                searchCursor.setLocation(initialCursor);
                continue;
            }
            foundAnOpaquePixel = true;
        }
        return searchCursor;
    }

    private Point searchFirstOpaquePointOnPrimaryAxis(Point searchCursor, Point primaryScanStep, ImageFigureWithAlpha imageFigure, Rectangle box) {
        while (!this.isOut(box, searchCursor) && this.isTransparentAt(imageFigure, searchCursor.x, searchCursor.y, box)) {
            searchCursor.translate(primaryScanStep);
        }
        return searchCursor;
    }

    protected int getAlphaLimit() {
        return this.alphaLimit;
    }

    private boolean isOut(Rectangle box, Point point) {
        return box.width - Math.abs(point.x) < 0 || box.height - Math.abs(point.y) < 0;
    }

    private int computeSideToStartFrom(int orientation, Point anchorForBoundingBox, Rectangle box) {
        LineSeg anchorToCenter;
        int startSearchFromSide = 8;
        Point boxCenter = box.getCenter();
        startSearchFromSide = orientation == 128 ? (anchorForBoundingBox.y >= boxCenter.y ? 32 : 8) : (orientation == 64 ? (anchorForBoundingBox.x >= boxCenter.x ? 4 : 1) : ((anchorToCenter = new LineSeg(anchorForBoundingBox, boxCenter)).intersect(new LineSeg(box.getTopLeft(), box.getTopRight()), 3) != null ? 8 : (anchorToCenter.intersect(new LineSeg(box.getTopLeft(), box.getBottomLeft()), 3) != null ? 1 : (anchorToCenter.intersect(new LineSeg(box.getBottomLeft(), box.getBottomRight()), 3) != null ? 32 : 4))));
        return startSearchFromSide;
    }

    private boolean isTransparentAt(ImageFigureWithAlpha fig, int xInBox, int yInBox, Rectangle box) {
        int transValue;
        int imageWidth = fig.getImageWidth();
        int imageHeight = fig.getImageHeight();
        int x = xInBox * imageWidth / box.width;
        int y = yInBox * imageHeight / box.height;
        if (x < 0 || x >= imageWidth || y < 0 || y >= imageHeight) {
            return true;
        }
        int n = transValue = fig.getImageAlphaValue(x, y) == 0 ? 0 : 255;
        return transValue <= this.getAlphaLimit();
    }
}

