/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.dsl.debug;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DebugTargetState implements Enumerator
{
    CONNECTED(0, "CONNECTED", "CONNECTED"),
    DISCONNECTED(1, "DISCONNECTED", "DISCONNECTED"),
    TERMINATING(2, "TERMINATING", "TERMINATING"),
    TERMINATED(3, "TERMINATED", "TERMINATED");

    public static final String copyright = "Copyright (c) 2015 Obeo.\n All rights reserved. This program and the accompanying materials\n are made available under the terms of the Eclipse Public License v1.0\n which accompanies this distribution, and is available at\n http://www.eclipse.org/legal/epl-v10.html\n \n Contributors:\n    Obeo - initial API and implementation";
    public static final int CONNECTED_VALUE = 0;
    public static final int DISCONNECTED_VALUE = 1;
    public static final int TERMINATING_VALUE = 2;
    public static final int TERMINATED_VALUE = 3;
    private static final DebugTargetState[] VALUES_ARRAY;
    public static final List<DebugTargetState> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DebugTargetState[]{CONNECTED, DISCONNECTED, TERMINATING, TERMINATED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DebugTargetState get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DebugTargetState result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DebugTargetState getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DebugTargetState result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DebugTargetState get(int value) {
        switch (value) {
            case 0: {
                return CONNECTED;
            }
            case 1: {
                return DISCONNECTED;
            }
            case 2: {
                return TERMINATING;
            }
            case 3: {
                return TERMINATED;
            }
        }
        return null;
    }

    private DebugTargetState(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

