/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.optional.imageio;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import org.apache.tools.ant.types.optional.imageio.BasicShape;
import org.apache.tools.ant.types.optional.imageio.ColorMapper;
import org.apache.tools.ant.types.optional.imageio.DrawOperation;
import org.apache.tools.ant.types.optional.imageio.ImageOperation;
import org.apache.tools.ant.types.optional.imageio.TransformOperation;

public class Ellipse
extends BasicShape
implements DrawOperation {
    @Override
    public BufferedImage executeDrawOperation() {
        BufferedImage bi = new BufferedImage(this.width, this.height, 7);
        Graphics2D graphics = bi.createGraphics();
        if (!"transparent".equalsIgnoreCase(this.stroke)) {
            BasicStroke bStroke = new BasicStroke(this.strokeWidth);
            graphics.setColor(ColorMapper.getColorByName(this.stroke));
            graphics.setStroke(bStroke);
            graphics.draw(new Ellipse2D.Double(0.0, 0.0, this.width, this.height));
        }
        if (!"transparent".equalsIgnoreCase(this.fill)) {
            graphics.setColor(ColorMapper.getColorByName(this.fill));
            graphics.fill(new Ellipse2D.Double(0.0, 0.0, this.width, this.height));
        }
        for (ImageOperation instr : this.instructions) {
            if (instr instanceof DrawOperation) {
                BufferedImage img = ((DrawOperation)((Object)instr)).executeDrawOperation();
                graphics.drawImage(img, null, 0, 0);
                continue;
            }
            if (!(instr instanceof TransformOperation)) continue;
            bi = ((TransformOperation)instr).executeTransformOperation(bi);
            graphics = bi.createGraphics();
        }
        return bi;
    }
}

