/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.engine.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gemoc.executionframework.engine.Activator;
import org.eclipse.gemoc.xdsmlframework.api.core.IRunConfiguration;
import org.eclipse.gemoc.xdsmlframework.api.extensions.engine_addon.EngineAddonSpecificationExtension;
import org.eclipse.gemoc.xdsmlframework.api.extensions.engine_addon.EngineAddonSpecificationExtensionPoint;
import org.eclipse.gemoc.xdsmlframework.api.extensions.languages.LanguageDefinitionExtension;
import org.eclipse.gemoc.xdsmlframework.api.extensions.languages.LanguageDefinitionExtensionPoint;

public class RunConfiguration
implements IRunConfiguration {
    protected ILaunchConfiguration _launchConfiguration;
    private int _animationDelay = 0;
    private URI _modelURI;
    private String _melangeQuery = "";
    private URI _animatorURI;
    private HashMap<EngineAddonSpecificationExtension, Boolean> _engineAddonExtensions = new HashMap();
    private String _languageName;
    private boolean _breakStart;
    private String _debugModelID;

    public RunConfiguration(ILaunchConfiguration launchConfiguration) throws CoreException {
        this._launchConfiguration = launchConfiguration;
        this.extractInformation();
    }

    protected void extractInformation() throws CoreException {
        this._languageName = this.getAttribute("GEMOC_LAUNCH_SELECTED_LANGUAGE", "");
        this._modelURI = URI.createPlatformResourceURI((String)this.getAttribute("Resource", ""), (boolean)true);
        String animatorURIAsString = this.getAttribute("airdResource", "");
        if (animatorURIAsString != null && !animatorURIAsString.equals("")) {
            this._animatorURI = URI.createPlatformResourceURI((String)animatorURIAsString, (boolean)true);
            this._animationDelay = this.getAttribute("GEMOC_ANIMATE_DELAY", 0);
        }
        this._melangeQuery = this.getAttribute("GEMOC_LAUNCH_MELANGE_QUERY", "");
        for (EngineAddonSpecificationExtension extension : EngineAddonSpecificationExtensionPoint.getSpecifications()) {
            String extensionName = extension.getName() != null ? extension.getName() : extension.getId();
            this._engineAddonExtensions.put(extension, this.getAttribute(extensionName, extension.getDefaultActivationValue()));
        }
        LanguageDefinitionExtension langDefExtension = LanguageDefinitionExtensionPoint.findDefinition((String)this._languageName);
        if (langDefExtension != null) {
            for (EngineAddonSpecificationExtension extension : langDefExtension.getLanguageSpecificEngineAddonSpecificationExtensions()) {
                String extensionName = extension.getName() != null ? extension.getName() : extension.getId();
                this._engineAddonExtensions.put(extension, this.getAttribute(extensionName, extension.getDefaultActivationValue()));
            }
        }
        this._breakStart = this.getAttribute("GEMOC_LAUNCH_BREAK_START", Boolean.FALSE);
        this._debugModelID = this.getAttribute("GEMOC_DEBUG_MODEL_ID", ".debugModel");
    }

    public String getAttribute(String attributeName, String defaultValue) {
        try {
            return this._launchConfiguration.getAttribute(attributeName, defaultValue);
        }
        catch (CoreException e) {
            Activator.getDefault().error(e.getMessage(), e);
            return defaultValue;
        }
    }

    public Integer getAttribute(String attributeName, Integer defaultValue) {
        try {
            return this._launchConfiguration.getAttribute(attributeName, defaultValue.intValue());
        }
        catch (CoreException e) {
            Activator.getDefault().error(e.getMessage(), e);
            return defaultValue;
        }
    }

    public Boolean getAttribute(String attributeName, Boolean defaultValue) {
        try {
            return this._launchConfiguration.getAttribute(attributeName, defaultValue.booleanValue());
        }
        catch (CoreException e) {
            Activator.getDefault().error(e.getMessage(), e);
            return defaultValue;
        }
    }

    public Map<String, String> getAttribute(String attributeName, Map<String, String> defaultValue) {
        try {
            return this._launchConfiguration.getAttribute(attributeName, defaultValue);
        }
        catch (CoreException e) {
            Activator.getDefault().error(e.getMessage(), e);
            return defaultValue;
        }
    }

    public Set<String> getAttribute(String attributeName, Set<String> defaultValue) {
        try {
            return this._launchConfiguration.getAttribute(attributeName, defaultValue);
        }
        catch (CoreException e) {
            Activator.getDefault().error(e.getMessage(), e);
            return defaultValue;
        }
    }

    public int getAnimationDelay() {
        return this._animationDelay;
    }

    public URI getExecutedModelURI() {
        return this._modelURI;
    }

    public String getMelangeQuery() {
        return this._melangeQuery;
    }

    public URI getExecutedModelAsMelangeURI() {
        if (this._melangeQuery.isEmpty()) {
            return this._modelURI;
        }
        String melangeURIString = String.valueOf(this._modelURI.toString().replace("platform:/", "melange:/")) + this._melangeQuery;
        return URI.createURI((String)melangeURIString);
    }

    public URI getAnimatorURI() {
        return this._animatorURI;
    }

    public Collection<EngineAddonSpecificationExtension> getEngineAddonExtensions() {
        ArrayList<EngineAddonSpecificationExtension> result = new ArrayList<EngineAddonSpecificationExtension>();
        for (Map.Entry<EngineAddonSpecificationExtension, Boolean> e : this._engineAddonExtensions.entrySet()) {
            if (!e.getValue().booleanValue()) continue;
            result.add(e.getKey());
        }
        return result;
    }

    public String getLanguageName() {
        return this._languageName;
    }

    public boolean getBreakStart() {
        return this._breakStart;
    }

    public String getDebugModelID() {
        return this._debugModelID;
    }
}

