/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.engine.commons;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.osgi.framework.Bundle;

public class MelangeHelper {
    public static Bundle getMelangeBundle(String languageName) {
        IConfigurationElement[] melangeLanguages = Platform.getExtensionRegistry().getConfigurationElementsFor("fr.inria.diverse.melange.language");
        String melangeBundleName = "";
        IConfigurationElement[] iConfigurationElementArray = melangeLanguages;
        int n = melangeLanguages.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement lang = iConfigurationElementArray[n2];
            if (lang.getAttribute("id").equals(languageName)) {
                melangeBundleName = lang.getContributor().getName();
                return Platform.getBundle((String)melangeBundleName);
            }
            ++n2;
        }
        return null;
    }

    public static List<String> getAllMelangeLanguages() {
        IConfigurationElement[] melangeLanguages;
        ArrayList<String> languagesNames = new ArrayList<String>();
        IConfigurationElement[] iConfigurationElementArray = melangeLanguages = Platform.getExtensionRegistry().getConfigurationElementsFor("fr.inria.diverse.melange.language");
        int n = melangeLanguages.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement lang = iConfigurationElementArray[n2];
            languagesNames.add(lang.getAttribute("id"));
            ++n2;
        }
        return languagesNames;
    }

    public static String getLanguageURI(String languageId) {
        IConfigurationElement[] melangeLanguages;
        IConfigurationElement[] iConfigurationElementArray = melangeLanguages = Platform.getExtensionRegistry().getConfigurationElementsFor("fr.inria.diverse.melange.language");
        int n = melangeLanguages.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement lang = iConfigurationElementArray[n2];
            if (lang.getAttribute("id").equals(languageId)) {
                return lang.getAttribute("uri");
            }
            ++n2;
        }
        return null;
    }

    public static String getLanguageNameForURI(String uri) {
        IConfigurationElement[] melangeLanguages;
        IConfigurationElement[] iConfigurationElementArray = melangeLanguages = Platform.getExtensionRegistry().getConfigurationElementsFor("fr.inria.diverse.melange.language");
        int n = melangeLanguages.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement lang = iConfigurationElementArray[n2];
            if (lang.getAttribute("uri").equals(uri)) {
                return lang.getAttribute("id");
            }
            ++n2;
        }
        return null;
    }

    public static List<String> getLanguageNamesForURI(String uri) {
        IConfigurationElement[] melangeLanguages;
        ArrayList<String> languagesNames = new ArrayList<String>();
        IConfigurationElement[] iConfigurationElementArray = melangeLanguages = Platform.getExtensionRegistry().getConfigurationElementsFor("fr.inria.diverse.melange.language");
        int n = melangeLanguages.length;
        int n2 = 0;
        while (n2 < n) {
            String id;
            IConfigurationElement lang = iConfigurationElementArray[n2];
            if (lang.getAttribute("uri").equals(uri) && !languagesNames.contains(id = lang.getAttribute("id"))) {
                languagesNames.add(id);
            }
            ++n2;
        }
        return languagesNames;
    }

    public static List<String> getNativeLanguagesUsedByResource(Resource res) {
        LinkedHashSet<String> usedLanguages = new LinkedHashSet<String>();
        for (EObject eobj : res.getContents()) {
            usedLanguages.addAll(MelangeHelper.getLanguageNamesForURI(eobj.eClass().eResource().getURI().toString()));
        }
        ArrayList<String> languagesNames = new ArrayList<String>();
        languagesNames.addAll(usedLanguages);
        return languagesNames;
    }

    public static List<String> getModelTypes(String language) {
        IConfigurationElement[] melangeLanguages;
        ArrayList<String> modelTypeNames = new ArrayList<String>();
        IConfigurationElement[] iConfigurationElementArray = melangeLanguages = Platform.getExtensionRegistry().getConfigurationElementsFor("fr.inria.diverse.melange.language");
        int n = melangeLanguages.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement lang = iConfigurationElementArray[n2];
            if (lang.getAttribute("id").equals(language)) {
                IConfigurationElement[] adapters;
                IConfigurationElement[] iConfigurationElementArray2 = adapters = lang.getChildren("adapter");
                int n3 = adapters.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement adapter = iConfigurationElementArray2[n4];
                    modelTypeNames.add(adapter.getAttribute("modeltypeId"));
                    ++n4;
                }
            }
            ++n2;
        }
        return modelTypeNames;
    }

    public static String getModelType(String language) {
        IConfigurationElement[] melangeLanguages;
        IConfigurationElement[] iConfigurationElementArray = melangeLanguages = Platform.getExtensionRegistry().getConfigurationElementsFor("fr.inria.diverse.melange.language");
        int n = melangeLanguages.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement lang = iConfigurationElementArray[n2];
            if (lang.getAttribute("id").equals(language)) {
                return lang.getAttribute("modeltypeId");
            }
            ++n2;
        }
        return null;
    }
}

