package fr.inria.diverse.k3.al.annotationprocessor;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.xtend.lib.macro.CodeGenerationContext;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.CompilationUnit;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.file.Path;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * Provides methods for managing the generation of the static dispatch in the current project
 */
@SuppressWarnings("all")
public class ProjectStaticDispatchBuilder {
  public static final String STATICDISPATCH_GENFOLDER = "staticdispatch-gen";
  
  public static final String INCREMENTALSTATICDISPATCH_FILEEXT = "isdp";
  
  private final Set<String> dispatchStaticInjection = CollectionLiterals.<String>newHashSet();
  
  /**
   * @param context code generation context
   */
  public void writeTempStaticDispatchFile(final CompilationUnit compilationUnit, @Extension final CodeGenerationContext context) {
    final Path fileRelativePath = compilationUnit.getFilePath().relativize(context.getSourceFolder(compilationUnit.getFilePath()));
    final String destFileName = fileRelativePath.toString().replaceAll("/", ".");
    Path targetFilePath = context.getProjectFolder(compilationUnit.getFilePath()).append(
      ((((("/" + ProjectStaticDispatchBuilder.STATICDISPATCH_GENFOLDER) + "/") + destFileName) + ".") + ProjectStaticDispatchBuilder.INCREMENTALSTATICDISPATCH_FILEEXT));
    boolean _isEmpty = this.dispatchStaticInjection.isEmpty();
    boolean _not = (!_isEmpty);
    if (_not) {
      final String contents = IterableExtensions.join(this.dispatchStaticInjection, "\n");
      Helper.writeContentsIfNew(targetFilePath, contents, context);
    } else {
      boolean _exists = context.exists(targetFilePath);
      if (_exists) {
        context.delete(targetFilePath);
      }
    }
  }
  
  /**
   * remove dispatch file that looks to be irrelevant for the build due to missing equivalent xtend files
   */
  public void cleanDeprecatedDispatchFiles(final CompilationUnit compilationUnit, @Extension final CodeGenerationContext context) {
    Path folderPath = context.getProjectFolder(compilationUnit.getFilePath()).append(("/" + ProjectStaticDispatchBuilder.STATICDISPATCH_GENFOLDER));
    final Function1<Path, Boolean> _function = (Path f) -> {
      return Boolean.valueOf(((f.getFileExtension() != null) && Objects.equal(f.getFileExtension(), ProjectStaticDispatchBuilder.INCREMENTALSTATICDISPATCH_FILEEXT)));
    };
    final Iterable<? extends Path> childWithCorrectExtension = IterableExtensions.filter(context.getChildren(folderPath), _function);
    final Set<Path> sourceFolders = context.getProjectSourceFolders(compilationUnit.getCompilationUnit().getFilePath());
    final Consumer<Path> _function_1 = (Path f) -> {
      final String intermediate = f.getLastSegment().toString().replaceAll("\\.", "/");
      boolean _endsWith = intermediate.endsWith(("/xtend/" + ProjectStaticDispatchBuilder.INCREMENTALSTATICDISPATCH_FILEEXT));
      if (_endsWith) {
        String _substring = intermediate.substring(0, intermediate.lastIndexOf(("/xtend/" + ProjectStaticDispatchBuilder.INCREMENTALSTATICDISPATCH_FILEEXT)));
        final String srcXtendFile = (_substring + ".xtend");
        final Function1<Path, Boolean> _function_2 = (Path sfolder) -> {
          return Boolean.valueOf(context.exists(sfolder.append(srcXtendFile)));
        };
        boolean _exists = IterableExtensions.<Path>exists(sourceFolders, _function_2);
        boolean _not = (!_exists);
        if (_not) {
          context.delete(f);
        }
      }
    };
    childWithCorrectExtension.forEach(_function_1);
  }
  
  public boolean add(final String dispatchInjectCodeForParent) {
    return this.dispatchStaticInjection.add(dispatchInjectCodeForParent);
  }
  
  /**
   * retrieves a list of applicable method dispatch for the parent method
   * Looks into the current project resources for stored files with dispatch to inject
   */
  public List<String> findExistingDispatchCalls(final MutableMethodDeclaration methodDecl, @Extension final TransformationContext context) {
    final String targetClassQName = methodDecl.getDeclaringType().getQualifiedName();
    boolean _isEmpty = this.dispatchCodeForClass.isEmpty();
    if (_isEmpty) {
      Path folderPath = context.getProjectFolder(methodDecl.getCompilationUnit().getFilePath()).append(("/" + ProjectStaticDispatchBuilder.STATICDISPATCH_GENFOLDER));
      final Function1<Path, Boolean> _function = (Path f) -> {
        return Boolean.valueOf(((f.getFileExtension() != null) && Objects.equal(f.getFileExtension(), ProjectStaticDispatchBuilder.INCREMENTALSTATICDISPATCH_FILEEXT)));
      };
      final Iterable<? extends Path> validChild = IterableExtensions.filter(context.getChildren(folderPath), _function);
      final Consumer<Path> _function_1 = (Path f) -> {
        this.parseAndCacheDispatchStaticInjection(context.getContents(f).toString());
      };
      validChild.forEach(_function_1);
    }
    HashMap<String, List<String>> _get = this.dispatchCodeForClass.get(targetClassQName);
    boolean _tripleEquals = (_get == null);
    if (_tripleEquals) {
      return Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList());
    }
    final List<String> result = this.dispatchCodeForClass.get(targetClassQName).get(Helper.initialMethodSignature(methodDecl));
    if ((result != null)) {
      return result;
    } else {
      return Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList());
    }
  }
  
  private void addDispatchCodeInCache(final String targetClass, final String targetMethod, final String dispatchCode) {
    HashMap<String, List<String>> _get = this.dispatchCodeForClass.get(targetClass);
    boolean _tripleEquals = (_get == null);
    if (_tripleEquals) {
      HashMap<String, List<String>> _hashMap = new HashMap<String, List<String>>();
      this.dispatchCodeForClass.put(targetClass, _hashMap);
    }
    final HashMap<String, List<String>> targetClassEntry = this.dispatchCodeForClass.get(targetClass);
    List<String> _get_1 = targetClassEntry.get(targetMethod);
    boolean _tripleEquals_1 = (_get_1 == null);
    if (_tripleEquals_1) {
      ArrayList<String> _arrayList = new ArrayList<String>();
      targetClassEntry.put(targetMethod, _arrayList);
    }
    targetClassEntry.get(targetMethod).add(dispatchCode);
  }
  
  /**
   * cache to avoid reading file content too often
   * first key : target class qualified name
   * second key : target method
   * value : list of code to inject
   */
  private final HashMap<String, HashMap<String, List<String>>> dispatchCodeForClass = new HashMap<String, HashMap<String, List<String>>>();
  
  /**
   * scan string content for method dispatch that apply to the targetAspectClass
   * the result is sorted in the cache
   */
  public void parseAndCacheDispatchStaticInjection(final String content) {
    final Scanner scanner = new Scanner(content);
    StringBuilder sb = new StringBuilder();
    String currentTargetMethod = "";
    String currentTargetClass = "";
    final Pattern regexTargetAspectClass = Pattern.compile("// BeginInjectInto ([^#]+)*#");
    final Pattern regexTargetMethod = Pattern.compile("#([^#].+\\))");
    while (scanner.hasNextLine()) {
      {
        final String currentLine = scanner.nextLine();
        boolean _contains = currentLine.contains("// BeginInjectInto");
        if (_contains) {
          final Matcher tclassmatcher = regexTargetAspectClass.matcher(currentLine);
          boolean _find = tclassmatcher.find();
          if (_find) {
            currentTargetClass = tclassmatcher.group(1);
            final Matcher tmethodmatcher = regexTargetMethod.matcher(currentLine);
            boolean _find_1 = tmethodmatcher.find();
            if (_find_1) {
              currentTargetMethod = tmethodmatcher.group(1);
            }
          }
          sb.append(currentLine);
          sb.append("\n");
        } else {
          boolean _contains_1 = currentLine.contains("// EndInjectInto");
          if (_contains_1) {
            sb.append(currentLine);
            sb.append("\n");
            this.addDispatchCodeInCache(currentTargetClass, currentTargetMethod, sb.toString());
            StringBuilder _stringBuilder = new StringBuilder();
            sb = _stringBuilder;
          } else {
            sb.append(currentLine);
            sb.append("\n");
          }
        }
      }
    }
  }
}
