/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.power.view;

import fr.inria.aoste.timesquare.backend.power.view.PowerView;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;

public class Ruler
extends Polyline
implements PowerView.IPowerViewFigure {
    private Panel contents = null;
    public HV hv = null;
    private int lenght = 0;
    private final int x;
    private final int y;
    private final int scale;
    private final int plot;
    int sizey = 0;

    public Ruler(Panel contents, HV hv, int bx, int by, int _scale, int _plot, int size_y) {
        this.setLineWidth(2);
        this.setLineStyle(1);
        this.setForegroundColor(ColorConstants.black);
        this.setBackgroundColor(ColorConstants.yellow);
        this.setSize(1, 1);
        this.contents = contents;
        this.hv = hv;
        this.x = bx;
        this.y = by;
        this.scale = _scale;
        this.plot = _plot;
        this.updateLocation(size_y);
        this.updateLenght(100);
    }

    @Override
    public void updateLocation(int y) {
        this.sizey = y;
        this.updateLenght(this.lenght);
    }

    protected int getLenght() {
        return this.lenght;
    }

    protected int updateLenght(int newlenght) {
        PointList points = new PointList();
        points.addPoint(new Point(this.x, this.sizey - this.y));
        if (this.hv == HV.horizontal) {
            points.addPoint(new Point(newlenght + this.x, this.sizey - this.y));
        }
        if (this.hv == HV.vertical) {
            points.addPoint(new Point(this.x, this.sizey - this.y - newlenght));
        }
        this.setPoints(points);
        if (newlenght > this.lenght) {
            int i = this.lenght;
            while (i < newlenght) {
                int tmp;
                if (i % this.scale == 0 && (tmp = i / this.scale) % this.plot == 0) {
                    LabelNumber labels = new LabelNumber(tmp);
                    labels.setForegroundColor(ColorConstants.black);
                    int width = 30;
                    int height = 15;
                    int xPos = 0;
                    int yPos = 0;
                    if (this.hv == HV.horizontal) {
                        xPos = this.x + i - width / 2;
                        yPos = this.y - height;
                    }
                    if (this.hv == HV.vertical) {
                        xPos = this.x - width;
                        yPos = this.y + i - height / 2;
                    }
                    labels.setBounds(new Rectangle(xPos, yPos, width, height));
                    this.contents.add((IFigure)labels);
                    PowerView.Dot d = new PowerView.Dot(ColorConstants.black, 3);
                    if (this.hv == HV.horizontal) {
                        d.setLocation(new Point(this.x + i, this.y));
                    }
                    if (this.hv == HV.vertical) {
                        d.setLocation(new Point(this.x, this.y + i));
                    }
                    this.contents.add((IFigure)d);
                }
                ++i;
            }
            if (this.hv == HV.horizontal) {
                this.setSize(newlenght + 2 * this.x, 2 * this.y);
            }
            if (this.hv == HV.vertical) {
                this.setSize(2 * this.x, newlenght + 2 * this.y);
            }
            this.repaint();
            this.contents.repaint();
            this.lenght = newlenght;
        }
        return this.lenght;
    }

    public static enum HV {
        horizontal,
        vertical;

    }

    public static final class LabelNumber
    extends Label
    implements PowerView.IPowerViewFigure {
        int y = 0;
        Rectangle rect = new Rectangle(0, 0, 0, 0);

        public LabelNumber(int i) {
            super(Integer.toString(i));
        }

        @Override
        public void updateLocation(int size_y) {
            this.y = size_y;
            super.setBounds(new Rectangle(this.rect.x, this.y - this.rect.y - this.rect.height, this.rect.width, this.rect.height));
        }

        public void setBounds(Rectangle _rect) {
            this.rect = new Rectangle(_rect);
            this.updateLocation(this.y);
        }
    }
}

