/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.vcdgenerator.gui;

import fr.inria.aoste.timesquare.backend.manager.utils.Filter;
import fr.inria.aoste.timesquare.backend.manager.utils.IFilter;
import fr.inria.aoste.timesquare.backend.manager.visible.BehaviorManagerGUI;
import fr.inria.aoste.timesquare.backend.manager.visible.ClockEntity;
import fr.inria.aoste.timesquare.backend.manager.visible.GUIHelper;
import fr.inria.aoste.timesquare.backend.vcdgenerator.manager.VCDGeneratorManager;
import fr.inria.aoste.timesquare.utils.ui.widgets.FileSelectionControl;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class VCDGeneratorGUI
extends BehaviorManagerGUI {
    public static final String WIDGET_VCDGENERATOR_SELECT_TYPE = "vcdgenerator.select.type";
    public static final String WIDGET_VCDGENERATOR_SELECT_TIMED_DURATION_COUNT_CLOCK = "vcdgenerator.select.timedDuration.countClock";
    public static final String WIDGET_VCDGENERATOR_SELECT_TIMED_DURATION_START = "vcdgenerator.select.timedDuration.start";
    public static final String WIDGET_VCDGENERATOR_SELECT_CLOCK2CLOCK_DURATION_REFCLOCK = "vcdgenerator.select.clock2clockDuration.refclock";
    public static final String WIDGET_VCDGENERATOR_SELECT_CLOCK2CLOCK_DURATION_ENDCLOCK = "vcdgenerator.select.clock2clockDuration.endclock";
    public static final String WIDGET_VCDGENERATOR_SELECT_CLOCK2CLOCK_DURATION_BEGINCLOCK = "vcdgenerator.select.clock2clockDuration.beginclock";
    public static final String WIDGET_VCDGENERATOR_SELECT_SPECIFIC_CLOCK = "vcdgenerator.select.specific_clock";
    public static final String WIDGET_VCDGENERATOR_SELECT_CLOCKDISCRETIZED = "vcdgenerator.select.clockdiscretized";
    public static final String NOTE_PULSES_AND_GHOSTS_ARE_GLOBAL_OPTION = "Note : Pulses and ghosts are global option";
    public static final String PULSES = "Pulses";
    public static final String LAUNCHVIEWER = "Launch VCD Viewer";
    public static final String GENERATE = "Generate :";
    public static final String DISCRETIZE = "Discretize :";
    public static final String GENERATE_VCD_FOR_A_SPECIFIC_CLOCK = "Generate VCD for a specific clock";
    public static final String GENERATE_VCD_FOR_ALL_CLOCKS = "Generate VCD for all clocks";
    public static final String VCD_GENERATION = "VCD Generation";
    public static final String DURATION_MODEL = "VCD Duration model :";
    private Group _VCDGenerationComposite;
    private Composite _compositeClocks;
    private Button _pulses;
    private Button _ghosts;
    private Button _launchVCDViewer;
    private Combo _discretize;
    private Button _allClocks;
    private Button _singleClock;
    private Combo _comboClock;
    private FileSelectionControl _durationModelBrowser;

    public Control createDialogArea(Composite compositein) {
        if (compositein == null) {
            return null;
        }
        compositein.setLayout((Layout)new GridLayout());
        this.displayVCDGeneration(compositein);
        return this._VCDGenerationComposite;
    }

    private void displayVCDGeneration(Composite parent) {
        this._VCDGenerationComposite = new Group(parent, 18);
        this._VCDGenerationComposite.setText(VCD_GENERATION);
        this._VCDGenerationComposite.setLocation(5, 5);
        this._VCDGenerationComposite.setLayout((Layout)new GridLayout(1, true));
        GridData layoutData = new GridData(4, 0, true, false);
        layoutData.minimumWidth = 435;
        layoutData.minimumHeight = 213;
        this._VCDGenerationComposite.setLayoutData((Object)layoutData);
        this._allClocks = new Button((Composite)this._VCDGenerationComposite, 16);
        this._allClocks.setText(GENERATE_VCD_FOR_ALL_CLOCKS);
        this._allClocks.setSelection(true);
        this._allClocks.addSelectionListener((SelectionListener)new ClockCheckBoxSelectionListener(this));
        this._singleClock = new Button((Composite)this._VCDGenerationComposite, 16);
        this._singleClock.setText(GENERATE_VCD_FOR_A_SPECIFIC_CLOCK);
        this._singleClock.setSelection(false);
        this._singleClock.addSelectionListener((SelectionListener)new ClockCheckBoxSelectionListener(this));
        this._compositeClocks = new Composite((Composite)this._VCDGenerationComposite, 4);
        this._compositeClocks.setLayout((Layout)new GridLayout(1, true));
        this._comboClock = this.getGUIHelper().displayList(this._compositeClocks, this.getConfigurationHelper().getClocks(), WIDGET_VCDGENERATOR_SELECT_SPECIFIC_CLOCK);
        this._comboClock.setLayoutData((Object)new GridData(4, 0, true, false));
        this._comboClock.setEnabled(false);
        Label separator = new Label((Composite)this._VCDGenerationComposite, 258);
        separator.setLayoutData((Object)new GridData(4, 0, true, false));
        Label optionsLabel = new Label((Composite)this._VCDGenerationComposite, 0);
        optionsLabel.setText(DISCRETIZE);
        optionsLabel.pack();
        this._discretize = this.getGUIHelper().displayList((Composite)this._VCDGenerationComposite, this.getConfigurationHelper().getClocks(), (IFilter)Filter.FILTER_CLOCK_ENTITY_DISCRETIZE, WIDGET_VCDGENERATOR_SELECT_CLOCKDISCRETIZED);
        this._discretize.setLayoutData((Object)new GridData(4, 0, true, false));
        this._discretize.setEnabled(true);
        if (this._discretize.getItemCount() != 0) {
            this._discretize.select(0);
        }
        separator = new Label((Composite)this._VCDGenerationComposite, 258);
        separator.setLayoutData((Object)new GridData(4, 0, true, false));
        optionsLabel = new Label((Composite)this._VCDGenerationComposite, 0);
        optionsLabel.setText(GENERATE);
        optionsLabel.pack();
        this._pulses = new Button((Composite)this._VCDGenerationComposite, 32);
        this._pulses.setText(PULSES);
        this._pulses.setSelection(true);
        this._ghosts = new Button((Composite)this._VCDGenerationComposite, 32);
        this._ghosts.setText("Ghosts");
        this._ghosts.setSelection(true);
        Label noteLabel = new Label((Composite)this._VCDGenerationComposite, 0);
        noteLabel.setText(NOTE_PULSES_AND_GHOSTS_ARE_GLOBAL_OPTION);
        noteLabel.pack();
        separator = new Label((Composite)this._VCDGenerationComposite, 258);
        separator.setLayoutData((Object)new GridData(4, 0, true, false));
        optionsLabel = new Label((Composite)this._VCDGenerationComposite, 0);
        optionsLabel.setText("");
        optionsLabel.pack();
        this._launchVCDViewer = new Button((Composite)this._VCDGenerationComposite, 32);
        this._launchVCDViewer.setText(LAUNCHVIEWER);
        this._launchVCDViewer.setSelection(this.getBehaviorManager().is_launchVCDViewer());
        this._launchVCDViewer.setEnabled(false);
        separator = new Label((Composite)this._VCDGenerationComposite, 258);
        separator.setLayoutData((Object)new GridData(4, 0, true, false));
        optionsLabel = new Label((Composite)this._VCDGenerationComposite, 0);
        optionsLabel.setText("");
        optionsLabel.pack();
        String[] durationExtensions = new String[]{"duration"};
        this._durationModelBrowser = new FileSelectionControl((Composite)this._VCDGenerationComposite, DURATION_MODEL, durationExtensions);
        String durationFile = this.getBehaviorManager().get_durationModelFilename();
        if (durationFile != null) {
            this._durationModelBrowser.setSelectedFile(durationFile);
        }
        this._VCDGenerationComposite.pack();
    }

    public void okPressed() {
        if (this._VCDGenerationComposite.isVisible()) {
            this.createVCDGenerationBehavior();
        }
        this.getBehaviorManager().set_launchVCDViewer(this._launchVCDViewer.getSelection());
    }

    public void cancelPressed() {
    }

    protected VCDGeneratorManager getBehaviorManager() {
        return (VCDGeneratorManager)super.getBehaviorManager();
    }

    private void createVCDGenerationBehavior() {
        ClockEntity ce;
        ClockEntity ced = null;
        if (this._discretize.getData(GUIHelper.COMBOSELECTION) instanceof ClockEntity) {
            ced = (ClockEntity)this._discretize.getData(GUIHelper.COMBOSELECTION);
        }
        if (this._allClocks.getSelection()) {
            for (ClockEntity clock : this.getConfigurationHelper().getClocks()) {
                if (clock == null) continue;
                this.getBehaviorManager().addVCDGeneratorBehavior(clock, this._pulses.getSelection(), this._ghosts.getSelection(), ced);
            }
        } else if (this._singleClock.getSelection() && (ClockEntity)this._comboClock.getData(GUIHelper.COMBOSELECTION) != null && (ce = (ClockEntity)this._comboClock.getData(GUIHelper.COMBOSELECTION)) != null) {
            this.getBehaviorManager().addVCDGeneratorBehavior(ce, this._pulses.getSelection(), this._ghosts.getSelection(), ced);
        }
        this.getBehaviorManager().set_durationModelFilename(this._durationModelBrowser.getSelectedFile());
        this.getBehaviorManager().createDurationBehaviors();
    }

    private static class ClockCheckBoxSelectionListener
    implements SelectionListener {
        private VCDGeneratorGUI gui;

        private ClockCheckBoxSelectionListener(VCDGeneratorGUI gui) {
            this.gui = gui;
        }

        public void widgetSelected(SelectionEvent e) {
            if (this.gui._allClocks.getSelection()) {
                this.gui._comboClock.setEnabled(false);
            } else if (this.gui._singleClock.getSelection()) {
                this.gui._comboClock.setEnabled(true);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            if (this.gui._allClocks.getSelection()) {
                this.gui._comboClock.setEnabled(false);
            } else if (this.gui._singleClock.getSelection()) {
                this.gui._comboClock.setEnabled(true);
            }
        }
    }
}

