/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.trace.gemoc.generator.util;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import opsemanticsview.OperationalSemanticsView;
import opsemanticsview.Rule;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gemoc.trace.commons.EcoreCraftingUtil;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

public class ExtensionFilter {
    private final Set<EClass> chosenClasses;
    private final Set<? extends EStructuralFeature> chosenProperties;
    private final OperationalSemanticsView executionExtension;
    @Accessors(value={AccessorType.PUBLIC_GETTER, AccessorType.PRIVATE_SETTER})
    private boolean didFilterSomething = false;
    private final Set<EClass> retainedClasses = new HashSet<EClass>();
    private final Set<EStructuralFeature> retainedProperties = new HashSet<EStructuralFeature>();
    private final Set<Rule> retainedRules = new HashSet<Rule>();

    public ExtensionFilter(OperationalSemanticsView executionExtension, Set<EClass> chosenClasses, Set<? extends EStructuralFeature> chosenProperties) {
        boolean _notEquals = !Objects.equal(chosenClasses, null);
        this.chosenClasses = _notEquals ? chosenClasses : Collections.unmodifiableSet(CollectionLiterals.newHashSet());
        boolean _notEquals_1 = !Objects.equal(chosenProperties, null);
        this.chosenProperties = _notEquals_1 ? chosenProperties : Collections.unmodifiableSet(CollectionLiterals.newHashSet());
        this.executionExtension = executionExtension;
    }

    public void execute() {
        if (!this.chosenClasses.isEmpty() || !this.chosenProperties.isEmpty()) {
            Functions.Function1 _function = c -> EcoreCraftingUtil.getFQN((EClassifier)c, (String)".");
            Set chosenClassesFQNs = IterableExtensions.toSet((Iterable)IterableExtensions.map(this.chosenClasses, (Functions.Function1)_function));
            Functions.Function1 _function_1 = p -> {
                String _fQN = EcoreCraftingUtil.getFQN((EClassifier)p.getEContainingClass(), (String)".");
                String _plus = String.valueOf(_fQN) + ".";
                String _name = p.getName();
                return String.valueOf(_plus) + _name;
            };
            Set chosenPropertiesFQNs = IterableExtensions.toSet((Iterable)IterableExtensions.map(this.chosenProperties, (Functions.Function1)_function_1));
            EList _dynamicClasses = this.executionExtension.getDynamicClasses();
            for (EClass element : _dynamicClasses) {
                String fqn = EcoreCraftingUtil.getFQN((EClassifier)element, (String)".");
                boolean _contains = chosenClassesFQNs.contains(fqn);
                if (!_contains) continue;
                this.retainedClasses.add(element);
                CollectionExtensions.addAll(this.retainedClasses, (Object[])new EClass[]{element});
                this.retainedProperties.addAll((Collection<EStructuralFeature>)element.getEStructuralFeatures());
            }
            EList _dynamicProperties = this.executionExtension.getDynamicProperties();
            for (EStructuralFeature element_1 : _dynamicProperties) {
                String _fQN = EcoreCraftingUtil.getFQN((EClassifier)element_1.getEContainingClass(), (String)".");
                String _plus = String.valueOf(_fQN) + ".";
                String _name = element_1.getName();
                String fqn = String.valueOf(_plus) + _name;
                boolean _contains = chosenPropertiesFQNs.contains(fqn);
                if (!_contains) continue;
                this.retainedProperties.add(element_1);
                this.retainedClasses.add(element_1.getEContainingClass());
                CollectionExtensions.addAll(this.retainedClasses, (Object[])new EClass[]{element_1.getEContainingClass()});
                if (!(element_1 instanceof EReference)) continue;
                this.retainedClasses.add(((EReference)element_1).getEReferenceType());
                CollectionExtensions.addAll(this.retainedClasses, (Object[])new EClass[]{((EReference)element_1).getEReferenceType()});
            }
            EList _rules = this.executionExtension.getRules();
            for (Rule element_2 : _rules) {
                boolean _isStepRule = element_2.isStepRule();
                if (!_isStepRule) continue;
                this.retainedRules.add(element_2);
                Functions.Function1 _function_2 = p -> p.getEType();
                Iterable _filter = Iterables.filter((Iterable)ListExtensions.map((List)element_2.getOperation().getEParameters(), (Functions.Function1)_function_2), EClass.class);
                for (EClass paramClass : _filter) {
                    this.retainedClasses.add(paramClass);
                }
                EClassifier _eType = element_2.getOperation().getEType();
                if (_eType instanceof EClass) {
                    EClassifier _eType_1 = element_2.getOperation().getEType();
                    this.retainedClasses.add((EClass)_eType_1);
                }
                this.retainedClasses.add(element_2.getContainingClass());
            }
            for (EClass c1 : this.retainedClasses) {
                Functions.Function1 _function_3 = c -> !Objects.equal((Object)c, (Object)c1);
                Iterable _filter_1 = IterableExtensions.filter(this.retainedClasses, (Functions.Function1)_function_3);
                for (EClass c2 : _filter_1) {
                    boolean _not;
                    boolean _contains = c1.getEAllSuperTypes().contains((Object)c2);
                    if (!_contains) continue;
                    boolean _hasSuperTypePathContainedIn = ExtensionFilter.hasSuperTypePathContainedIn(c1, c2, this.retainedClasses);
                    boolean bl = _not = !_hasSuperTypePathContainedIn;
                    if (!_not) continue;
                    c1.getESuperTypes().add((Object)c2);
                }
            }
            for (Rule r1 : this.retainedRules) {
                Functions.Function1 _function_4 = r -> !Objects.equal((Object)r, (Object)r1);
                Iterable _filter_2 = IterableExtensions.filter(this.retainedRules, (Functions.Function1)_function_4);
                for (Rule r2 : _filter_2) {
                    HashSet<Rule> _hashSet;
                    boolean _callsIndirectly = this.callsIndirectly(r1, r2, _hashSet = new HashSet<Rule>());
                    if (!_callsIndirectly) continue;
                    r1.getCalledRules().add((Object)r2);
                }
            }
            for (Rule r2 : this.retainedRules) {
                boolean _not_1;
                Predicate<Rule> _function_5 = r2_1 -> {
                    boolean _contains_1 = this.retainedRules.contains(r2);
                    return !_contains_1;
                };
                r2.getCalledRules().removeIf(_function_5);
                Predicate<Rule> _function_6 = r2_1 -> {
                    boolean _contains_1 = this.retainedRules.contains(r2);
                    return !_contains_1;
                };
                r2.getOverridenBy().removeIf(_function_6);
                boolean _contains_1 = this.retainedRules.contains(r2.getOverrides());
                boolean bl = _not_1 = !_contains_1;
                if (!_not_1) continue;
                r2.setOverrides(null);
            }
            Set _set = IteratorExtensions.toSet((Iterator)this.executionExtension.eAllContents());
            for (EObject element_3 : _set) {
                this.tryRemove(element_3);
            }
        }
    }

    public boolean callsIndirectly(Rule origin, Rule destination, Set<Rule> visited) {
        boolean _not;
        boolean _contains = visited.contains(origin);
        boolean bl = _not = !_contains;
        if (_not) {
            boolean _equals = Objects.equal((Object)origin, (Object)destination);
            if (_equals) {
                return true;
            }
            EList _calledRules = origin.getCalledRules();
            for (Rule r : _calledRules) {
                boolean result = this.callsIndirectly(r, destination, visited);
                if (!result) continue;
                return true;
            }
        }
        return false;
    }

    public static Set<CallPath> findCallPaths(Rule origin, Rule destination, Set<Rule> mustBeContainedIn, Set<Rule> visited, boolean containedSoFar) {
        boolean _not;
        HashSet<CallPath> result = new HashSet<CallPath>();
        boolean _contains = visited.contains(origin);
        boolean bl = _not = !_contains;
        if (_not) {
            visited.add(origin);
            boolean _equals = Objects.equal((Object)origin, (Object)destination);
            if (_equals) {
                CallPath path = new CallPath();
                path.isContainedInSet = containedSoFar;
                result.add(path);
            }
            EList _calledRules = origin.getCalledRules();
            for (Rule s : _calledRules) {
                boolean containedSoFarNext = containedSoFar && mustBeContainedIn.contains(s);
                Set<CallPath> interResult = ExtensionFilter.findCallPaths(s, destination, mustBeContainedIn, visited, containedSoFarNext);
                result.addAll(interResult);
            }
        }
        return result;
    }

    private static boolean hasSuperTypePathContainedIn(EClass origin, EClass destination, Set<EClass> containedIn) {
        boolean _equals = Objects.equal((Object)origin, (Object)destination);
        if (_equals) {
            return true;
        }
        Functions.Function1 _function = s -> containedIn.contains(s);
        Iterable _filter = IterableExtensions.filter((Iterable)origin.getESuperTypes(), (Functions.Function1)_function);
        for (EClass s2 : _filter) {
            boolean result = ExtensionFilter.hasSuperTypePathContainedIn(s2, destination, containedIn);
            if (!result) continue;
            return true;
        }
        return false;
    }

    private Set<EObject> tryRemove(EObject element) {
        return null;
    }

    @Pure
    public boolean isDidFilterSomething() {
        return this.didFilterSomething;
    }

    private void setDidFilterSomething(boolean didFilterSomething) {
        this.didFilterSomething = didFilterSomething;
    }

    public static class CallPath {
        public boolean isContainedInSet = false;
    }
}

