/*
 * Decompiled with CFR 0.152.
 */
package fr.kairos.timesquare.ccsl.graph;

import fr.kairos.timesquare.ccsl.ISimpleSpecification;
import fr.kairos.timesquare.ccsl.graph.DigraphBuilder;

public final class BuildSubclockGraph
implements ISimpleSpecification {
    private DigraphBuilder builder;

    public BuildSubclockGraph() {
        this(new DigraphBuilder());
    }

    public BuildSubclockGraph(DigraphBuilder builder) {
        this.builder = builder;
        this.builder.setParam("subclock");
    }

    private void addArc(String tail, String head) {
        this.builder.addArc(tail, head);
    }

    public DigraphBuilder getBuilder() {
        return this.builder;
    }

    @Override
    public void addClock(String name) {
    }

    @Override
    public void subclock(String left, String right) {
        this.addArc(left, right);
    }

    @Override
    public void exclusion(String left, String right) {
    }

    @Override
    public void precedence(String left, String right) {
        this.causality(left, right, 1, -1);
    }

    @Override
    public void precedence(String left, String right, int min, int max) {
        this.causality(left, right, min + 1, max);
    }

    @Override
    public void causality(String left, String right) {
    }

    @Override
    public void causality(String left, String right, int min, int max) {
    }

    @Override
    public void inf(String defClock, String ... clocks) {
        String[] stringArray = clocks;
        int n = clocks.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            this.causality(defClock, c);
            ++n2;
        }
    }

    @Override
    public void sup(String defClock, String ... clocks) {
        String[] stringArray = clocks;
        int n = clocks.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            this.causality(c, defClock);
            ++n2;
        }
    }

    @Override
    public void union(String defClock, String ... clocks) {
        String[] stringArray = clocks;
        int n = clocks.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            this.subclock(c, defClock);
            ++n2;
        }
    }

    @Override
    public void intersection(String defClock, String ... clocks) {
        String[] stringArray = clocks;
        int n = clocks.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            this.subclock(defClock, c);
            ++n2;
        }
    }

    @Override
    public void minus(String defClock, String ... clocks) {
        this.subclock(defClock, clocks[0]);
    }

    @Override
    public void periodic(String defClock, String ref, int period, int from, int upto) {
        this.subclock(defClock, ref);
    }

    @Override
    public void delayFor(String defClock, String ref, int from, int upTo, String base) {
        if (base == null) {
            this.subclock(defClock, ref);
        } else {
            this.subclock(defClock, base);
        }
        if (from == 0) {
            this.subclock(ref, defClock);
        }
    }
}

