/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.rebase;

import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.dialogs.SpellcheckableMessageArea;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class CommitMessageEditorDialog
extends TitleAreaDialog {
    private String commitMessage;
    private SpellcheckableMessageArea messageArea;
    private FormToolkit toolkit;
    private static final String DIALOG_SETTINGS_SECTION_NAME = "org.eclipse.egit.ui.COMMIT_MESSAGE_EDITOR_DIALOG_SECTION";
    private String title;
    private String okButtonLabel;
    private String cancelButtonLabel;

    public CommitMessageEditorDialog(Shell parentShell, String commitMessage) {
        this(parentShell, commitMessage, UIText.CommitMessageEditorDialog_EditCommitMessageTitle);
    }

    public CommitMessageEditorDialog(Shell parentShell, String commitMessage, String title) {
        this(parentShell, commitMessage, UIText.CommitMessageEditorDialog_OkButton, IDialogConstants.CANCEL_LABEL);
        this.title = title;
    }

    public CommitMessageEditorDialog(Shell parentShell, String commitMessage, String okButtonLabel, String cancelButtonLabel) {
        super(parentShell);
        this.commitMessage = commitMessage;
        this.title = UIText.CommitMessageEditorDialog_EditCommitMessageTitle;
        this.okButtonLabel = okButtonLabel;
        this.cancelButtonLabel = cancelButtonLabel;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10 | 0x400);
    }

    protected Control createContents(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CommitMessageEditorDialog.this.commitMessage = CommitMessageEditorDialog.this.messageArea.getCommitMessage();
                CommitMessageEditorDialog.this.toolkit.dispose();
            }
        });
        return super.createContents(parent);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)gridLayout);
        this.setTitle(UIText.RebaseInteractiveHandler_EditMessageDialogTitle);
        this.setMessage(UIText.RebaseInteractiveHandler_EditMessageDialogText);
        this.messageArea = new SpellcheckableMessageArea(composite, this.commitMessage);
        this.messageArea.setData("FormWidgetFactory.drawBorder", "textBorder");
        Point size = this.messageArea.getTextWidget().getSize();
        int minHeight = this.messageArea.getTextWidget().getLineHeight() * 3;
        this.messageArea.setLayoutData(GridDataFactory.fillDefaults().grab(true, true).hint(size).minSize(size.x, minHeight).align(4, 4).create());
        this.messageArea.setFocus();
        return composite;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_SETTINGS_SECTION_NAME);
        if (section == null) {
            section = settings.addNewSection(DIALOG_SETTINGS_SECTION_NAME);
        }
        return section;
    }

    public String getCommitMessage() {
        return this.commitMessage;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, this.okButtonLabel, true);
        this.createButton(parent, 1, this.cancelButtonLabel, false);
    }
}

