/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.history.GitHistoryPage;
import org.eclipse.egit.ui.internal.history.SWTCommit;
import org.eclipse.egit.ui.internal.history.SWTCommitList;
import org.eclipse.egit.ui.internal.trace.GitTraceLocation;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.osgi.util.NLS;

class GenerateHistoryJob
extends Job {
    private static final int BATCH_SIZE = 256;
    private final GitHistoryPage page;
    private final SWTCommitList loadedCommits;
    private int itemToLoad = 1;
    private RevCommit commitToLoad;
    private RevCommit commitToShow;
    private int wantedIndex = -1;
    private int lastUpdateCnt;
    private boolean trace;
    private final RevWalk walk;
    private RevFlag highlightFlag;
    private int forcedRedrawsAfterListIsCompleted = 0;

    GenerateHistoryJob(GitHistoryPage ghp, @NonNull RevWalk walk, ResourceManager resources) {
        super(NLS.bind((String)UIText.HistoryPage_refreshJob, (Object)RepositoryUtil.INSTANCE.getRepositoryName(ghp.getInputInternal().getRepository())));
        this.page = ghp;
        this.walk = walk;
        this.highlightFlag = walk.newFlag("highlight");
        this.loadedCommits = new SWTCommitList(resources){

            protected void enter(int index, PlotCommit<SWTCommitList.SWTLane> currCommit) {
                super.enter(index, currCommit);
                if (GenerateHistoryJob.this.wantedIndex < 0 && GenerateHistoryJob.this.commitToLoad != null && currCommit.getId().equals((AnyObjectId)GenerateHistoryJob.this.commitToLoad.getId())) {
                    GenerateHistoryJob.this.wantedIndex = index;
                }
            }
        };
        this.loadedCommits.source(walk);
        this.trace = GitTraceLocation.HISTORYVIEW.isActive();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus run(IProgressMonitor monitor) {
        int maxCommits;
        IStatus status = Status.OK_STATUS;
        int chunk = maxCommits = Activator.getDefault().getPreferenceStore().getInt("HistoryView_MaxNumberOfCommmits");
        boolean incomplete = false;
        boolean commitNotFound = false;
        try {
            if (this.trace) {
                GitTraceLocation.getTrace().traceEntry(GitTraceLocation.HISTORYVIEW.getLocation());
            }
            boolean loadIncrementally = !Activator.getDefault().getPreferenceStore().getBoolean("resourcehistory_show_findtoolbar");
            int initialSize = this.loadedCommits.size();
            try {
                int oldsz = initialSize;
                while (true) {
                    if (this.trace) {
                        GitTraceLocation.getTrace().trace(GitTraceLocation.HISTORYVIEW.getLocation(), "Filling commit list");
                    }
                    if (this.commitToLoad != null) {
                        boolean commitFound;
                        if (maxCommits > 0 && this.loadedCommits.size() >= maxCommits) {
                            maxCommits = this.loadedCommits.size() + Math.min(Math.max(chunk, 1000), 10000);
                        }
                        this.loadedCommits.fillTo(this.commitToLoad, maxCommits);
                        this.commitToShow = this.commitToLoad;
                        boolean bl = commitFound = this.wantedIndex >= 0;
                        if (commitFound) {
                            this.commitToLoad = null;
                        }
                        commitNotFound = !commitFound;
                    } else {
                        this.loadedCommits.fillTo(oldsz + 256 - 1);
                        if (oldsz == this.loadedCommits.size()) {
                            ++this.forcedRedrawsAfterListIsCompleted;
                            break;
                        }
                    }
                    if (monitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    if (this.loadedCommits.size() > this.itemToLoad + 128 + 1 && loadIncrementally && !commitNotFound) break;
                    if (maxCommits > 0 && this.loadedCommits.size() > maxCommits) {
                        if (!loadIncrementally) {
                            incomplete = true;
                        }
                        if (this.commitToLoad == null) break;
                    }
                    if (oldsz != this.loadedCommits.size()) {
                        oldsz = this.loadedCommits.size();
                        monitor.setTaskName(MessageFormat.format(UIText.GenerateHistoryJob_taskFoundCommits, oldsz));
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                status = new Status(4, "org.eclipse.egit.ui", UIText.GenerateHistoryJob_errorComputingHistory, (Throwable)e);
            }
            if (this.trace) {
                GitTraceLocation.getTrace().trace(GitTraceLocation.HISTORYVIEW.getLocation(), "Loaded " + this.loadedCommits.size() + " commits");
            }
            if (commitNotFound && !this.loadedCommits.isEmpty()) {
                if (this.forcedRedrawsAfterListIsCompleted < 1 && !loadIncrementally) {
                    this.page.setWarningTextInUIThread(this);
                }
                if (initialSize == this.loadedCommits.size()) return status;
                this.updateUI(incomplete);
                return status;
            }
            this.updateUI(incomplete);
            return status;
        }
        finally {
            monitor.done();
            if (this.trace) {
                GitTraceLocation.getTrace().traceExit(GitTraceLocation.HISTORYVIEW.getLocation());
            }
        }
    }

    private void updateUI(boolean incomplete) {
        if (this.trace) {
            GitTraceLocation.getTrace().traceEntry(GitTraceLocation.HISTORYVIEW.getLocation());
        }
        try {
            if (this.forcedRedrawsAfterListIsCompleted != 1 && !incomplete && this.lastUpdateCnt != 0 && this.loadedCommits.size() == this.lastUpdateCnt) {
                return;
            }
            if (this.forcedRedrawsAfterListIsCompleted == 1) {
                ++this.forcedRedrawsAfterListIsCompleted;
            }
            SWTCommit[] asArray = new SWTCommit[this.loadedCommits.size()];
            this.loadedCommits.toArray((Object[])asArray);
            this.page.showCommitList(this, this.loadedCommits, asArray, this.commitToShow, incomplete, this.highlightFlag);
            this.commitToShow = null;
            this.lastUpdateCnt = this.loadedCommits.size();
        }
        finally {
            if (this.trace) {
                GitTraceLocation.getTrace().traceExit(GitTraceLocation.HISTORYVIEW.getLocation());
            }
        }
    }

    void release() {
        if (this.getState() == 0) {
            this.dispose();
        } else {
            this.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    GenerateHistoryJob.this.dispose();
                }
            });
        }
    }

    private void dispose() {
        this.loadedCommits.clear();
        this.walk.close();
    }

    public boolean belongsTo(Object family) {
        if (JobFamilies.GENERATE_HISTORY.equals(family)) {
            return true;
        }
        return super.belongsTo(family);
    }

    void setLoadHint(int index) {
        this.itemToLoad = index;
        if (index < 0) {
            this.commitToLoad = null;
        }
    }

    void setLoadHint(RevCommit c) {
        this.commitToLoad = c;
    }

    void setShowHint(RevCommit c) {
        this.commitToShow = c;
    }

    int loadMoreItemsThreshold() {
        return this.loadedCommits.size() - 128;
    }
}

