/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.viewpoint.description.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.sirius.business.internal.query.DModelElementInternalQuery;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.eclipse.sirius.viewpoint.description.DModelElement;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;

public abstract class DModelElementImpl
extends MinimalEObjectImpl.Container
implements DModelElement {
    protected EList<DAnnotation> eAnnotations;
    private static final String[] ESCAPE;

    static {
        String[] stringArray = new String[64];
        stringArray[0] = "%00";
        stringArray[1] = "%01";
        stringArray[2] = "%02";
        stringArray[3] = "%03";
        stringArray[4] = "%04";
        stringArray[5] = "%05";
        stringArray[6] = "%06";
        stringArray[7] = "%07";
        stringArray[8] = "%08";
        stringArray[9] = "%09";
        stringArray[10] = "%0A";
        stringArray[11] = "%0B";
        stringArray[12] = "%0C";
        stringArray[13] = "%0D";
        stringArray[14] = "%0E";
        stringArray[15] = "%0F";
        stringArray[16] = "%10";
        stringArray[17] = "%11";
        stringArray[18] = "%12";
        stringArray[19] = "%13";
        stringArray[20] = "%14";
        stringArray[21] = "%15";
        stringArray[22] = "%16";
        stringArray[23] = "%17";
        stringArray[24] = "%18";
        stringArray[25] = "%19";
        stringArray[26] = "%1A";
        stringArray[27] = "%1B";
        stringArray[28] = "%1C";
        stringArray[29] = "%1D";
        stringArray[30] = "%1E";
        stringArray[31] = "%1F";
        stringArray[32] = "%20";
        stringArray[34] = "%22";
        stringArray[35] = "%23";
        stringArray[37] = "%25";
        stringArray[38] = "%26";
        stringArray[39] = "%27";
        stringArray[44] = "%2C";
        stringArray[47] = "%2F";
        stringArray[58] = "%3A";
        stringArray[60] = "%3C";
        stringArray[62] = "%3E";
        ESCAPE = stringArray;
    }

    protected DModelElementImpl() {
    }

    protected EClass eStaticClass() {
        return DescriptionPackage.Literals.DMODEL_ELEMENT;
    }

    @Override
    public EList<DAnnotation> getEAnnotations() {
        if (this.eAnnotations == null) {
            this.eAnnotations = new EObjectContainmentEList(DAnnotation.class, (InternalEObject)this, 0);
        }
        return this.eAnnotations;
    }

    @Override
    public DAnnotation getDAnnotation(String source) {
        return new DModelElementInternalQuery(this).getDAnnotation(source);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getEAnnotations()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getEAnnotations();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getEAnnotations().clear();
                this.getEAnnotations().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getEAnnotations().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.eAnnotations != null && !this.eAnnotations.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String eURIFragmentSegment(EStructuralFeature eStructuralFeature, EObject eObject) {
        DAnnotation eAnnotation;
        String source;
        if (eObject instanceof ENamedElement) {
            ENamedElement eNamedElement = (ENamedElement)eObject;
            String name = eNamedElement.getName();
            if (name != null) {
                int count = 0;
                for (Object otherEObject : this.eContents()) {
                    ENamedElement otherENamedElement;
                    if (otherEObject == eObject) break;
                    if (!(otherEObject instanceof ENamedElement) || !name.equals((otherENamedElement = (ENamedElement)otherEObject).getName())) continue;
                    ++count;
                }
                name = DModelElementImpl.eEncodeValue(name);
                return count > 0 ? String.valueOf(name) + "." + count : name;
            }
        } else if (eObject instanceof DAnnotation && (source = (eAnnotation = (DAnnotation)eObject).getSource()) != null) {
            int count = 0;
            for (Object otherEObject : this.eContents()) {
                DAnnotation otherEAnnotation;
                if (otherEObject == eObject) break;
                if (!(otherEObject instanceof DAnnotation) || !source.equals((otherEAnnotation = (DAnnotation)otherEObject).getSource())) continue;
                ++count;
            }
            StringBuffer result = new StringBuffer(source.length() + 5);
            result.append('%');
            result.append(URI.encodeSegment((String)source, (boolean)false));
            result.append('%');
            if (count > 0) {
                result.append('.');
                result.append(count);
            }
            return result.toString();
        }
        return super.eURIFragmentSegment(eStructuralFeature, eObject);
    }

    public EObject eObjectForURIFragmentSegment(String uriFragmentSegment) {
        char firstCharacter;
        if (uriFragmentSegment.length() > 0 && (firstCharacter = uriFragmentSegment.charAt(0)) != '@') {
            if (firstCharacter == '%') {
                int index = uriFragmentSegment.lastIndexOf("%");
                if (index != -1) {
                    String source = URI.decode((String)uriFragmentSegment.substring(1, index));
                    int count = 0;
                    if (uriFragmentSegment.length() > ++index && uriFragmentSegment.charAt(index) == '.') {
                        try {
                            count = Integer.parseInt(uriFragmentSegment.substring(index + 1));
                        }
                        catch (NumberFormatException exception) {
                            throw new WrappedException((Exception)exception);
                        }
                    }
                    for (Object object : this.eContents()) {
                        DAnnotation eAnnotation;
                        if (!(object instanceof DAnnotation) || !source.equals((eAnnotation = (DAnnotation)object).getSource()) || count-- != 0) continue;
                        return eAnnotation;
                    }
                }
            } else {
                int index = uriFragmentSegment.lastIndexOf(".");
                String name = index == -1 ? uriFragmentSegment : uriFragmentSegment.substring(0, index);
                int count = 0;
                if (index != -1) {
                    try {
                        count = Integer.parseInt(uriFragmentSegment.substring(index + 1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        name = uriFragmentSegment;
                    }
                }
                name = URI.decode((String)name);
                for (Object object : this.eContents()) {
                    ENamedElement eNamedElement;
                    if (!(object instanceof ENamedElement) || !name.equals((eNamedElement = (ENamedElement)object).getName()) || count-- != 0) continue;
                    return eNamedElement;
                }
            }
            return null;
        }
        return super.eObjectForURIFragmentSegment(uriFragmentSegment);
    }

    private static String eEncodeValue(String value) {
        int length = value.length();
        StringBuilder result = null;
        int i = 0;
        while (i < length) {
            String escape;
            char character = value.charAt(i);
            if (character < ESCAPE.length && (escape = ESCAPE[character]) != null) {
                if (result == null) {
                    result = new StringBuilder(length + 2);
                    result.append(value, 0, i);
                }
                result.append(escape);
            } else if (result != null) {
                result.append(character);
            }
            ++i;
        }
        return result == null ? value : result.toString();
    }
}

