/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session.danalysis;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.sirius.business.api.resource.ResourceDescriptor;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.ecore.extender.tool.api.ModelUtils;
import org.eclipse.sirius.viewpoint.DAnalysis;

public final class SemanticResourceGetter {
    private SemanticResourceGetter() {
    }

    public static Collection<Resource> collectTopLevelSemanticResources(DAnalysisSessionImpl session) {
        LinkedHashSet<Resource> semanticResources = new LinkedHashSet<Resource>();
        for (DAnalysis analysis : session.allAnalyses()) {
            for (ResourceDescriptor resourceDesc : analysis.getSemanticResources()) {
                Resource resource = ModelUtils.getResource((ResourceSet)session.getTransactionalEditingDomain().getResourceSet(), (URI)resourceDesc.getResourceURI());
                if (resource == null || resource.getContents().isEmpty()) continue;
                semanticResources.add(resource);
            }
        }
        semanticResources.removeAll((Collection<?>)session.getControlledResources());
        return semanticResources;
    }
}

