/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.xdsmlframework.test.lib;

import com.google.common.base.Objects;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.zip.ZipFile;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.internal.framework.EquinoxBundle;
import org.eclipse.osgi.storage.BundleInfo;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.core.target.LoadTargetDefinitionJob;
import org.eclipse.pde.internal.core.target.TargetPlatformService;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.wizards.datatransfer.ZipLeveledStructureProvider;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.junit4.ui.util.IResourcesSetupUtil;
import org.eclipse.xtext.junit4.ui.util.JavaProjectSetupUtil;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.junit.Assert;
import org.osgi.framework.Bundle;

public class WorkspaceTestHelper {
    public static final String CMD_PROJECT_CLEAN = "org.eclipse.ui.project.cleanAction";
    public static final int SWTBotPreferencesTIMEOUT_4_GEMOC = 20000;
    public static final int SWTBotPreferencesPLAYBACK_DELAY_4_GEMOC = 100;
    private IProject deployProjectResult = null;
    private static boolean closed = false;

    public void waitWorkbench() {
        try {
            final ArrayList workbenchAvailable = CollectionLiterals.newArrayList((Object[])new Boolean[]{false});
            while (((Boolean)workbenchAvailable.get(0)).booleanValue()) {
                Display _default = Display.getDefault();
                _default.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (PlatformUI.isWorkbenchRunning() && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) {
                            workbenchAvailable.set(0, true);
                        }
                    }
                });
                InputOutput.println((Object)"[WorkspaceTestHelper] waiting for Workbench availability");
                Thread.sleep(1000L);
            }
            WorkspaceTestHelper.reallyWaitForJobs(50);
            InputOutput.println((Object)"[WorkspaceTestHelper] Workbench is available");
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void init() {
        Display _default = Display.getDefault();
        _default.syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    PlatformUI.getWorkbench().showPerspective("org.eclipse.gemoc.xdsmlframework.ide.ui.xdsml.perspective", PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                    WorkspaceTestHelper.this.closeWelcomePage();
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        });
    }

    public IProject getProject(String projectName) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    public boolean projectExists(String projectName) {
        return this.getProject(projectName).exists();
    }

    public IProject deployProject(String projectName, String zipLocation) {
        this.deployProjectResult = null;
        ArrayList thrownException = CollectionLiterals.newArrayList();
        Runnable _function = () -> {
            try {
                IProject newProject = JavaProjectSetupUtil.createSimpleProject((String)projectName);
                ZipFile zip = new ZipFile(zipLocation);
                ZipLeveledStructureProvider structureProvider = new ZipLeveledStructureProvider(zip);
                IOverwriteQuery queryOverwrite = new IOverwriteQuery(){

                    public String queryOverwrite(String file) {
                        return "ALL";
                    }
                };
                IPath _fullPath = newProject.getProject().getFullPath();
                Object _root = structureProvider.getRoot();
                ImportOperation _importOperation = new ImportOperation(_fullPath, _root, (IImportStructureProvider)structureProvider, queryOverwrite);
                NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
                _importOperation.run((IProgressMonitor)_nullProgressMonitor);
                zip.close();
                this.deployProjectResult = newProject.getProject();
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    thrownException.add(e);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        };
        Display.getDefault().syncExec(_function);
        Functions.Function1 _function_1 = e -> {
            try {
                throw new Exception((Throwable)e);
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        };
        IterableExtensions.forall((Iterable)thrownException, (Functions.Function1)_function_1);
        return this.deployProjectResult;
    }

    public void closeWelcomePage() {
        boolean _tripleNotEquals;
        IIntroPart _intro = PlatformUI.getWorkbench().getIntroManager().getIntro();
        boolean bl = _tripleNotEquals = _intro != null;
        if (_tripleNotEquals) {
            PlatformUI.getWorkbench().getIntroManager().closeIntro(PlatformUI.getWorkbench().getIntroManager().getIntro());
        }
    }

    public void assertNoMarkers() {
        Consumer<IProject> _function = project -> this.printAllMarkers((IResource)project);
        ((List)Conversions.doWrapArray((Object)ResourcesPlugin.getWorkspace().getRoot().getProjects())).forEach(_function);
        Consumer<IProject> _function_1 = project -> {
            try {
                Consumer<IMarker> _function_2 = m -> {
                    try {
                        Object _attribute = m.getAttribute("message");
                        String _plus = "Unexpected error marker: " + _attribute;
                        String _plus_1 = String.valueOf(_plus) + " on ";
                        IPath _fullPath = m.getResource().getFullPath();
                        String _plus_2 = String.valueOf(_plus_1) + _fullPath;
                        Object _attribute_1 = m.getAttribute("severity");
                        boolean _equals = Objects.equal((Object)_attribute_1, (Object)2);
                        Assert.assertFalse((String)_plus_2, (boolean)_equals);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                };
                ((List)Conversions.doWrapArray((Object)project.findMarkers("org.eclipse.core.resources.problemmarker", true, 2))).forEach(_function_2);
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        };
        ((List)Conversions.doWrapArray((Object)ResourcesPlugin.getWorkspace().getRoot().getProjects())).forEach(_function_1);
    }

    public void assertNoMarkers(String filename) {
        try {
            IWorkspaceRoot _root = ResourcesPlugin.getWorkspace().getRoot();
            Path _path = new Path(filename);
            IFile mlgFile = _root.getFile((IPath)_path);
            this.printAllMarkers((IResource)mlgFile);
            Consumer<IMarker> _function = it -> {
                try {
                    Object _attribute = it.getAttribute("message");
                    String _plus = "Unexpected error marker: " + _attribute;
                    String _plus_1 = String.valueOf(_plus) + " on file ";
                    String _plus_2 = String.valueOf(_plus_1) + filename;
                    Object _attribute_1 = it.getAttribute("severity");
                    boolean _equals = Objects.equal((Object)_attribute_1, (Object)2);
                    Assert.assertFalse((String)_plus_2, (boolean)_equals);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            ((List)Conversions.doWrapArray((Object)mlgFile.findMarkers("org.eclipse.core.resources.problemmarker", true, 2))).forEach(_function);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void printAllMarkers(IResource res) {
        try {
            Consumer<IMarker> _function = it -> {
                try {
                    String _switchResult = null;
                    Object _attribute = it.getAttribute("severity");
                    boolean _matched = false;
                    if (Objects.equal((Object)_attribute, (Object)2)) {
                        _matched = true;
                        _switchResult = "error";
                    }
                    if (!_matched && Objects.equal((Object)_attribute, (Object)1)) {
                        _matched = true;
                        _switchResult = "warning";
                    }
                    if (!_matched && Objects.equal((Object)_attribute, (Object)0)) {
                        _matched = true;
                        _switchResult = "info";
                    }
                    if (!_matched) {
                        _switchResult = "";
                    }
                    String severity = _switchResult;
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Found ");
                    _builder.append(severity);
                    _builder.append(" marker \"");
                    Object _attribute_1 = it.getAttribute("message");
                    _builder.append(_attribute_1);
                    _builder.append("\" on ");
                    String _name = res.getName();
                    _builder.append(_name);
                    InputOutput.println((Object)_builder.toString());
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            ((List)Conversions.doWrapArray((Object)res.findMarkers("org.eclipse.core.resources.problemmarker", true, 2))).forEach(_function);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void assertFileExists(String filename) {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot _root = ws.getRoot();
        Path _path = new Path(filename);
        Assert.assertTrue((String)("Cannot find file " + filename), (boolean)_root.getFile((IPath)_path).exists());
    }

    public void assertFileDontExists(String filename) {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot _root = ws.getRoot();
        Path _path = new Path(filename);
        Assert.assertFalse((String)("Found file " + filename), (boolean)_root.getFile((IPath)_path).exists());
    }

    public void assertFolderExists(String foldername) {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot _root = ws.getRoot();
        Path _path = new Path(foldername);
        Assert.assertTrue((String)("Cannot find file " + foldername), (boolean)_root.getFolder((IPath)_path).exists());
    }

    public void assertProjectExists(String project) {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        Assert.assertTrue((String)("Cannot find project " + project), (boolean)ws.getRoot().getProject(project).exists());
    }

    public void assertProjectDoesntExists(String project) {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        Assert.assertFalse((String)("Can find project " + project), (boolean)ws.getRoot().getProject(project).exists());
    }

    public void assertContains(String baseMessage, String searchedString, List<String> list) {
        Assert.assertTrue((String)(String.valueOf(baseMessage) + " " + searchedString), (boolean)list.contains(searchedString));
    }

    public String runMainClass(IProject project, String mainClass) {
        try {
            boolean _not;
            String outputFileName = "output.txt";
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType type = manager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
            ILaunchConfigurationWorkingCopy newLaunchConfig = type.newInstance((IContainer)project, "RunMainTransfo");
            newLaunchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, project.getName());
            newLaunchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, mainClass);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("${workspace_loc:/");
            String _name = project.getName();
            _builder.append(_name);
            _builder.append("/");
            _builder.append("output.txt");
            _builder.append("}");
            newLaunchConfig.setAttribute("org.eclipse.debug.ui.ATTR_CAPTURE_IN_FILE", (Object)_builder);
            newLaunchConfig.doSave();
            IFile outputFile = project.getFile("output.txt");
            boolean _exists = outputFile.exists();
            boolean bl = _not = !_exists;
            if (_not) {
                byte[] _bytes = "".getBytes();
                ByteArrayInputStream _byteArrayInputStream = new ByteArrayInputStream(_bytes);
                outputFile.create((InputStream)_byteArrayInputStream, true, null);
            }
            ILaunch launch = newLaunchConfig.launch("run", null);
            long TIMEOUT = 300000L;
            long startTime = System.currentTimeMillis();
            while (!launch.isTerminated() && System.currentTimeMillis() < startTime + 300000L) {
                try {
                    Thread.sleep(50L);
                }
                catch (Throwable _t) {
                    if (_t instanceof InterruptedException) continue;
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
            outputFile.refreshLocal(1, null);
            InputStream bi = outputFile.getContents();
            byte[] buffer = new byte[bi.available()];
            bi.read(buffer);
            String out = new String(buffer);
            return out;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void debug() {
        Consumer<IProject> _function = project -> {
            try {
                String _name = project.getName();
                String _plus = "Error markers: " + _name;
                InputOutput.println((Object)_plus);
                Consumer<IMarker> _function_1 = marker -> {
                    try {
                        String _name_1 = marker.getResource().getName();
                        String _plus_1 = "   Resource: " + _name_1;
                        InputOutput.println((Object)_plus_1);
                        Object _attribute = marker.getAttribute("location");
                        String _plus_2 = "   Location: " + _attribute;
                        InputOutput.println((Object)_plus_2);
                        Object _attribute_1 = marker.getAttribute("message");
                        String _plus_3 = "   Message: " + _attribute_1;
                        String _plus_4 = String.valueOf(_plus_3) + "\n";
                        InputOutput.println((Object)_plus_4);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                };
                ((List)Conversions.doWrapArray((Object)project.findMarkers("org.eclipse.core.resources.problemmarker", true, 2))).forEach(_function_1);
                InputOutput.println((Object)"\n");
                String _name_1 = project.getName();
                String _plus_1 = "Classpath: " + _name_1;
                InputOutput.println((Object)_plus_1);
                IJavaProject jProject = JavaCore.create((IProject)project);
                StringBuffer cp = new StringBuffer();
                Consumer<IClasspathEntry> _function_2 = entry -> {
                    String _string = entry.getPath().toString();
                    String _plus_2 = " " + _string;
                    String _plus_3 = String.valueOf(_plus_2) + "\n";
                    cp.append(_plus_3);
                };
                ((List)Conversions.doWrapArray((Object)jProject.getResolvedClasspath(false))).forEach(_function_2);
                String str = cp.toString();
                InputOutput.println((Object)str);
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        };
        ((List)Conversions.doWrapArray((Object)ResourcesPlugin.getWorkspace().getRoot().getProjects())).forEach(_function);
    }

    public void setTargetPlatform() throws Exception {
        ITargetPlatformService tpService = TargetPlatformService.getDefault();
        ITargetDefinition targetDef = tpService.newTarget();
        targetDef.setName("Tycho platform");
        Bundle[] bundles = Platform.getBundle((String)"org.eclipse.core.runtime").getBundleContext().getBundles();
        ArrayList<ITargetLocation> bundleContainers = new ArrayList<ITargetLocation>();
        HashSet<File> dirs = new HashSet<File>();
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            boolean _not;
            Bundle bundle = bundleArray[n2];
            EquinoxBundle bundleImpl = (EquinoxBundle)bundle;
            Object _revisionInfo = bundleImpl.getModule().getCurrentRevision().getRevisionInfo();
            BundleInfo.Generation generation = (BundleInfo.Generation)_revisionInfo;
            File file = generation.getBundleFile().getBaseFile();
            File folder = file.getParentFile();
            boolean _contains = dirs.contains(folder);
            boolean bl = _not = !_contains;
            if (_not) {
                dirs.add(folder);
                bundleContainers.add(tpService.newDirectoryLocation(folder.getAbsolutePath()));
            }
            ++n2;
        }
        ITargetLocation[] bundleContainersArray = (ITargetLocation[])Conversions.unwrapArray(bundleContainers, ITargetLocation.class);
        targetDef.setTargetLocations(bundleContainersArray);
        targetDef.setArch(Platform.getOSArch());
        targetDef.setOS(Platform.getOS());
        targetDef.setWS(Platform.getWS());
        targetDef.setNL(Platform.getNL());
        tpService.saveTargetDefinition(targetDef);
        LoadTargetDefinitionJob job = new LoadTargetDefinitionJob(targetDef);
        job.schedule();
        job.join();
    }

    public static void invokeCommandOnSelectedFile(String commandId, String file) {
        try {
            boolean _not;
            IHandlerService _service_1;
            ICommandService _service;
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            IWorkbench wb = PlatformUI.getWorkbench();
            ICommandService commandService = _service = (ICommandService)wb.getService(ICommandService.class);
            IHandlerService handlerService = _service_1 = (IHandlerService)wb.getService(IHandlerService.class);
            Command command = commandService.getCommand(commandId);
            ExecutionEvent executionEvent = handlerService.createExecutionEvent(command, null);
            Object _applicationContext = executionEvent.getApplicationContext();
            IEvaluationContext context = (IEvaluationContext)_applicationContext;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)file);
            boolean bl = _not = !_isNullOrEmpty;
            if (_not) {
                IWorkspaceRoot _root = ws.getRoot();
                Path _path = new Path(file);
                IFile iFile = _root.getFile((IPath)_path);
                IEvaluationContext _parent = context.getParent();
                StructuredSelection _structuredSelection = new StructuredSelection((Object)iFile);
                _parent.addVariable("activeMenuSelection", (Object)_structuredSelection);
            }
            command.executeWithChecks(executionEvent);
            IResourcesSetupUtil.reallyWaitForAutoBuild();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public ClassLoader createClassLoader(IJavaProject project) {
        try {
            String[] classPathEntries = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)project);
            ArrayList<URL> urlList = new ArrayList<URL>();
            int i = 0;
            while (i < classPathEntries.length) {
                String entry = classPathEntries[i];
                Path path = new Path(entry);
                URL url = path.toFile().toURI().toURL();
                urlList.add(url);
                ++i;
            }
            ClassLoader parentClassLoader = project.getClass().getClassLoader();
            return new URLClassLoader((URL[])Conversions.unwrapArray(urlList, URL.class), parentClassLoader);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void waitFileExistOrAssert(String fileName, int retry, long sleep) {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, retry, true);
        for (Integer i : _doubleDotLessThan) {
            Path _path;
            IWorkspaceRoot _root = ws.getRoot();
            boolean _exists = _root.getFile((IPath)(_path = new Path(fileName))).exists();
            if (_exists) {
                return;
            }
            try {
                Thread.sleep(sleep);
            }
            catch (Throwable _t) {
                if (_t instanceof InterruptedException) continue;
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        this.assertFileExists(fileName);
    }

    public static void reallyWaitForJobs(int retry) {
        try {
            IntegerRange _upTo = new IntegerRange(0, retry);
            for (Integer i : _upTo) {
                WorkspaceTestHelper.waitForJobs();
                Thread.sleep(100L);
            }
            WorkspaceTestHelper.waitForJobs();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static void waitForJobs() {
        try {
            boolean _not;
            int delay = 500;
            int retry = 600;
            boolean _isIdle = Job.getJobManager().isIdle();
            boolean bl = _not = !_isIdle;
            if (_not) {
                WorkspaceTestHelper.delay(500L);
            }
            while (!Job.getJobManager().isIdle()) {
                Job currentJob = Job.getJobManager().currentJob();
                if (retry % 10 == 0) {
                    Job[] jobs;
                    Job[] jobArray = jobs = Job.getJobManager().find(null);
                    int n = jobs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Job job = jobArray[n2];
                        if (job == currentJob) {
                            String _name = job.getName();
                            String _plus = "[waitForJobs](current) " + _name;
                            String _plus_1 = String.valueOf(_plus) + " (rule=";
                            ISchedulingRule _rule = job.getRule();
                            String _plus_2 = String.valueOf(_plus_1) + _rule;
                            String _plus_3 = String.valueOf(_plus_2) + ")";
                            InputOutput.println((Object)_plus_3);
                        } else {
                            String _name_1 = job.getName();
                            String _plus_4 = "[waitForJobs] " + _name_1;
                            String _plus_5 = String.valueOf(_plus_4) + " (rule=";
                            ISchedulingRule _rule_1 = job.getRule();
                            String _plus_6 = String.valueOf(_plus_5) + _rule_1;
                            String _plus_7 = String.valueOf(_plus_6) + ")";
                            InputOutput.println((Object)_plus_7);
                        }
                        if (retry <= 300 && (job.getName().contains("Git Repository Change Scanner") || job.getName().contains("Periodic workspace save") || job.getName().contains("Workbench Auto-Save Job") || job.getName().contains("Compacting resource model"))) {
                            String _name_2 = job.getName();
                            String _plus_8 = "[waitForJobs] CANCELLING job " + _name_2;
                            String _plus_9 = String.valueOf(_plus_8) + " (rule=";
                            ISchedulingRule _rule_2 = job.getRule();
                            String _plus_10 = String.valueOf(_plus_9) + _rule_2;
                            String _plus_11 = String.valueOf(_plus_10) + ")";
                            InputOutput.println((Object)_plus_11);
                        }
                        ++n2;
                    }
                    Functions.Function1 _function = j -> {
                        ISchedulingRule _rule = j.getRule();
                        return _rule != null;
                    };
                    Functions.Function1 _function_1 = j -> j.getRule();
                    Iterable rules = IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)jobs)), (Functions.Function1)_function), (Functions.Function1)_function_1);
                    Consumer<ISchedulingRule> _function_2 = r1 -> {
                        Consumer<ISchedulingRule> _function_3 = r2 -> {
                            if (!Objects.equal((Object)r1, (Object)r2) && r1.isConflicting(r2)) {
                                InputOutput.println((Object)("[waitForJobs] conflicting rules: " + r1 + " / " + r2));
                            }
                        };
                        rules.forEach(_function_3);
                    };
                    rules.forEach(_function_2);
                }
                WorkspaceTestHelper.delay(500L);
                if (--retry > 0) continue;
                throw new InterruptedException("waitForJobs timed out after " + Integer.valueOf(300000) + "ms");
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void delay(long waitTimeMillis) {
        Display display = Display.getCurrent();
        IWorkbench _workbench = PlatformUI.getWorkbench();
        _workbench.addWindowListener(new IWindowListener(){

            public void windowActivated(IWorkbenchWindow window) {
            }

            public void windowClosed(IWorkbenchWindow window) {
                closed = true;
            }

            public void windowDeactivated(IWorkbenchWindow window) {
            }

            public void windowOpened(IWorkbenchWindow window) {
            }
        });
        if (display != null) {
            long _currentTimeMillis = System.currentTimeMillis();
            long endTimeMillis = _currentTimeMillis + waitTimeMillis / 2L;
            while (System.currentTimeMillis() < endTimeMillis && !closed) {
                boolean _not;
                boolean _readAndDispatch = display.readAndDispatch();
                boolean bl = _not = !_readAndDispatch;
                if (!_not) continue;
                display.sleep();
            }
            display.update();
            try {
                Thread.sleep(waitTimeMillis / 2L);
                return;
            }
            catch (Throwable _t) {
                if (_t instanceof InterruptedException) return;
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        try {
            Thread.sleep(waitTimeMillis);
            return;
        }
        catch (Throwable _t) {
            if (_t instanceof InterruptedException) return;
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }
}

