/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.addon.multidimensional.timeline.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.binding.NumberExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.OverrunStyle;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.HLineTo;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.VLineTo;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gemoc.trace.commons.model.trace.Dimension;
import org.eclipse.gemoc.trace.commons.model.trace.State;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.gemoc.trace.commons.model.trace.TracedObject;
import org.eclipse.gemoc.trace.commons.model.trace.Value;
import org.eclipse.gemoc.trace.gemoc.api.ITraceExplorer;
import org.eclipse.gemoc.trace.gemoc.api.ITraceExtractor;
import org.eclipse.gemoc.trace.gemoc.api.ITraceViewListener;

public class MultidimensionalTimelineRenderer
extends Pane
implements ITraceViewListener {
    private ITraceExplorer<Step<?>, State<?, ?>, TracedObject<?>, Dimension<?>, Value<?>> traceExplorer;
    private ITraceExtractor<Step<?>, State<?, ?>, TracedObject<?>, Dimension<?>, Value<?>> traceExtractor;
    private final IntegerProperty currentState;
    private final IntegerProperty currentStep;
    private final ScrollPane bodyScrollPane;
    private final VBox headerPane;
    private final Pane bodyPane;
    private final VBox valuesLines;
    private final DoubleProperty valueTitleWidth;
    private final DoubleProperty statesPaneHeight;
    private final BooleanProperty displayGrid;
    private final IntegerProperty nbDisplayableStates;
    private final IntegerProperty visibleStatesRange;
    private final IntegerProperty nbStates;
    private BooleanBinding displayGridBinding;
    private final Path diagonalHatching = new Path();
    private final Font statesFont = Font.font((String)"Arial", (FontWeight)FontWeight.BOLD, (double)12.0);
    private final Font valuesFont = Font.font((String)"Arial", (FontWeight)FontWeight.BOLD, (double)11.0);
    private final Font stateNumbersFont = Font.font((String)"Arial", (FontWeight)FontWeight.BOLD, (double)9.0);
    private final Image stepValueGraphic;
    private final Image backValueGraphic;
    private int lastClickedState = -1;
    private final Consumer<Integer> jumpConsumer = i -> this.traceExplorer.jump(this.traceExtractor.getState(i.intValue()));
    private final Supplier<Integer> lastClickedStateSupplier = () -> this.lastClickedState;
    private boolean stateColoration;
    private static final int H_MARGIN = 8;
    private static final int V_MARGIN = 2;
    private static final int DIAMETER = 24;
    private static final int V_HEIGHT = 8;
    private static final int UNIT = 40;
    private static final Insets MARGIN_INSETS = new Insets(2.0, 8.0, 2.0, 8.0);
    private static final Insets HALF_MARGIN_INSETS = new Insets(2.0, 4.0, 2.0, 4.0);
    private static final Background HEADER_BACKGROUND = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.LIGHTGRAY, null, null)});
    private static final Background BODY_BACKGROUND = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, null, null)});
    private static final Background TRANSPARENT_BACKGROUND = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, null, null)});
    private static final Paint LINE_PAINT = new Color(Color.LIGHTGRAY.getRed(), Color.LIGHTGRAY.getGreen(), Color.LIGHTGRAY.getBlue(), 0.5);
    private static final Background LINE_BACKGROUND = new Background(new BackgroundFill[]{new BackgroundFill(LINE_PAINT, null, null)});
    private Path statesGrid = null;
    private Rectangle highlightRectangle = null;
    private boolean scrollLock = false;
    private final Pane statesPane = new Pane();
    private final Image playGraphic;
    private final Image replayGraphic;
    private final BooleanProperty isInReplayMode;
    private static final int CURRENT_FORWARD_STEP = 0;
    private static final int CURRENT_BACKWARD_STEP = 1;
    private static final int CURRENT_BIGSTEP = 2;
    private Consumer<List<Boolean>> displayMenu = null;

    public MultidimensionalTimelineRenderer() {
        this.headerPane = new VBox();
        this.valuesLines = new VBox();
        this.bodyPane = new Pane();
        this.bodyScrollPane = new ScrollPane((Node)this.bodyPane);
        this.backValueGraphic = new Image("/icons/nav_backward.gif");
        this.stepValueGraphic = new Image("/icons/nav_forward.gif");
        this.playGraphic = new Image("/icons/start_task.gif");
        this.replayGraphic = new Image("/icons/restart_task.gif");
        this.valueTitleWidth = new SimpleDoubleProperty();
        this.statesPaneHeight = new SimpleDoubleProperty();
        this.displayGrid = new SimpleBooleanProperty();
        this.isInReplayMode = new SimpleBooleanProperty();
        this.nbDisplayableStates = new SimpleIntegerProperty();
        this.nbDisplayableStates.bind((ObservableValue)this.headerPane.widthProperty().divide(40));
        this.nbStates = new SimpleIntegerProperty(0);
        this.currentState = new SimpleIntegerProperty();
        this.currentStep = new SimpleIntegerProperty(0);
        this.visibleStatesRange = new SimpleIntegerProperty();
        this.visibleStatesRange.bind((ObservableValue)this.nbStates.add(1).subtract((ObservableNumberValue)this.nbDisplayableStates));
        this.nbDisplayableStates.addListener((v, o, n) -> this.refresh());
        this.currentState.addListener((v, o, n) -> this.refresh());
        this.currentStep.addListener((v, o, n) -> this.refresh());
        this.visibleStatesRange.addListener((v, o, n) -> {
            if (this.currentState.intValue() >= this.visibleStatesRange.intValue()) {
                this.currentState.set(this.visibleStatesRange.intValue() - 1);
            }
        });
        this.bodyScrollPane.setFitToWidth(true);
        this.bodyScrollPane.setBorder(Border.EMPTY);
        this.bodyScrollPane.setBackground(BODY_BACKGROUND);
        this.bodyScrollPane.setVisible(false);
        this.bodyPane.setBackground(BODY_BACKGROUND);
        this.statesPane.minHeightProperty().bind((ObservableValue)this.statesPaneHeight);
        this.statesPane.heightProperty().addListener((v, o, n) -> {
            if (n.doubleValue() > this.statesPaneHeight.doubleValue()) {
                this.statesPaneHeight.set(n.doubleValue());
            }
        });
        this.headerPane.minWidthProperty().bind((ObservableValue)this.widthProperty());
        this.headerPane.maxWidthProperty().bind((ObservableValue)this.widthProperty());
        this.valuesLines.minWidthProperty().bind((ObservableValue)this.widthProperty());
        this.valuesLines.maxWidthProperty().bind((ObservableValue)this.widthProperty());
        this.valuesLines.getChildren().addListener((ListChangeListener)new ListChangeListener<Node>(){

            public void onChanged(ListChangeListener.Change<? extends Node> c) {
                ObservableList l = c.getList();
                int i = 0;
                for (Node n : l) {
                    Pane p = (Pane)n;
                    if (i % 2 == 1) {
                        p.setBackground(LINE_BACKGROUND);
                    } else {
                        p.setBackground(TRANSPARENT_BACKGROUND);
                    }
                    ++i;
                }
            }
        });
        int i2 = 0;
        while (i2 < 5) {
            double x1 = Math.max(-0.5 + 0.25 * (double)i2, 0.0);
            double y1 = Math.max(0.5 - 0.25 * (double)i2, 0.0);
            double x2 = Math.min(0.5 + 0.25 * (double)i2, 1.0);
            double y2 = Math.min(1.5 - 0.25 * (double)i2, 1.0);
            MoveTo move = new MoveTo(x1 * 24.0, y1 * 24.0);
            LineTo line = new LineTo(x2 * 24.0, y2 * 24.0);
            this.diagonalHatching.getElements().addAll((Object[])new PathElement[]{move, line});
            ++i2;
        }
        this.headerPane.setBackground(HEADER_BACKGROUND);
        this.valuesLines.setBackground(TRANSPARENT_BACKGROUND);
        this.setBackground(BODY_BACKGROUND);
        this.setupStatesPane();
        this.bodyPane.getChildren().add((Object)this.valuesLines);
        this.bodyScrollPane.translateYProperty().bind((ObservableValue)this.headerPane.heightProperty());
        this.bodyScrollPane.maxHeightProperty().bind((ObservableValue)this.heightProperty().subtract((ObservableNumberValue)this.headerPane.heightProperty()));
        this.getChildren().add((Object)this.headerPane);
        this.getChildren().add((Object)this.bodyScrollPane);
        this.minHeightProperty().bind((ObservableValue)this.headerPane.heightProperty().add((ObservableNumberValue)this.bodyScrollPane.heightProperty()));
        this.prefHeightProperty().bind((ObservableValue)this.headerPane.heightProperty().add((ObservableNumberValue)this.bodyScrollPane.heightProperty()));
        this.maxHeightProperty().bind((ObservableValue)this.headerPane.heightProperty().add((ObservableNumberValue)this.bodyScrollPane.heightProperty()));
    }

    private void showState(State<?, ?> state, boolean jump) {
        int toShow = Math.min(this.nbStates.intValue() - 1, Math.max(0, this.traceExtractor.getStateIndex(state)));
        int effectiveToShow = Math.min(this.visibleStatesRange.intValue() - 1, Math.max(0, toShow - this.nbDisplayableStates.intValue() / 2));
        if (jump) {
            this.traceExplorer.jump(this.traceExtractor.getState(effectiveToShow));
        }
        this.currentState.set(effectiveToShow);
    }

    private Pane setupStatesPane() {
        Label titleLabel = new Label("All execution states (0)");
        this.nbStates.addListener((v, o, n) -> {
            String s = "All execution states (" + n.intValue() + ")";
            Platform.runLater(() -> {
                titleLabel.setText(s);
                titleLabel.setContentDisplay(ContentDisplay.RIGHT);
                ImageView nodeGraphic = new ImageView();
                nodeGraphic.setImage(this.playGraphic);
                titleLabel.setGraphic((Node)nodeGraphic);
                this.isInReplayMode.addListener((val, old, neu) -> {
                    if (old != neu) {
                        if (neu.booleanValue()) {
                            nodeGraphic.setImage(this.replayGraphic);
                        } else {
                            nodeGraphic.setImage(this.playGraphic);
                        }
                    }
                });
            });
        });
        titleLabel.setFont(this.statesFont);
        VBox.setMargin((Node)titleLabel, (Insets)HALF_MARGIN_INSETS);
        titleLabel.setAlignment(Pos.CENTER);
        ScrollBar scrollBar = new ScrollBar();
        scrollBar.setVisibleAmount(1.0);
        scrollBar.setBlockIncrement(10.0);
        scrollBar.setMin(0.0);
        IntegerBinding statesRange = this.visibleStatesRange.subtract(1);
        scrollBar.disableProperty().bind((ObservableValue)statesRange.lessThanOrEqualTo(0));
        scrollBar.maxProperty().bind((ObservableValue)statesRange);
        scrollBar.valueProperty().addListener((v, o, n) -> {
            if (o.intValue() != n.intValue() && n.intValue() != this.currentState.intValue()) {
                this.currentState.set(n.intValue());
            }
        });
        this.currentState.addListener((v, o, n) -> {
            if (o.intValue() != n.intValue() && n.intValue() != scrollBar.valueProperty().intValue()) {
                scrollBar.setValue((double)n.intValue());
            }
        });
        HBox hBox = new HBox();
        Polygon arrow = new Polygon(new double[]{2.5, 10.0, 10.0, 5.0, 2.5, 0.0});
        HBox.setMargin((Node)arrow, (Insets)HALF_MARGIN_INSETS);
        Label toggleValuesLabel = new Label("Timeline for dynamic information\t");
        toggleValuesLabel.setFont(this.statesFont);
        hBox.setAlignment(Pos.CENTER_LEFT);
        hBox.getChildren().addAll((Object[])new Node[]{arrow, toggleValuesLabel});
        hBox.setCursor(Cursor.HAND);
        hBox.setOnMouseClicked(e -> {
            if (this.bodyScrollPane.isVisible()) {
                this.bodyScrollPane.setVisible(false);
                arrow.setRotate(0.0);
            } else {
                this.bodyScrollPane.setVisible(true);
                arrow.setRotate(90.0);
            }
        });
        VBox.setMargin((Node)hBox, (Insets)HALF_MARGIN_INSETS);
        this.headerPane.getChildren().addAll((Object[])new Node[]{scrollBar, titleLabel, this.statesPane, hBox});
        VBox.setMargin((Node)this.statesPane, (Insets)MARGIN_INSETS);
        return this.headerPane;
    }

    private Pane setupValuePane(Dimension<?> dimension, Label titleLabel, Pane contentPane) {
        HBox titlePane = new HBox();
        VBox valueVBox = new VBox();
        ImageView backValueGraphicNode = new ImageView(this.backValueGraphic);
        double buttonScale = 0.66;
        backValueGraphicNode.setScaleX(1.5151515151515151);
        backValueGraphicNode.setScaleY(1.5151515151515151);
        Button backValue = new Button("", (Node)backValueGraphicNode);
        backValue.setOnAction(e -> this.traceExplorer.backValue(dimension));
        backValue.setScaleX(0.66);
        backValue.setScaleY(0.66);
        backValue.setDisable(!this.traceExplorer.canBackValue(dimension));
        ImageView stepValueGraphicNode = new ImageView(this.stepValueGraphic);
        stepValueGraphicNode.setScaleX(1.5151515151515151);
        stepValueGraphicNode.setScaleY(1.5151515151515151);
        Button stepValue = new Button("", (Node)stepValueGraphicNode);
        stepValue.setOnAction(e -> this.traceExplorer.stepValue(dimension));
        stepValue.setDisable(!this.traceExplorer.canStepValue(dimension));
        stepValue.setScaleX(0.66);
        stepValue.setScaleY(0.66);
        titlePane.setAlignment(Pos.CENTER_LEFT);
        VBox.setMargin((Node)titlePane, (Insets)HALF_MARGIN_INSETS);
        VBox.setMargin((Node)contentPane, (Insets)MARGIN_INSETS);
        CheckBox showValueCheckBox = new CheckBox();
        showValueCheckBox.setScaleX(0.66);
        showValueCheckBox.setScaleY(0.66);
        boolean hide = this.traceExtractor.isDimensionIgnored(dimension);
        if (hide) {
            showValueCheckBox.setSelected(false);
        } else {
            showValueCheckBox.setSelected(true);
        }
        BooleanProperty sel = showValueCheckBox.selectedProperty();
        backValue.visibleProperty().bind((ObservableValue)sel);
        stepValue.visibleProperty().bind((ObservableValue)sel);
        sel.addListener((v, o, n) -> {
            if (o != n) {
                this.traceExtractor.ignoreDimension(dimension, n == false);
                if (n.booleanValue()) {
                    valueVBox.getChildren().add((Object)contentPane);
                } else {
                    valueVBox.getChildren().remove((Object)contentPane);
                }
                this.sortValueLines();
            }
        });
        titlePane.getChildren().addAll((Object[])new Node[]{showValueCheckBox, titleLabel, backValue, stepValue});
        valueVBox.getChildren().add((Object)titlePane);
        if (!hide) {
            valueVBox.getChildren().add((Object)contentPane);
        }
        this.valuesLines.getChildren().add((Object)valueVBox);
        valueVBox.setUserData(dimension);
        titleLabel.minWidthProperty().bind((ObservableValue)this.valueTitleWidth);
        titleLabel.widthProperty().addListener((v, o, n) -> {
            if (n.doubleValue() > this.valueTitleWidth.get()) {
                this.valueTitleWidth.set(n.doubleValue());
            }
        });
        if (titleLabel.widthProperty().doubleValue() > this.valueTitleWidth.get()) {
            this.valueTitleWidth.set(titleLabel.widthProperty().doubleValue());
        }
        return valueVBox;
    }

    private HBox createStateTraceLine() {
        HBox hBox = new HBox();
        this.statesPane.getChildren().add((Object)hBox);
        this.headerPane.setFocusTraversable(true);
        return hBox;
    }

    private HBox createValueTraceLine(Dimension<?> dimension) {
        HBox hBox = new HBox();
        String title = String.valueOf(this.traceExtractor.getDimensionLabel(dimension)) + "  ";
        Label titleLabel = new Label(title);
        titleLabel.setFont(this.valuesFont);
        Pane pane = this.setupValuePane(dimension, titleLabel, (Pane)hBox);
        pane.setFocusTraversable(true);
        return hBox;
    }

    private String computeStateLabel(int stateNumber) {
        if (stateNumber > 999) {
            return String.valueOf(stateNumber / 1000) + "k" + stateNumber % 1000 / 100;
        }
        return "" + stateNumber;
    }

    private void fillStateLine(HBox line, List<State<?, ?>> states, int selectedState) {
        Color currentColor = Color.CORAL;
        Color otherColor = Color.SLATEBLUE;
        int height = 24;
        int width = 24;
        int currentStateIndex = Math.max(0, this.currentState.intValue());
        int diff = states.isEmpty() ? 0 : currentStateIndex - this.traceExtractor.getStateIndex(states.get(0));
        List colorGroups = this.stateColoration ? this.computeColorGroups(states) : Collections.emptyList();
        int nbColors = colorGroups.size();
        ArrayList<Color> colorPalette = new ArrayList<Color>();
        if (nbColors > 0) {
            double interval = 360.0 / (double)nbColors;
            int i = currentStateIndex % nbColors;
            while (i < nbColors) {
                colorPalette.add(Color.hsb((double)((double)i * interval), (double)0.75, (double)0.7));
                ++i;
            }
            i = 0;
            while (i < currentStateIndex % nbColors) {
                colorPalette.add(Color.hsb((double)((double)i * interval), (double)0.75, (double)0.7));
                ++i;
            }
        }
        int[] stateToColor = new int[states.size()];
        int i = 0;
        while (i < nbColors) {
            List stateGroup = (List)colorGroups.get(i);
            for (Integer state : stateGroup) {
                stateToColor[state.intValue() % stateToColor.length] = i;
            }
            ++i;
        }
        line.getChildren().clear();
        if (diff > 0) {
            line.setTranslateX((double)(-(40 * diff)));
        }
        for (State<?, ?> state : states) {
            int idx;
            int stateIndex = this.traceExtractor.getStateIndex(state);
            Rectangle rectangle = selectedState == stateIndex ? new Rectangle(24.0, 24.0, (Paint)currentColor) : (this.stateColoration && !colorPalette.isEmpty() ? ((idx = stateToColor[stateIndex % stateToColor.length]) != -1 ? new Rectangle(24.0, 24.0, (Paint)colorPalette.get(idx)) : new Rectangle(24.0, 24.0, (Paint)otherColor)) : new Rectangle(24.0, 24.0, (Paint)otherColor));
            rectangle.setArcHeight(24.0);
            rectangle.setArcWidth(24.0);
            rectangle.setUserData(state);
            rectangle.addEventHandler(MouseEvent.MOUSE_CLICKED, e -> {
                if (e.getClickCount() > 1 && e.getButton() == MouseButton.PRIMARY) {
                    this.traceExplorer.jump(state);
                }
                if (e.getClickCount() == 1 && e.getButton() == MouseButton.SECONDARY) {
                    this.lastClickedState = stateIndex;
                    ArrayList<Boolean> enabledItems = new ArrayList<Boolean>();
                    enabledItems.add(this.traceExtractor.isStateBreakable(state));
                    enabledItems.add(true);
                    this.displayMenu.accept(enabledItems);
                }
            });
            this.displayGridBinding = this.displayGridBinding.or((ObservableBooleanValue)rectangle.hoverProperty());
            String s = this.traceExtractor.getStateDescription(state);
            Tooltip t = new Tooltip(s);
            Tooltip.install((Node)rectangle, (Tooltip)t);
            Label text = new Label(this.computeStateLabel(stateIndex));
            text.setTextOverrun(OverrunStyle.ELLIPSIS);
            text.setAlignment(Pos.CENTER);
            text.setMouseTransparent(true);
            text.setTextFill((Paint)Color.WHITE);
            text.setFont(this.stateNumbersFont);
            text.setMaxWidth(24.0);
            StackPane layout = new StackPane();
            StackPane.setMargin((Node)rectangle, (Insets)MARGIN_INSETS);
            if (!this.traceExtractor.isStateBreakable(state)) {
                Shape hatching = Shape.intersect((Shape)rectangle, (Shape)this.diagonalHatching);
                hatching.setFill((Paint)Color.LIGHTGRAY);
                layout.getChildren().addAll((Object[])new Node[]{rectangle, hatching, text});
            } else {
                layout.getChildren().addAll((Object[])new Node[]{rectangle, text});
            }
            line.getChildren().add((Object)layout);
        }
    }

    private void fillValueLine(HBox line, Dimension<?> dimension, int start, int end, int selectedState) {
        int diff;
        int currentStateIndex;
        List values = this.traceExtractor.getValuesForStates(dimension, start, end);
        Color currentColor = Color.DARKORANGE;
        Color otherColor = Color.DARKBLUE;
        int height = 8;
        line.getChildren().clear();
        int stateIndex = currentStateIndex = Math.max(0, this.currentState.intValue());
        int n = diff = values.isEmpty() ? 0 : currentStateIndex - this.traceExtractor.getValueFirstStateIndex((Value)values.get(0));
        if (diff > 0) {
            line.setTranslateX((double)(-(40 * diff)));
        }
        for (Value value : values) {
            int firstStateIndex = this.traceExtractor.getValueFirstStateIndex(value);
            int lastStateIndex = this.traceExtractor.getValueLastStateIndex(value);
            if (firstStateIndex > stateIndex) {
                int width = 24 + 40 * (firstStateIndex - stateIndex - 1);
                Rectangle rectangle = new Rectangle((double)width, 8.0, (Paint)Color.TRANSPARENT);
                line.getChildren().add((Object)rectangle);
                HBox.setMargin((Node)rectangle, (Insets)MARGIN_INSETS);
            }
            int width = 24 + 40 * (lastStateIndex - firstStateIndex);
            Rectangle rectangle = selectedState >= firstStateIndex && selectedState <= lastStateIndex ? new Rectangle((double)width, 8.0, (Paint)currentColor) : new Rectangle((double)width, 8.0, (Paint)otherColor);
            rectangle.setArcHeight(8.0);
            rectangle.setArcWidth(12.0);
            rectangle.setUserData((Object)value);
            rectangle.addEventHandler(MouseEvent.MOUSE_CLICKED, e -> {
                if (e.getClickCount() > 1 && e.getButton() == MouseButton.PRIMARY) {
                    this.traceExplorer.jump(value);
                }
            });
            this.displayGridBinding = this.displayGridBinding.or((ObservableBooleanValue)rectangle.hoverProperty());
            String s = this.traceExtractor.getValueDescription(value);
            Tooltip t = new Tooltip(s);
            Tooltip.install((Node)rectangle, (Tooltip)t);
            line.getChildren().add((Object)rectangle);
            HBox.setMargin((Node)rectangle, (Insets)MARGIN_INSETS);
            stateIndex = lastStateIndex + 1;
        }
    }

    private NumberExpression createSteps(Step<?> step, int depth, int currentStateIndex, int selectedStateIndex, int firstStateIndex, int lastStateIndex, List<Path> accumulator, Object[] stepTargets) {
        int stepStartingIndex = this.traceExtractor.getStateIndex(step.getStartingState());
        boolean endedStep = step.getEndingState() != null;
        int startingIndex = stepStartingIndex - currentStateIndex;
        int endingIndex = (endedStep ? this.traceExtractor.getStateIndex(step.getEndingState()) : this.nbStates.intValue()) - currentStateIndex;
        Path path = new Path();
        path.setStrokeWidth(2.0);
        double x1 = startingIndex * 40 + 20;
        double x4 = endingIndex * 40 + 20;
        double x2 = x1 + 10.0;
        double x3 = x4 - 10.0;
        double baseLineY = 14.0;
        MoveTo moveTo = new MoveTo(x1, 14.0);
        LineTo lineTo = new LineTo(x2, 14.0);
        HLineTo hLineTo = new HLineTo(x3);
        path.getElements().addAll((Object[])new PathElement[]{moveTo, lineTo, hLineTo});
        if (endedStep) {
            LineTo lastLineTo = new LineTo(x4, 14.0);
            path.getElements().add((Object)lastLineTo);
        }
        accumulator.add(path);
        List subSteps = this.traceExtractor.getSubSteps(step);
        SimpleDoubleProperty yOffset = new SimpleDoubleProperty(0.0);
        if (subSteps != null && !subSteps.isEmpty()) {
            for (Step subStep : subSteps) {
                if (subStep.getStartingState() == subStep.getEndingState()) continue;
                yOffset = Bindings.max((ObservableNumberValue)yOffset, (ObservableNumberValue)this.createSteps(subStep, depth + 1, currentStateIndex, selectedStateIndex, firstStateIndex, lastStateIndex, accumulator, stepTargets));
            }
        }
        lineTo.yProperty().bind((ObservableValue)yOffset.add(14));
        if (stepTargets[0] == step) {
            path.setStroke((Paint)Color.DARKORANGE);
        } else if (stepTargets[1] == step) {
            path.setStroke((Paint)Color.DARKGREEN);
        } else if (stepTargets[2] == step) {
            path.setStroke((Paint)Color.DARKRED);
        } else {
            path.setStroke((Paint)Color.DARKBLUE);
            if (!this.traceExplorer.getCallStack().contains(step) && (stepStartingIndex > selectedStateIndex || stepStartingIndex == selectedStateIndex && endedStep)) {
                path.getStrokeDashArray().addAll((Object[])new Double[]{5.0, 5.0});
                path.setStrokeLineCap(StrokeLineCap.ROUND);
            }
        }
        return lineTo.yProperty();
    }

    private void sortValueLines() {
        HashMap map = new HashMap();
        ObservableList lines = this.valuesLines.getChildren();
        ArrayList nodes = new ArrayList();
        ArrayList hiddenNodes = new ArrayList();
        lines.forEach(n -> {
            Node node = map.put((Dimension)n.getUserData(), n);
        });
        lines.clear();
        this.traceExtractor.getDimensions().forEach(d -> {
            Node n = (Node)map.get(d);
            if (this.traceExtractor.isDimensionIgnored(d)) {
                hiddenNodes.add(n);
            } else {
                nodes.add(n);
            }
        });
        lines.addAll(nodes);
        lines.addAll(hiddenNodes);
    }

    public void refresh() {
        Platform.runLater(() -> {
            this.valuesLines.getChildren().clear();
            this.statesPane.getChildren().clear();
            this.displayGrid.unbind();
            if (this.traceExplorer == null) {
                return;
            }
            this.isInReplayMode.set(this.traceExplorer.isInReplayMode());
            int currentStateStartIndex = Math.max(0, this.currentState.intValue());
            int currentStateEndIndex = Math.min(currentStateStartIndex + this.nbDisplayableStates.intValue(), this.traceExtractor.getStatesTraceLength());
            int selectedStateIndex = this.traceExtractor.getStateIndex(this.traceExplorer.getCurrentState());
            this.displayGridBinding = new BooleanBinding(){

                protected boolean computeValue() {
                    return false;
                }
            };
            HBox hBox = this.createStateTraceLine();
            this.fillStateLine(hBox, this.traceExtractor.getStates(currentStateStartIndex - 1, currentStateEndIndex + 1), selectedStateIndex);
            ArrayList dimensions = new ArrayList(this.traceExtractor.getDimensions());
            for (Dimension dimension : dimensions) {
                HBox hBox2 = this.createValueTraceLine(dimension);
                this.fillValueLine(hBox2, dimension, currentStateStartIndex, currentStateEndIndex + 1, selectedStateIndex);
            }
            this.sortValueLines();
            this.displayGrid.bind((ObservableValue)this.displayGridBinding);
            List rootSteps = this.traceExtractor.getSteps(currentStateStartIndex - 1, currentStateEndIndex + 1);
            ArrayList<Path> steps = new ArrayList<Path>();
            Object[] stepTargets = new Object[3];
            Step tmp = this.traceExplorer.getCurrentForwardStep();
            if (tmp != null) {
                stepTargets[0] = tmp;
            }
            if ((tmp = this.traceExplorer.getCurrentBackwardStep()) != null) {
                stepTargets[1] = tmp;
            }
            if ((tmp = this.traceExplorer.getCurrentBigStep()) != null) {
                stepTargets[2] = tmp;
            }
            for (Step step : rootSteps) {
                if (step.getStartingState() == step.getEndingState()) continue;
                this.createSteps(step, 0, currentStateStartIndex, selectedStateIndex, currentStateStartIndex - 1, currentStateEndIndex + 1, steps, stepTargets);
            }
            this.statesPane.getChildren().addAll(0, steps);
            if (this.statesGrid != null) {
                this.bodyPane.getChildren().remove((Object)this.statesGrid);
            }
            if (this.highlightRectangle != null) {
                this.bodyPane.getChildren().remove((Object)this.highlightRectangle);
            }
            this.statesGrid = new Path();
            VLineTo vLineTo = new VLineTo();
            vLineTo.yProperty().bind((ObservableValue)this.valuesLines.heightProperty());
            this.displayGrid.addListener((v, o, n) -> {
                if (n.booleanValue()) {
                    this.statesGrid.setStroke((Paint)Color.GRAY);
                } else {
                    this.statesGrid.setStroke((Paint)Color.LIGHTGRAY);
                }
            });
            this.highlightRectangle = new Rectangle();
            int i = currentStateStartIndex;
            while (i <= currentStateEndIndex) {
                if (i == selectedStateIndex) {
                    this.highlightRectangle.setX((double)(8 + (i - currentStateStartIndex) * 40));
                    this.highlightRectangle.setWidth(40.0);
                    this.highlightRectangle.heightProperty().bind((ObservableValue)this.valuesLines.heightProperty());
                }
                this.statesGrid.getElements().addAll((Object[])new PathElement[]{new MoveTo((double)(8 + (i - currentStateStartIndex) * 40), 0.0), vLineTo});
                ++i;
            }
            this.statesGrid.getStrokeDashArray().addAll((Object[])new Double[]{10.0, 10.0});
            this.statesGrid.setStrokeWidth(1.0);
            this.statesGrid.setStroke((Paint)Color.LIGHTGRAY);
            this.statesGrid.setStrokeLineCap(StrokeLineCap.ROUND);
            this.bodyPane.getChildren().add(0, (Object)this.statesGrid);
            this.highlightRectangle.setFill((Paint)Color.LIGHTGRAY);
            this.bodyPane.getChildren().add(0, (Object)this.highlightRectangle);
        });
    }

    public void setScrollLock(boolean value) {
        this.scrollLock = value;
    }

    public void setStateColoration(boolean value) {
        this.stateColoration = value;
        this.refresh();
    }

    public Consumer<Integer> getJumpConsumer() {
        return this.jumpConsumer;
    }

    public void setTraceExplorer(ITraceExplorer<Step<?>, State<?, ?>, TracedObject<?>, Dimension<?>, Value<?>> traceExplorer) {
        if (this.traceExplorer != null) {
            this.traceExplorer.removeListener((ITraceViewListener)this);
        }
        this.traceExplorer = traceExplorer;
        if (this.traceExplorer != null) {
            this.traceExplorer.registerCommand((ITraceViewListener)this, () -> this.update());
        }
        this.update();
    }

    public void setTraceExtractor(ITraceExtractor<Step<?>, State<?, ?>, TracedObject<?>, Dimension<?>, Value<?>> traceExtractor) {
        this.traceExtractor = traceExtractor;
    }

    public void update() {
        if (this.traceExplorer != null) {
            this.nbStates.set(this.traceExtractor.getStatesTraceLength());
            if (!this.scrollLock) {
                this.showState(this.traceExplorer.getCurrentState(), false);
            }
        } else {
            this.nbStates.set(0);
        }
        this.refresh();
    }

    public void dimensionsAdded(List<List<? extends EObject>> dimensions) {
    }

    public void setMenuDisplayer(Consumer<List<Boolean>> displayMenu) {
        this.displayMenu = displayMenu;
    }

    public Supplier<Integer> getLastClickedStateSupplier() {
        return this.lastClickedStateSupplier;
    }

    private List<List<Integer>> computeColorGroups(List<State<?, ?>> states) {
        return this.traceExtractor.computeStateEquivalenceClasses().stream().sorted((l1, l2) -> {
            int min1 = l1.stream().map(e -> this.traceExtractor.getStateIndex(e)).min((i1, i2) -> i1 - i2).get();
            int min2 = l2.stream().map(e -> this.traceExtractor.getStateIndex(e)).min((i1, i2) -> i1 - i2).get();
            return min1 - min2;
        }).map(l -> l.stream().filter(s -> states.contains(s)).map(e -> this.traceExtractor.getStateIndex(e)).collect(Collectors.toList())).collect(Collectors.toList());
    }
}

