/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

public class FileUtil {
    private FileUtil() {
    }

    public static void copyFolder(File sourceDir, File destDir) throws IOException {
        if (!sourceDir.isDirectory()) {
            throw new RuntimeException("sourceDir '" + sourceDir.getAbsolutePath() + "' must be an existing directory");
        }
        if (!destDir.isDirectory()) {
            throw new RuntimeException("destDir '" + destDir.getAbsolutePath() + "' must be an existing directory");
        }
        File[] children = sourceDir.listFiles();
        int i = 0;
        while (i < children.length) {
            File source = children[i];
            File dest = new File(destDir, source.getName());
            if (source.isDirectory()) {
                dest.mkdir();
                FileUtil.copyFolder(source, dest);
            } else {
                FileUtil.copyFile(source, dest);
            }
            ++i;
        }
    }

    public static void copyFile(File from, File to) throws IOException {
        FileInputStream input = null;
        FileOutputStream output = null;
        try {
            input = new FileInputStream(from);
            output = new FileOutputStream(to);
            FileUtil.copyStream(input, output);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void setContents(File to, InputStream input) throws IOException {
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(to);
            FileUtil.copyStream(input, output);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void copyStream(InputStream input, OutputStream output) throws IOException {
        int read;
        byte[] buffer = new byte[8192];
        while ((read = input.read(buffer)) > 0) {
            output.write(buffer, 0, read);
        }
    }

    public static String getStreamContents(InputStream stream, String charset) throws IOException {
        StringBuffer contents = new StringBuffer();
        char[] buf = new char[4096];
        InputStreamReader reader = null;
        try {
            int read;
            reader = charset == null ? new InputStreamReader(stream) : new InputStreamReader(stream, charset);
            while ((read = reader.read(buf)) > 0) {
                contents.append(buf, 0, read);
            }
            String string = contents.toString();
            return string;
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void delete(File file) {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            int i = 0;
            while (i < children.length) {
                FileUtil.delete(children[i]);
                ++i;
            }
        }
        file.delete();
    }
}

