/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.propertytesters;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gemoc.xdsmlframework.api.extensions.languages.LanguageDefinitionExtension;
import org.eclipse.gemoc.xdsmlframework.api.extensions.languages.LanguageDefinitionExtensionPoint;

public class GemocConcurrentPropertyTester
extends PropertyTester {
    private static final String PROPERTY_IS_MODEL = "isModel";
    private static final String PROPERTY_IS_EXECUTABLE_DOMAIN_SPECIFIC_MODEL = "isExecutableDomainSpecificModel";

    protected boolean isModel(IAdaptable receiver) {
        IFile modelFile = (IFile)receiver.getAdapter(IFile.class);
        if (modelFile != null) {
            ResourceSetImpl rs = new ResourceSetImpl();
            URI modelURI = URI.createURI((String)("platform:/resource/" + modelFile.getFullPath().toString()));
            try {
                Resource resource = rs.getResource(modelURI, true);
                if (resource != null) {
                    return true;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    protected boolean isExecutableDomainSpecificModel(IAdaptable receiver) {
        IFile modelFile = (IFile)receiver.getAdapter(IFile.class);
        if (modelFile != null) {
            return this.existsDSMLWithFileExtension(modelFile.getFileExtension());
        }
        return false;
    }

    protected boolean existsDSMLWithFileExtension(String fileExtension) {
        for (LanguageDefinitionExtension lde : LanguageDefinitionExtensionPoint.getSpecifications()) {
            if (!lde.getFileExtensions().contains(fileExtension)) continue;
            return true;
        }
        return false;
    }

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (PROPERTY_IS_MODEL.equals(property)) {
            if (receiver instanceof IAdaptable) {
                return this.isModel((IAdaptable)receiver);
            }
            return false;
        }
        if (PROPERTY_IS_EXECUTABLE_DOMAIN_SPECIFIC_MODEL.equals(property)) {
            if (receiver instanceof IAdaptable) {
                return this.isExecutableDomainSpecificModel((IAdaptable)receiver);
            }
            return false;
        }
        return false;
    }
}

