/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.format.support;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.ConversionServiceFactory;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.format.AnnotationFormatterFactory;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.Parser;
import org.springframework.format.Printer;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.format.datetime.joda.JodaTimeFormattingConfigurer;
import org.springframework.format.number.NumberFormatAnnotationFormatterFactory;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringValueResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormattingConversionServiceFactoryBean
implements FactoryBean<FormattingConversionService>,
EmbeddedValueResolverAware,
InitializingBean {
    private static final boolean jodaTimePresent = ClassUtils.isPresent((String)"org.joda.time.LocalDate", (ClassLoader)FormattingConversionService.class.getClassLoader());
    private Set<?> converters;
    private StringValueResolver embeddedValueResolver;
    private FormattingConversionService conversionService;

    public void setConverters(Set<?> converters) {
        this.converters = converters;
    }

    @Override
    public void setEmbeddedValueResolver(StringValueResolver embeddedValueResolver) {
        this.embeddedValueResolver = embeddedValueResolver;
    }

    public void afterPropertiesSet() {
        this.conversionService = new FormattingConversionService();
        this.conversionService.setEmbeddedValueResolver(this.embeddedValueResolver);
        ConversionServiceFactory.addDefaultConverters((GenericConversionService)this.conversionService);
        ConversionServiceFactory.registerConverters(this.converters, (ConverterRegistry)this.conversionService);
        this.installFormatters(this.conversionService);
    }

    public FormattingConversionService getObject() {
        return this.conversionService;
    }

    public Class<? extends FormattingConversionService> getObjectType() {
        return FormattingConversionService.class;
    }

    public boolean isSingleton() {
        return true;
    }

    protected void installFormatters(FormatterRegistry registry) {
        registry.addFormatterForFieldAnnotation(new NumberFormatAnnotationFormatterFactory());
        if (jodaTimePresent) {
            new JodaTimeFormattingConfigurer().installJodaTimeFormatting(registry);
        } else {
            registry.addFormatterForFieldAnnotation(new NoJodaDateTimeFormatAnnotationFormatterFactory());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NoJodaDateTimeFormatAnnotationFormatterFactory
    implements AnnotationFormatterFactory<DateTimeFormat> {
        private final Set<Class<?>> fieldTypes;

        public NoJodaDateTimeFormatAnnotationFormatterFactory() {
            HashSet<Class<Long>> rawFieldTypes = new HashSet<Class<Long>>(4);
            rawFieldTypes.add(Date.class);
            rawFieldTypes.add(Calendar.class);
            rawFieldTypes.add(Long.class);
            this.fieldTypes = Collections.unmodifiableSet(rawFieldTypes);
        }

        @Override
        public Set<Class<?>> getFieldTypes() {
            return this.fieldTypes;
        }

        @Override
        public Printer<?> getPrinter(DateTimeFormat annotation, Class<?> fieldType) {
            throw new IllegalStateException("JodaTime library not available - @DateTimeFormat not supported");
        }

        @Override
        public Parser<?> getParser(DateTimeFormat annotation, Class<?> fieldType) {
            throw new IllegalStateException("JodaTime library not available - @DateTimeFormat not supported");
        }
    }
}

