/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.coyote.AsyncContextCallback;
import org.apache.coyote.Constants;
import org.apache.coyote.Processor;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.res.StringManager;

public class AsyncStateMachine {
    private static final StringManager sm = StringManager.getManager((String)"org.apache.coyote");
    private volatile AsyncState state = AsyncState.DISPATCHED;
    private AsyncContextCallback asyncCtxt = null;
    private Processor processor;

    public AsyncStateMachine(Processor processor) {
        this.processor = processor;
    }

    public boolean isAsync() {
        return this.state.isAsync();
    }

    public boolean isAsyncDispatching() {
        return this.state.isDispatching();
    }

    public boolean isAsyncStarted() {
        return this.state.isStarted();
    }

    public boolean isAsyncTimingOut() {
        return this.state == AsyncState.TIMING_OUT;
    }

    public synchronized void asyncStart(AsyncContextCallback asyncCtxt) {
        if (this.state != AsyncState.DISPATCHED) {
            throw new IllegalStateException(sm.getString("asyncStateMachine.invalidAsyncState", new Object[]{"asyncStart()", this.state}));
        }
        this.state = AsyncState.STARTING;
        this.asyncCtxt = asyncCtxt;
    }

    public synchronized AbstractEndpoint.Handler.SocketState asyncPostProcess() {
        if (this.state == AsyncState.STARTING) {
            this.state = AsyncState.STARTED;
            return AbstractEndpoint.Handler.SocketState.LONG;
        }
        if (this.state == AsyncState.MUST_COMPLETE) {
            this.asyncCtxt.fireOnComplete();
            this.state = AsyncState.DISPATCHED;
            return AbstractEndpoint.Handler.SocketState.ASYNC_END;
        }
        if (this.state == AsyncState.COMPLETING) {
            this.asyncCtxt.fireOnComplete();
            this.state = AsyncState.DISPATCHED;
            return AbstractEndpoint.Handler.SocketState.ASYNC_END;
        }
        if (this.state == AsyncState.MUST_DISPATCH) {
            this.state = AsyncState.DISPATCHING;
            return AbstractEndpoint.Handler.SocketState.ASYNC_END;
        }
        if (this.state == AsyncState.DISPATCHING) {
            this.state = AsyncState.DISPATCHED;
            return AbstractEndpoint.Handler.SocketState.ASYNC_END;
        }
        if (this.state == AsyncState.ERROR) {
            this.asyncCtxt.fireOnComplete();
            this.state = AsyncState.DISPATCHED;
            return AbstractEndpoint.Handler.SocketState.ASYNC_END;
        }
        throw new IllegalStateException(sm.getString("asyncStateMachine.invalidAsyncState", new Object[]{"asyncPostProcess()", this.state}));
    }

    public synchronized boolean asyncComplete() {
        boolean doComplete = false;
        if (this.state == AsyncState.STARTING) {
            this.state = AsyncState.MUST_COMPLETE;
        } else if (this.state == AsyncState.STARTED) {
            this.state = AsyncState.COMPLETING;
            doComplete = true;
        } else if (this.state == AsyncState.TIMING_OUT || this.state == AsyncState.ERROR) {
            this.state = AsyncState.MUST_COMPLETE;
        } else {
            throw new IllegalStateException(sm.getString("asyncStateMachine.invalidAsyncState", new Object[]{"asyncComplete()", this.state}));
        }
        return doComplete;
    }

    public synchronized boolean asyncTimeout() {
        if (this.state == AsyncState.STARTED) {
            this.state = AsyncState.TIMING_OUT;
            return true;
        }
        if (this.state == AsyncState.COMPLETING || this.state == AsyncState.DISPATCHED) {
            return false;
        }
        throw new IllegalStateException(sm.getString("asyncStateMachine.invalidAsyncState", new Object[]{"asyncTimeout()", this.state}));
    }

    public synchronized boolean asyncDispatch() {
        boolean doDispatch = false;
        if (this.state == AsyncState.STARTING) {
            this.state = AsyncState.MUST_DISPATCH;
        } else if (this.state == AsyncState.STARTED || this.state == AsyncState.TIMING_OUT) {
            this.state = AsyncState.DISPATCHING;
            doDispatch = true;
        } else {
            throw new IllegalStateException(sm.getString("asyncStateMachine.invalidAsyncState", new Object[]{"asyncDispatch()", this.state}));
        }
        return doDispatch;
    }

    public synchronized void asyncDispatched() {
        if (this.state != AsyncState.DISPATCHING) {
            throw new IllegalStateException(sm.getString("asyncStateMachine.invalidAsyncState", new Object[]{"asyncDispatched()", this.state}));
        }
        this.state = AsyncState.DISPATCHED;
    }

    public synchronized boolean asyncError() {
        boolean doDispatch = false;
        if (this.state != AsyncState.DISPATCHED && this.state != AsyncState.TIMING_OUT) {
            throw new IllegalStateException(sm.getString("asyncStateMachine.invalidAsyncState", new Object[]{"asyncError()", this.state}));
        }
        this.state = AsyncState.ERROR;
        return doDispatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void asyncRun(Runnable runnable) {
        if (this.state == AsyncState.STARTING || this.state == AsyncState.STARTED) {
            ClassLoader oldCL;
            PrivilegedAction<ClassLoader> pa;
            if (Constants.IS_SECURITY_ENABLED) {
                pa = new PrivilegedGetTccl();
                oldCL = AccessController.doPrivileged(pa);
            } else {
                oldCL = Thread.currentThread().getContextClassLoader();
            }
            try {
                if (Constants.IS_SECURITY_ENABLED) {
                    pa = new PrivilegedSetTccl(this.getClass().getClassLoader());
                    AccessController.doPrivileged(pa);
                } else {
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                }
                this.processor.getExecutor().execute(runnable);
            }
            finally {
                if (Constants.IS_SECURITY_ENABLED) {
                    pa = new PrivilegedSetTccl(oldCL);
                    AccessController.doPrivileged(pa);
                } else {
                    Thread.currentThread().setContextClassLoader(oldCL);
                }
            }
        } else {
            throw new IllegalStateException(sm.getString("asyncStateMachine.invalidAsyncState", new Object[]{"asyncRun()", this.state}));
        }
    }

    public synchronized void recycle() {
        this.asyncCtxt = null;
        this.state = AsyncState.DISPATCHED;
    }

    private static class PrivilegedGetTccl
    implements PrivilegedAction<ClassLoader> {
        private PrivilegedGetTccl() {
        }

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }

    private static class PrivilegedSetTccl
    implements PrivilegedAction<Void> {
        private ClassLoader cl;

        PrivilegedSetTccl(ClassLoader cl) {
            this.cl = cl;
        }

        @Override
        public Void run() {
            Thread.currentThread().setContextClassLoader(this.cl);
            return null;
        }
    }

    private static enum AsyncState {
        DISPATCHED(false, false, false),
        STARTING(true, true, false),
        STARTED(true, true, false),
        MUST_COMPLETE(true, false, false),
        COMPLETING(true, false, false),
        TIMING_OUT(true, false, false),
        MUST_DISPATCH(true, false, true),
        DISPATCHING(true, false, true),
        ERROR(true, false, false);

        private boolean isAsync;
        private boolean isStarted;
        private boolean isDispatching;

        private AsyncState(boolean isAsync, boolean isStarted, boolean isDispatching) {
            this.isAsync = isAsync;
            this.isStarted = isStarted;
            this.isDispatching = isDispatching;
        }

        public boolean isAsync() {
            return this.isAsync;
        }

        public boolean isStarted() {
            return this.isStarted;
        }

        public boolean isDispatching() {
            return this.isDispatching;
        }
    }
}

