/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TomcatConfigLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger(TomcatConfigLocator.class);
    static final String CONFIG_PATH_FRAMEWORK_PROPERTY = "org.eclipse.gemini.web.tomcat.config.path";
    static final String DEFAULT_CONFIG_FILE_PATH = "config" + File.separator + "tomcat-server.xml";
    static final String CONFIG_PATH = "META-INF/tomcat";
    static final String DEFAULT_CONFIG_PATH = "META-INF/tomcat/default-server.xml";
    static final String USER_CONFIG_PATH = "server.xml";

    TomcatConfigLocator() {
    }

    public static InputStream resolveConfigFile(BundleContext context) throws BundleException {
        Bundle bundle = context.getBundle();
        InputStream is = TomcatConfigLocator.lookupConfigInFileSystem(context);
        if (is == null) {
            is = TomcatConfigLocator.lookupConfigInBundle(bundle);
        }
        return is;
    }

    public static File resolveConfigDir(BundleContext context) {
        File configFile = null;
        String path = context.getProperty(CONFIG_PATH_FRAMEWORK_PROPERTY);
        if (path != null && (configFile = new File(path)).exists()) {
            return configFile.getParentFile();
        }
        path = System.getProperty(CONFIG_PATH_FRAMEWORK_PROPERTY);
        if (path != null && (configFile = new File(path)).exists()) {
            return configFile.getParentFile();
        }
        configFile = new File(DEFAULT_CONFIG_FILE_PATH);
        if (configFile.exists()) {
            return configFile.getParentFile();
        }
        return null;
    }

    private static InputStream lookupConfigInFileSystem(BundleContext context) {
        InputStream result = null;
        String path = context.getProperty(CONFIG_PATH_FRAMEWORK_PROPERTY);
        if (path != null) {
            result = TomcatConfigLocator.tryGetStreamForFilePath(path);
        }
        if (result == null) {
            result = TomcatConfigLocator.tryGetStreamForFilePath(DEFAULT_CONFIG_FILE_PATH);
        }
        return result;
    }

    private static InputStream tryGetStreamForFilePath(String filePath) {
        File configFile = new File(filePath);
        if (configFile.exists()) {
            try {
                FileInputStream fis = new FileInputStream(configFile);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Configuring Tomcat from file '" + configFile + "'");
                }
                return fis;
            }
            catch (FileNotFoundException e) {
                LOGGER.warn("Found config file on disk but then received FileNotFoundException when trying to access", (Throwable)e);
            }
        }
        return null;
    }

    private static InputStream lookupConfigInBundle(Bundle bundle) throws BundleException {
        URL entry = null;
        Enumeration entries = bundle.findEntries(CONFIG_PATH, USER_CONFIG_PATH, false);
        if (entries != null && entries.hasMoreElements()) {
            entry = (URL)entries.nextElement();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Configuring Tomcat from fragment entry '" + entry + "'");
            }
        } else {
            entry = bundle.getEntry(DEFAULT_CONFIG_PATH);
            if (entry == null) {
                throw new IllegalStateException("Unable to locate default Tomcat configuration. Is the '" + bundle + "' bundle corrupt?");
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Configuring Tomcat from default config file");
            }
        }
        try {
            return entry.openStream();
        }
        catch (IOException iOException) {
            throw new BundleException("Unable to open Tomcat configuration at '" + entry + "'");
        }
    }
}

