/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.internal.url;

import java.util.Arrays;

final class Path {
    private static final String BACK_SLASH = "\\";
    private static final String PATH_SEPARATOR = "/";
    private static final String DOUBLE_PATH_SEPARATOR = "//";
    private static final String PATH_HERE = ".";
    private static final String PATH_UP = "..";
    private final String[] baseComponents;

    Path(String basePath) {
        Path.validatePath(basePath);
        String[] comps = basePath.split(PATH_SEPARATOR);
        while (comps.length > 0 && PATH_HERE.equals(comps[0])) {
            String[] c2 = new String[comps.length - 1];
            System.arraycopy(comps, 1, c2, 0, c2.length);
            comps = c2;
        }
        this.baseComponents = comps;
    }

    private Path(String[] comps) {
        this.baseComponents = comps;
    }

    private String head() {
        if (!this.isEmpty()) {
            return this.baseComponents[0];
        }
        throw new IllegalStateException("head not applicable to an empty path");
    }

    private Path tail() {
        if (!this.isEmpty()) {
            String[] c = new String[this.baseComponents.length - 1];
            System.arraycopy(this.baseComponents, 1, c, 0, c.length);
            return new Path(c);
        }
        throw new IllegalStateException("tail not applicable to an empty path");
    }

    private Path front() {
        if (!this.isEmpty()) {
            String[] c = new String[this.baseComponents.length - 1];
            System.arraycopy(this.baseComponents, 0, c, 0, c.length);
            return new Path(c);
        }
        throw new IllegalStateException("front not applicable to an empty path");
    }

    private static void validatePath(String basePath) {
        if (basePath == null) {
            throw new IllegalArgumentException("path must not be null");
        }
        if (basePath.contains(BACK_SLASH)) {
            throw new IllegalArgumentException("path must not contain '\\'");
        }
        if (basePath.endsWith(PATH_SEPARATOR)) {
            throw new IllegalArgumentException("path must not end in '/'");
        }
        if (basePath.contains(DOUBLE_PATH_SEPARATOR)) {
            throw new IllegalArgumentException("path must not contain '//'");
        }
    }

    public Path() {
        this.baseComponents = new String[0];
    }

    public Path applyRelativePath(Path relativePath) {
        try {
            Path b = this;
            Path r = relativePath;
            while (r.isUp()) {
                r = r.tail();
                b = b.front();
            }
            return b.append(r);
        }
        catch (IllegalStateException s) {
            throw new IllegalArgumentException("relative path cannot be applied", s);
        }
    }

    private Path append(Path r) {
        if (this.isEmpty()) {
            return r;
        }
        if (r.isEmpty()) {
            return this;
        }
        return new Path(String.valueOf(this.toString()) + PATH_SEPARATOR + r.toString());
    }

    private boolean isUp() {
        return !this.isEmpty() && PATH_UP.equals(this.head());
    }

    private boolean isEmpty() {
        return this.baseComponents.length == 0;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        boolean first = true;
        String[] stringArray = this.baseComponents;
        int n = this.baseComponents.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            if (!first) {
                s.append(PATH_SEPARATOR);
            }
            first = false;
            s.append(c);
            ++n2;
        }
        return s.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.baseComponents);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Path other = (Path)obj;
        return Arrays.equals(this.baseComponents, other.baseComponents);
    }
}

