/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.session;

import java.io.Externalizable;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.catalina.Manager;
import org.apache.catalina.ha.CatalinaCluster;
import org.apache.catalina.ha.ClusterManager;
import org.apache.catalina.ha.ClusterMessage;
import org.apache.catalina.ha.ClusterSession;
import org.apache.catalina.ha.session.BackupManager;
import org.apache.catalina.ha.session.ClusterManagerBase;
import org.apache.catalina.ha.session.DeltaManager;
import org.apache.catalina.ha.session.DeltaRequest;
import org.apache.catalina.ha.session.SerializablePrincipal;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.tribes.io.ReplicationStream;
import org.apache.catalina.tribes.tipis.ReplicatedMapEntry;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class DeltaSession
extends StandardSession
implements Externalizable,
ClusterSession,
ReplicatedMapEntry {
    public static final Log log = LogFactory.getLog(DeltaSession.class);
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.ha.session");
    private transient boolean isPrimarySession = true;
    private transient DeltaRequest deltaRequest = null;
    private transient long lastTimeReplicated = System.currentTimeMillis();
    protected final Lock diffLock = new ReentrantReadWriteLock().writeLock();
    private long version;

    public DeltaSession() {
        this(null);
    }

    public DeltaSession(Manager manager) {
        super(manager);
        this.resetDeltaRequest();
    }

    public boolean isDirty() {
        return this.getDeltaRequest().getSize() > 0;
    }

    public boolean isDiffable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getDiff() throws IOException {
        try {
            this.lock();
            byte[] byArray = this.getDeltaRequest().serialize();
            return byArray;
        }
        finally {
            this.unlock();
        }
    }

    public ClassLoader[] getClassLoaders() {
        if (this.manager instanceof BackupManager) {
            return ((BackupManager)this.manager).getClassLoaders();
        }
        if (this.manager instanceof ClusterManagerBase) {
            return ((ClusterManagerBase)this.manager).getClassLoaders();
        }
        if (this.manager instanceof StandardManager) {
            StandardManager sm = (StandardManager)this.manager;
            return ClusterManagerBase.getClassLoaders(sm.getContainer());
        }
        if (this.manager instanceof ManagerBase) {
            ManagerBase mb = (ManagerBase)this.manager;
            return ClusterManagerBase.getClassLoaders(mb.getContainer());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyDiff(byte[] diff, int offset, int length) throws IOException, ClassNotFoundException {
        try {
            this.lock();
            ReplicationStream stream = ((ClusterManager)this.getManager()).getReplicationStream(diff, offset, length);
            ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
            try {
                ClassLoader[] loaders = this.getClassLoaders();
                if (loaders != null && loaders.length > 0) {
                    Thread.currentThread().setContextClassLoader(loaders[0]);
                }
                this.getDeltaRequest().readExternal((ObjectInput)stream);
                this.getDeltaRequest().execute(this, ((ClusterManager)this.getManager()).isNotifyListenersOnReplication());
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextLoader);
            }
        }
        finally {
            this.unlock();
        }
    }

    public void resetDiff() {
        this.resetDeltaRequest();
    }

    public void lock() {
        this.diffLock.lock();
    }

    public void unlock() {
        this.diffLock.unlock();
    }

    public void setOwner(Object owner) {
        if (owner instanceof ClusterManager && this.getManager() == null) {
            ClusterManager cm = (ClusterManager)owner;
            this.setManager(cm);
            this.setValid(true);
            this.setPrimarySession(false);
            this.access();
            this.resetDeltaRequest();
            this.endAccess();
        }
    }

    @Override
    public boolean isPrimarySession() {
        return this.isPrimarySession;
    }

    @Override
    public void setPrimarySession(boolean primarySession) {
        this.isPrimarySession = primarySession;
    }

    public void setId(String id, boolean notify) {
        super.setId(id, notify);
        this.resetDeltaRequest();
    }

    public void setId(String id) {
        super.setId(id);
        this.resetDeltaRequest();
    }

    public void setMaxInactiveInterval(int interval) {
        this.setMaxInactiveInterval(interval, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxInactiveInterval(int interval, boolean addDeltaRequest) {
        this.maxInactiveInterval = interval;
        if (this.isValid && interval == 0) {
            this.expire();
        } else if (addDeltaRequest && this.deltaRequest != null) {
            try {
                this.lock();
                this.deltaRequest.setMaxInactiveInterval(interval);
            }
            finally {
                this.unlock();
            }
        }
    }

    public void setNew(boolean isNew) {
        this.setNew(isNew, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNew(boolean isNew, boolean addDeltaRequest) {
        super.setNew(isNew);
        if (addDeltaRequest && this.deltaRequest != null) {
            try {
                this.lock();
                this.deltaRequest.setNew(isNew);
            }
            finally {
                this.unlock();
            }
        }
    }

    public void setPrincipal(Principal principal) {
        this.setPrincipal(principal, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrincipal(Principal principal, boolean addDeltaRequest) {
        try {
            this.lock();
            super.setPrincipal(principal);
            if (addDeltaRequest && this.deltaRequest != null) {
                this.deltaRequest.setPrincipal(principal);
            }
        }
        finally {
            this.unlock();
        }
    }

    public void setAuthType(String authType) {
        this.setAuthType(authType, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAuthType(String authType, boolean addDeltaRequest) {
        try {
            this.lock();
            super.setAuthType(authType);
            if (addDeltaRequest && this.deltaRequest != null) {
                this.deltaRequest.setAuthType(authType);
            }
        }
        finally {
            this.unlock();
        }
    }

    public boolean isValid() {
        if (this.expiring) {
            return true;
        }
        if (!this.isValid) {
            return false;
        }
        if (ACTIVITY_CHECK && this.accessCount.get() > 0) {
            return true;
        }
        if (this.maxInactiveInterval >= 0) {
            long timeNow = System.currentTimeMillis();
            int timeIdle = LAST_ACCESS_AT_START ? (int)((timeNow - this.lastAccessedTime) / 1000L) : (int)((timeNow - this.thisAccessedTime) / 1000L);
            if (this.isPrimarySession()) {
                if (timeIdle >= this.maxInactiveInterval) {
                    this.expire(true);
                }
            } else if (timeIdle >= 2 * this.maxInactiveInterval) {
                this.expire(true, false);
            }
        }
        return this.isValid;
    }

    public void endAccess() {
        super.endAccess();
        if (this.manager instanceof DeltaManager) {
            ((DeltaManager)this.manager).registerSessionAtReplicationValve(this);
        }
    }

    public void expire(boolean notify) {
        this.expire(notify, true);
    }

    public void expire(boolean notify, boolean notifyCluster) {
        if (this.expiring) {
            return;
        }
        String expiredId = this.getIdInternal();
        if (notifyCluster && expiredId != null && this.manager != null && this.manager instanceof DeltaManager) {
            DeltaManager dmanager = (DeltaManager)this.manager;
            CatalinaCluster cluster = dmanager.getCluster();
            ClusterMessage msg = dmanager.requestCompleted(expiredId, true);
            if (msg != null) {
                cluster.send(msg);
            }
        }
        super.expire(notify);
        if (notifyCluster) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("deltaSession.notifying", new Object[]{((ClusterManager)this.manager).getName(), this.isPrimarySession(), expiredId}));
            }
            if (this.manager instanceof DeltaManager) {
                ((DeltaManager)this.manager).sessionExpired(expiredId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        try {
            this.lock();
            super.recycle();
            this.deltaRequest.clear();
        }
        finally {
            this.unlock();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DeltaSession[");
        sb.append(this.id);
        sb.append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        try {
            this.lock();
            this.readObjectData(in);
        }
        finally {
            this.unlock();
        }
    }

    public void readObjectData(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        this.readObject((ObjectInput)stream);
    }

    public void readObjectData(ObjectInput stream) throws ClassNotFoundException, IOException {
        this.readObject(stream);
    }

    public void writeObjectData(ObjectOutputStream stream) throws IOException {
        this.writeObjectData((ObjectOutput)stream);
    }

    public void writeObjectData(ObjectOutput stream) throws IOException {
        this.writeObject(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetDeltaRequest() {
        try {
            this.lock();
            if (this.deltaRequest == null) {
                this.deltaRequest = new DeltaRequest(this.getIdInternal(), false);
            } else {
                this.deltaRequest.reset();
                this.deltaRequest.setSessionId(this.getIdInternal());
            }
        }
        finally {
            this.unlock();
        }
    }

    public DeltaRequest getDeltaRequest() {
        if (this.deltaRequest == null) {
            this.resetDeltaRequest();
        }
        return this.deltaRequest;
    }

    public void removeAttribute(String name, boolean notify) {
        this.removeAttribute(name, notify, true);
    }

    public void removeAttribute(String name, boolean notify, boolean addDeltaRequest) {
        if (!this.isValid()) {
            throw new IllegalStateException(sm.getString("standardSession.removeAttribute.ise"));
        }
        this.removeAttributeInternal(name, notify, addDeltaRequest);
    }

    public void setAttribute(String name, Object value) {
        this.setAttribute(name, value, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value, boolean notify, boolean addDeltaRequest) {
        if (name == null) {
            throw new IllegalArgumentException(sm.getString("standardSession.setAttribute.namenull"));
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        try {
            this.lock();
            super.setAttribute(name, value, notify);
            if (addDeltaRequest && this.deltaRequest != null && !this.exclude(name)) {
                this.deltaRequest.setAttribute(name, value);
            }
        }
        finally {
            this.unlock();
        }
    }

    protected void readObject(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        this.readObject((ObjectInput)stream);
    }

    private void readObject(ObjectInput stream) throws ClassNotFoundException, IOException {
        this.authType = null;
        this.creationTime = (Long)stream.readObject();
        this.lastAccessedTime = (Long)stream.readObject();
        this.maxInactiveInterval = (Integer)stream.readObject();
        this.isNew = (Boolean)stream.readObject();
        this.isValid = (Boolean)stream.readObject();
        this.thisAccessedTime = (Long)stream.readObject();
        this.version = (Long)stream.readObject();
        boolean hasPrincipal = stream.readBoolean();
        this.principal = null;
        if (hasPrincipal) {
            this.principal = SerializablePrincipal.readPrincipal(stream);
        }
        this.id = (String)stream.readObject();
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("deltaSession.readSession", new Object[]{this.id}));
        }
        if (this.attributes == null) {
            this.attributes = new ConcurrentHashMap();
        }
        int n = (Integer)stream.readObject();
        boolean isValidSave = this.isValid;
        this.isValid = true;
        for (int i = 0; i < n; ++i) {
            String name = (String)stream.readObject();
            Object value = stream.readObject();
            if (value instanceof String && value.equals("___NOT_SERIALIZABLE_EXCEPTION___")) continue;
            this.attributes.put(name, value);
        }
        this.isValid = isValidSave;
        if (this.listeners == null) {
            ArrayList arrayList;
            this.listeners = arrayList = new ArrayList();
        }
        if (this.notes == null) {
            this.notes = new Hashtable();
        }
        this.activate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        try {
            this.lock();
            this.writeObject(out);
        }
        finally {
            this.unlock();
        }
    }

    protected void writeObject(ObjectOutputStream stream) throws IOException {
        this.writeObject((ObjectOutput)stream);
    }

    private void writeObject(ObjectOutput stream) throws IOException {
        stream.writeObject(this.creationTime);
        stream.writeObject(this.lastAccessedTime);
        stream.writeObject(this.maxInactiveInterval);
        stream.writeObject(this.isNew);
        stream.writeObject(this.isValid);
        stream.writeObject(this.thisAccessedTime);
        stream.writeObject(this.version);
        stream.writeBoolean(this.getPrincipal() != null);
        if (this.getPrincipal() != null) {
            SerializablePrincipal.writePrincipal((GenericPrincipal)this.principal, stream);
        }
        stream.writeObject(this.id);
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("deltaSession.writeSession", new Object[]{this.id}));
        }
        String[] keys = this.keys();
        ArrayList<String> saveNames = new ArrayList<String>();
        ArrayList saveValues = new ArrayList();
        for (int i = 0; i < keys.length; ++i) {
            Object value = null;
            value = this.attributes.get(keys[i]);
            if (value == null || this.exclude(keys[i]) || !(value instanceof Serializable)) continue;
            saveNames.add(keys[i]);
            saveValues.add(value);
        }
        int n = saveNames.size();
        stream.writeObject(n);
        for (int i = 0; i < n; ++i) {
            stream.writeObject(saveNames.get(i));
            try {
                stream.writeObject(saveValues.get(i));
                continue;
            }
            catch (NotSerializableException e) {
                log.error((Object)sm.getString("standardSession.notSerializable", new Object[]{saveNames.get(i), this.id}), (Throwable)e);
                stream.writeObject("___NOT_SERIALIZABLE_EXCEPTION___");
                log.error((Object)("  storing attribute '" + (String)saveNames.get(i) + "' with value NOT_SERIALIZED"));
            }
        }
    }

    protected Object getAttributeInternal(String name) {
        return this.attributes.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAttributeInternal(String name, boolean notify, boolean addDeltaRequest) {
        try {
            this.lock();
            Object value = this.attributes.get(name);
            if (value == null) {
                return;
            }
            super.removeAttributeInternal(name, notify);
            if (addDeltaRequest && this.deltaRequest != null && !this.exclude(name)) {
                this.deltaRequest.removeAttribute(name);
            }
        }
        finally {
            this.unlock();
        }
    }

    protected long getLastTimeReplicated() {
        return this.lastTimeReplicated;
    }

    public long getVersion() {
        return this.version;
    }

    protected void setLastTimeReplicated(long lastTimeReplicated) {
        this.lastTimeReplicated = lastTimeReplicated;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    protected void setAccessCount(int count) {
        if (this.accessCount == null && ACTIVITY_CHECK) {
            this.accessCount = new AtomicInteger();
        }
        if (this.accessCount != null) {
            this.accessCount.set(count);
        }
    }
}

