/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.documentation;

import java.util.Arrays;
import java.util.List;
import org.commonmark.Extension;
import org.commonmark.ext.gfm.strikethrough.StrikethroughExtension;
import org.commonmark.ext.gfm.tables.TablesExtension;
import org.commonmark.ext.task.list.items.TaskListItemsExtension;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlNodeRendererFactory;
import org.commonmark.renderer.html.HtmlRenderer;

public class CommonMarkParser {
    public static String toHtml(String text) {
        return CommonMarkParser.toHtml(text, null);
    }

    public static String toHtml(String text, HtmlNodeRendererFactory rendererFactory) {
        List<Extension> extensions = Arrays.asList(TablesExtension.create(), StrikethroughExtension.create(), TaskListItemsExtension.create());
        Parser parser = Parser.builder().extensions(extensions).build();
        HtmlRenderer.Builder renderer = HtmlRenderer.builder().extensions(extensions);
        if (rendererFactory != null) {
            renderer.nodeRendererFactory(rendererFactory);
        }
        return renderer.build().render(parser.parse(text));
    }
}

