/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased.analysis;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.eclipse.escet.cif.eventbased.analysis.AddedEdgeInfo;
import org.eclipse.escet.cif.eventbased.analysis.AutomatonNamesInfo;
import org.eclipse.escet.cif.eventbased.analysis.EventInfo;
import org.eclipse.escet.cif.eventbased.analysis.RemovedEdgeInfo;
import org.eclipse.escet.cif.eventbased.analysis.RemovedLocationInfo;
import org.eclipse.escet.cif.eventbased.analysis.RemovedLocationReason;
import org.eclipse.escet.cif.eventbased.analysis.SourceReadInfo;
import org.eclipse.escet.cif.eventbased.analysis.StateInfo;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InputOutputException;

public class SynthesisDumpIO {
    public static final byte[] HEADER_BLOCK;
    public static final byte SOURCE_INFO_ID = 1;
    public static final byte EVENTS_ID = 2;
    public static final byte NEW_UNMARKED_LOC_ID = 16;
    public static final byte NEW_MARKED_LOC_ID = 17;
    public static final byte NEW_EDGE = 18;
    public static final byte BLOCKING_LOC_ID = 32;
    public static final byte NOT_COREACH_LOC_ID = 33;
    public static final byte REMOVED_DEST_ID = 34;
    public static final byte REMOVED_EDGE_ID = 35;
    public static final byte NOT_REACH_LOC_ID = 36;
    public static final byte EOD_ID = 112;
    public static final byte EVT_CONTR = 1;
    public static final byte EVT_UNCONTR = 0;

    static {
        byte[] byArray = new byte[5];
        byArray[0] = 69;
        byArray[1] = 83;
        byArray[2] = 68;
        byArray[3] = 3;
        HEADER_BLOCK = byArray;
    }

    private SynthesisDumpIO() {
    }

    public static DataOutputStream openOutput(String filename) {
        OutputStream out;
        try {
            out = new FileOutputStream(filename);
        }
        catch (FileNotFoundException ex) {
            String msg = Strings.fmt((String)"Cannot open the synthesis dump file \"%s\" for writing.", (Object[])new Object[]{filename});
            throw new InputOutputException(msg, (Throwable)ex);
        }
        out = new BufferedOutputStream(out);
        DataOutputStream outHandle = new DataOutputStream(out);
        SynthesisDumpIO.writeHeader(outHandle);
        return outHandle;
    }

    public static DataInputStream openInput(String filename) {
        InputStream inp;
        try {
            inp = new FileInputStream(filename);
        }
        catch (FileNotFoundException ex) {
            String msg = Strings.fmt((String)"Cannot open the synthesis dump file \"%s\" for reading.", (Object[])new Object[]{filename});
            throw new InputOutputException(msg, (Throwable)ex);
        }
        inp = new BufferedInputStream(inp);
        DataInputStream inHandle = new DataInputStream(inp);
        SynthesisDumpIO.readHeader(inHandle);
        return inHandle;
    }

    public static void close(DataOutputStream outHandle) {
        if (outHandle == null) {
            return;
        }
        try {
            outHandle.close();
        }
        catch (IOException ex) {
            String msg = "Failed to close the (written) synthesis dump file.";
            throw new InputOutputException(msg, (Throwable)ex);
        }
    }

    public static void close(DataInputStream inHandle) {
        if (inHandle == null) {
            return;
        }
        try {
            inHandle.close();
        }
        catch (IOException ex) {
            String msg = "Failed to close the (read) synthesis dump file.";
            throw new InputOutputException(msg, (Throwable)ex);
        }
    }

    private static void writeHeader(DataOutputStream outHandle) {
        try {
            outHandle.write(HEADER_BLOCK);
        }
        catch (IOException ex) {
            String msg = "Failed to write the header to the synthesis dump file.";
            throw new InputOutputException(msg, (Throwable)ex);
        }
    }

    private static void readHeader(DataInputStream inHandle) {
        byte[] inBlock = new byte[HEADER_BLOCK.length];
        try {
            int index = 0;
            while (index < inBlock.length) {
                inBlock[index] = inHandle.readByte();
                ++index;
            }
        }
        catch (IOException ex) {
            String msg = "Failed to read the header of the synthesis dump file.";
            throw new InputOutputException(msg, (Throwable)ex);
        }
        if (!Arrays.equals(HEADER_BLOCK, inBlock)) {
            String msg = "File header does not match with the synthesis dump file header.";
            throw new InputOutputException(msg);
        }
    }

    public static byte readBlockByte(DataInputStream inHandle) {
        byte b;
        try {
            b = inHandle.readByte();
        }
        catch (IOException ex) {
            String msg = "Failed to read the block byte from the synthesis dump file.";
            throw new InputOutputException(msg, (Throwable)ex);
        }
        return b;
    }

    public static void writeSourceAutomataInformation(List<AutomatonNamesInfo> sourceInfo, int numPlants, DataOutputStream outHandle) {
        Assert.check((numPlants >= 0 && numPlants <= sourceInfo.size() ? 1 : 0) != 0);
        try {
            outHandle.write(1);
            outHandle.writeInt(sourceInfo.size());
            outHandle.writeInt(numPlants);
            for (AutomatonNamesInfo autNames : sourceInfo) {
                outHandle.writeUTF(autNames.autName);
                outHandle.writeInt(autNames.locNames.size());
                for (String locName : autNames.locNames) {
                    outHandle.writeUTF(locName);
                }
            }
        }
        catch (IOException ex) {
            String msg = "Failed to write the source information to the synthesis dump file.";
            throw new InputOutputException(msg, (Throwable)ex);
        }
    }

    public static SourceReadInfo readDataSourceAutomataInformation(DataInputStream inHandle) {
        SourceReadInfo sri = new SourceReadInfo();
        try {
            int numAuts = inHandle.readInt();
            sri.numPlants = inHandle.readInt();
            int autNumber = 0;
            while (autNumber < numAuts) {
                String autName = inHandle.readUTF();
                int locCount = inHandle.readInt();
                List locs = Lists.listc((int)locCount);
                int locNumber = 0;
                while (locNumber < locCount) {
                    locs.add(inHandle.readUTF());
                    ++locNumber;
                }
                sri.sourceInfo.add(new AutomatonNamesInfo(autName, locs));
                ++autNumber;
            }
        }
        catch (IOException ex) {
            String msg = "Failed to read the source information from the synthesis dump file.";
            throw new InputOutputException(msg, (Throwable)ex);
        }
        return sri;
    }

    public static void writeEvents(List<EventInfo> events, DataOutputStream outHandle) {
        try {
            outHandle.write(2);
            outHandle.writeInt(events.size());
            for (EventInfo evt : events) {
                outHandle.writeByte(evt.contr ? 1 : 0);
                outHandle.writeUTF(evt.name);
            }
        }
        catch (IOException ex) {
            String msg = "Failed to write event information to the synthesis dump file.";
            throw new InputOutputException(msg, (Throwable)ex);
        }
    }

    public static List<EventInfo> readDataEvents(DataInputStream inHandle) {
        List events;
        try {
            int numEvents = inHandle.readInt();
            events = Lists.listc((int)numEvents);
            int index = 0;
            while (index < numEvents) {
                byte contr = inHandle.readByte();
                String name = inHandle.readUTF();
                if (contr == 1) {
                    events.add(new EventInfo(name, true));
                } else if (contr == 0) {
                    events.add(new EventInfo(name, false));
                } else {
                    String msg = "Failed to read the event controllability from the synthesis dump file.";
                    throw new InputOutputException(msg);
                }
                ++index;
            }
        }
        catch (IOException ex) {
            String msg = "Failed to read the event information from the synthesis dump file.";
            throw new InputOutputException(msg, (Throwable)ex);
        }
        return events;
    }

    public static void writeNewLocation(int[] srcLocs, int targetLoc, boolean marked, DataOutputStream outHandle) {
        try {
            outHandle.write(marked ? 17 : 16);
            outHandle.writeInt(targetLoc);
            int[] nArray = srcLocs;
            int n = srcLocs.length;
            int n2 = 0;
            while (n2 < n) {
                int src = nArray[n2];
                outHandle.writeInt(src);
                ++n2;
            }
        }
        catch (IOException ex) {
            String msg = "Failed to write a new state to the synthesis dump file.";
            throw new InputOutputException(msg, (Throwable)ex);
        }
    }

    public static StateInfo readNewLocation(byte blockByte, int numAuts, DataInputStream inHandle) {
        int targetLoc;
        Assert.check((blockByte == 17 || blockByte == 16 ? 1 : 0) != 0);
        int[] srcLocs = new int[numAuts];
        try {
            targetLoc = inHandle.readInt();
            int idx = 0;
            while (idx < numAuts) {
                srcLocs[idx] = inHandle.readInt();
                ++idx;
            }
        }
        catch (IOException ex) {
            String msg = "Failed to read a new state from the synthesis dump file.";
            throw new InputOutputException(msg, (Throwable)ex);
        }
        return new StateInfo(srcLocs, targetLoc, blockByte == 17);
    }

    public static void writeNewEdge(AddedEdgeInfo edgeInfo, DataOutputStream outHandle) {
        try {
            outHandle.write(18);
            outHandle.writeInt(edgeInfo.from);
            outHandle.writeInt(edgeInfo.to);
            outHandle.writeInt(edgeInfo.event);
        }
        catch (IOException ex) {
            String msg = "Failed to write a new edge to the synthesis dump file.";
            throw new InputOutputException(msg, (Throwable)ex);
        }
    }

    public static AddedEdgeInfo readNewEdge(DataInputStream inHandle) {
        int evt;
        int dst;
        int src;
        try {
            src = inHandle.readInt();
            dst = inHandle.readInt();
            evt = inHandle.readInt();
        }
        catch (IOException ex) {
            String msg = "Failed to read a new edge from the synthesis dump file.";
            throw new InputOutputException(msg, (Throwable)ex);
        }
        return new AddedEdgeInfo(src, dst, evt);
    }

    public static void writeRemovedLocation(RemovedLocationInfo removedLoc, DataOutputStream outHandle) {
        try {
            switch (removedLoc.reason) {
                case IS_BLOCKING: {
                    outHandle.write(32);
                    break;
                }
                case IS_NOT_COREACHABLE: {
                    outHandle.write(33);
                    break;
                }
                case IS_NOT_REACHABLE: {
                    outHandle.write(36);
                    break;
                }
                default: {
                    Assert.fail((Object)"Unknown removed location reason.");
                }
            }
            outHandle.writeInt(removedLoc.loc);
        }
        catch (IOException ex) {
            String msg = "Failed to write removed location information to the synthesis dump file.";
            throw new InputOutputException(msg, (Throwable)ex);
        }
    }

    public static RemovedLocationInfo readDataRemovedLocation(byte blockByte, DataInputStream inHandle) {
        int loc;
        RemovedLocationReason reason = null;
        switch (blockByte) {
            case 32: {
                reason = RemovedLocationReason.IS_BLOCKING;
                break;
            }
            case 33: {
                reason = RemovedLocationReason.IS_NOT_COREACHABLE;
                break;
            }
            case 36: {
                reason = RemovedLocationReason.IS_NOT_REACHABLE;
                break;
            }
            default: {
                Assert.fail((Object)"Unknown removed location reason.");
            }
        }
        try {
            loc = inHandle.readInt();
        }
        catch (IOException ex) {
            String msg = "Failed to read removed location information from the synthesis dump file.";
            throw new InputOutputException(msg, (Throwable)ex);
        }
        return new RemovedLocationInfo(loc, reason);
    }

    public static void writeRemovedEdge(RemovedEdgeInfo removedEdge, DataOutputStream outHandle) {
        try {
            outHandle.write(removedEdge.toIsAutomaton ? 35 : 34);
            outHandle.writeInt(removedEdge.from);
            outHandle.writeInt(removedEdge.to);
            outHandle.writeInt(removedEdge.event);
        }
        catch (IOException ex) {
            String msg = "Failed to write removed edge information to the synthesis dump file.";
            throw new InputOutputException(msg, (Throwable)ex);
        }
    }

    public static RemovedEdgeInfo readDataRemovedEdge(byte blockByte, DataInputStream inHandle) {
        int evt;
        int to;
        int from;
        Assert.check((blockByte == 34 || blockByte == 35 ? 1 : 0) != 0);
        try {
            from = inHandle.readInt();
            to = inHandle.readInt();
            evt = inHandle.readInt();
        }
        catch (IOException ex) {
            String msg = "Failed to read removed edge information from the synthesis dump file.";
            throw new InputOutputException(msg, (Throwable)ex);
        }
        return new RemovedEdgeInfo(from, to, evt, blockByte == 35);
    }

    public static void writeEndOfData(DataOutputStream outHandle) {
        try {
            outHandle.write(112);
        }
        catch (IOException ex) {
            String msg = "Failed to write an end-of-data to the synthesis dump file.";
            throw new InputOutputException(msg, (Throwable)ex);
        }
    }
}

