/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.runtime.data.random;

import org.eclipse.escet.chi.runtime.ChiCoordinator;
import org.eclipse.escet.chi.runtime.data.random.RandomGenerator;

public class GaussianGenerator {
    private RandomGenerator randGen1;
    private RandomGenerator randGen2;
    private double cachedValue;
    private double cachedY;
    private boolean cacheFilled;

    public GaussianGenerator(ChiCoordinator chiCoordinator) {
        this.randGen1 = chiCoordinator.getFreshGenerator();
        this.randGen2 = chiCoordinator.getFreshGenerator();
        this.cacheFilled = false;
    }

    public double drawGaussian(double mean, double sqrtVariance) {
        double s2;
        double s1;
        double w;
        if (this.cacheFilled) {
            this.cacheFilled = false;
            return mean + sqrtVariance * this.cachedValue * this.cachedY;
        }
        while ((w = (s1 = 2.0 * this.randGen1.draw() - 1.0) * s1 + (s2 = 2.0 * this.randGen2.draw() - 1.0) * s2) >= 1.0 || w == 0.0) {
        }
        this.cachedY = Math.sqrt(-2.0 * Math.log(w) / w);
        this.cachedValue = s2;
        this.cacheFilled = true;
        return mean + sqrtVariance * s1 * this.cachedY;
    }
}

