/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.coordinator;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.equinox.coordinator.CoordinationImpl;
import org.eclipse.equinox.coordinator.CoordinationTimerTask;
import org.eclipse.equinox.coordinator.Messages;
import org.osgi.framework.Bundle;
import org.osgi.service.coordinator.Coordination;
import org.osgi.service.coordinator.CoordinationException;
import org.osgi.service.coordinator.CoordinationPermission;
import org.osgi.service.coordinator.Coordinator;
import org.osgi.service.coordinator.Participant;
import org.osgi.service.log.LogService;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoordinatorImpl
implements Coordinator {
    private static long lastId;
    private static final Map<Long, CoordinationImpl> idToCoordination;
    private static final Map<Participant, CoordinationImpl> participantToCoordination;
    private static ThreadLocal<WeakCoordinationStack> coordinationStack;
    private final Bundle bundle;
    private final List<CoordinationImpl> coordinations;
    private final LogService logService;
    private final Timer timer;
    private boolean shutdown;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        idToCoordination = new HashMap<Long, CoordinationImpl>();
        participantToCoordination = new IdentityHashMap<Participant, CoordinationImpl>();
        coordinationStack = new ThreadLocal<WeakCoordinationStack>(){

            @Override
            protected WeakCoordinationStack initialValue() {
                return new WeakCoordinationStack();
            }
        };
    }

    private static synchronized long getNextId() {
        if (Long.MAX_VALUE == lastId) {
            throw new IllegalStateException(Messages.CoordinatorImpl_0);
        }
        return ++lastId;
    }

    public CoordinatorImpl(Bundle bundle, LogService logService, Timer timer) {
        this.bundle = bundle;
        this.logService = logService;
        this.timer = timer;
        this.coordinations = new ArrayList<CoordinationImpl>();
    }

    @Override
    public boolean addParticipant(Participant participant) throws CoordinationException {
        Coordination coordination = this.peek();
        if (coordination == null) {
            return false;
        }
        coordination.addParticipant(participant);
        return true;
    }

    @Override
    public Coordination begin(String name, long timeout) {
        CoordinationImpl coordination = (CoordinationImpl)this.create(name, timeout);
        coordination.push();
        return coordination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Coordination create(String name, long timeout) {
        this.checkPermission("initiate", name);
        CoordinationImpl coordination = new CoordinationImpl(CoordinatorImpl.getNextId(), name, timeout, this);
        CoordinatorImpl coordinatorImpl = this;
        synchronized (coordinatorImpl) {
            if (this.shutdown) {
                throw new IllegalStateException(Messages.CoordinatorImpl_2);
            }
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.equinox.coordinator.CoordinatorImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> clazz2 = clazz;
            synchronized (clazz) {
                this.coordinations.add(coordination);
                idToCoordination.put(new Long(coordination.getId()), coordination);
                // ** MonitorExit[var6_5] (shouldn't be in output)
            }
        }
        {
            if (timeout > 0L) {
                CoordinationTimerTask timerTask = new CoordinationTimerTask(coordination);
                coordination.setTimerTask(timerTask);
                this.schedule(timerTask, coordination.getDeadline());
            }
            return coordination;
        }
    }

    @Override
    public boolean fail(Throwable reason) {
        Coordination coordination = this.peek();
        if (coordination == null) {
            return false;
        }
        return coordination.fail(reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Coordination getCoordination(long id) {
        CoordinationImpl result = null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.coordinator.CoordinatorImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            result = idToCoordination.get(new Long(id));
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (result != null && !result.isTerminated()) {
                try {
                    this.checkPermission("admin", result.getName());
                }
                catch (SecurityException e) {
                    this.logService.log(4, Messages.CoordinatorImpl_1, (Throwable)e);
                    result = null;
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Coordination> getCoordinations() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.coordinator.CoordinatorImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            ArrayList<Coordination> result = new ArrayList<Coordination>(idToCoordination.size());
            for (CoordinationImpl coordination : idToCoordination.values()) {
                if (coordination.isTerminated()) continue;
                try {
                    this.checkPermission("admin", coordination.getName());
                    result.add(coordination);
                }
                catch (SecurityException e) {
                    this.logService.log(4, Messages.CoordinatorImpl_1, (Throwable)e);
                }
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            result.trimToSize();
            return result;
        }
    }

    @Override
    public Coordination peek() {
        return coordinationStack.get().peek();
    }

    @Override
    public Coordination pop() {
        CoordinationImpl c = coordinationStack.get().peek();
        if (c == null) {
            return null;
        }
        this.checkPermission("initiate", c.getName());
        return coordinationStack.get().pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CoordinationImpl addParticipant(Participant participant, CoordinationImpl coordination) {
        CoordinationImpl result = null;
        Map<Participant, CoordinationImpl> map = participantToCoordination;
        synchronized (map) {
            result = participantToCoordination.get(participant);
            if (result == null) {
                participantToCoordination.put(participant, coordination);
            }
        }
        return result;
    }

    void checkPermission(String permissionType, String coordinationName) {
        this.checkPermission(new CoordinationPermission(coordinationName, this.bundle, permissionType));
    }

    void checkPermission(Permission permission) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return;
        }
        securityManager.checkPermission(permission);
    }

    Bundle getBundle() {
        return this.bundle;
    }

    LogService getLogService() {
        return this.logService;
    }

    void purge() {
        try {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.util.Timer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            clazz.getMethod("purge", null).invoke((Object)this.timer, null);
        }
        catch (Exception e) {
            this.logService.log(4, Messages.CoordinatorImpl_4, (Throwable)e);
        }
    }

    void push(CoordinationImpl coordination) throws CoordinationException {
        coordinationStack.get().push(coordination);
    }

    void schedule(TimerTask task, Date deadline) {
        this.timer.schedule(task, deadline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        ArrayList<CoordinationImpl> coords;
        CoordinatorImpl coordinatorImpl = this;
        synchronized (coordinatorImpl) {
            this.shutdown = true;
            coords = new ArrayList<CoordinationImpl>(this.coordinations);
        }
        for (Coordination coordination : coords) {
            coordination.fail(Coordination.RELEASED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminate(Coordination coordination, List<Participant> participants) {
        CoordinatorImpl coordinatorImpl = this;
        synchronized (coordinatorImpl) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.equinox.coordinator.CoordinatorImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> clazz2 = clazz;
            synchronized (clazz) {
                this.coordinations.remove(coordination);
                idToCoordination.remove(new Long(coordination.getId()));
                participantToCoordination.keySet().removeAll(participants);
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
        }
    }

    private static class WeakCoordinationStack {
        private final LinkedList<Reference<CoordinationImpl>> coordinations = new LinkedList();
        private final ReferenceQueue<CoordinationImpl> queue = new ReferenceQueue();

        public boolean contains(CoordinationImpl c) {
            this.purge();
            Iterator iterator = this.coordinations.iterator();
            while (iterator.hasNext()) {
                Reference r = (Reference)iterator.next();
                if (!c.equals(r.get())) continue;
                return true;
            }
            return false;
        }

        public CoordinationImpl peek() {
            this.purge();
            if (this.coordinations.isEmpty()) {
                return null;
            }
            return this.coordinations.getFirst().get();
        }

        public CoordinationImpl pop() {
            this.purge();
            if (this.coordinations.isEmpty()) {
                return null;
            }
            CoordinationImpl c = this.coordinations.removeFirst().get();
            if (c != null) {
                c.setThreadAndEnclosingCoordination(null, null);
            }
            return c;
        }

        public void push(CoordinationImpl c) {
            this.purge();
            if (this.contains(c)) {
                throw new CoordinationException(Messages.CoordinatorImpl_3, c, 5);
            }
            WeakReference<CoordinationImpl> r = new WeakReference<CoordinationImpl>(c, this.queue);
            c.setThreadAndEnclosingCoordination(Thread.currentThread(), this.coordinations.isEmpty() ? null : this.coordinations.getFirst());
            this.coordinations.addFirst(r);
        }

        private void purge() {
            Reference<CoordinationImpl> r;
            while ((r = this.queue.poll()) != null) {
                CoordinationImpl c;
                int index = this.coordinations.indexOf(r);
                this.coordinations.remove(r);
                if (index <= 0 || (c = (r = this.coordinations.get(index - 1)).get()) == null) continue;
                c.setThreadAndEnclosingCoordination(Thread.currentThread(), this.coordinations.get(index));
            }
        }
    }
}

