/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.jmx.internal;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.jmx.common.ContributionNotificationEvent;
import org.eclipse.equinox.jmx.common.util.MBeanInfoWrapper;
import org.eclipse.equinox.jmx.server.Contribution;
import org.eclipse.osgi.jmx.internal.Activator;
import org.eclipse.osgi.jmx.internal.ServiceContributionMessages;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class ServiceContribution
extends Contribution
implements ServiceListener {
    static final String IMG_REG_SERVICE_PATH = "icons/services/bundle_reg_service.png";
    static final String IMG_USE_REG_SERVICE_PATH = "icons/services/bundle_use_reg_service.png";
    static final String IMG_USE_SERVICE_PATH = "icons/services/bundle_use_service.png";
    private static final String IMG_SERVICE_PATH = "icons/services/service.gif";
    private final MBeanInfo mbeanInfo;
    private final ServiceReference serviceDelegate;
    private final Bundle bundle;
    private Class serviceDelegateImplClass;

    public ServiceContribution(ServiceReference serviceDelegate) {
        this(serviceDelegate, null);
    }

    public ServiceContribution(ServiceReference serviceDelegate, Bundle bundle) {
        super((Object)serviceDelegate);
        if (serviceDelegate == null) {
            throw new IllegalArgumentException();
        }
        this.serviceDelegate = serviceDelegate;
        this.bundle = bundle;
        try {
            this.serviceDelegateImplClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(this.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.serviceDelegateImplClass = serviceDelegate.getClass();
        }
        this.mbeanInfo = MBeanInfoWrapper.createMBeanInfo((Class)this.serviceDelegateImplClass, (String)ServiceContributionMessages.service_contribution_name, (MBeanAttributeInfo[])new MBeanAttributeInfo[0], (MBeanNotificationInfo[])new MBeanNotificationInfo[0]);
        Activator.getBundleContext().addServiceListener((ServiceListener)this);
    }

    protected ObjectName getObjectName() {
        try {
            return new ObjectName("jmxserver:type=Service,name=" + this.getName());
        }
        catch (Exception exception) {
            return super.getObjectName();
        }
    }

    protected String getName() {
        return ServiceContribution.getServiceReferenceName(this.serviceDelegate);
    }

    protected Set getProperties() {
        HashSet<String> ret = new HashSet<String>();
        String[] propKeys = this.serviceDelegate.getPropertyKeys();
        int i = 0;
        while (i < propKeys.length) {
            ret.add(String.valueOf(propKeys[i]) + ":" + this.serviceDelegate.getProperty(propKeys[i]).toString());
            ++i;
        }
        return ret;
    }

    protected URL getImageLocation() {
        String imgPath = IMG_SERVICE_PATH;
        if (this.bundle != null) {
            boolean isUsingService = false;
            boolean hasRegisteredService = false;
            ServiceReference[] servicesInUse = this.bundle.getServicesInUse();
            int i = 0;
            while (i < servicesInUse.length) {
                if (this.serviceDelegate == servicesInUse[i]) {
                    isUsingService = true;
                }
                ++i;
            }
            ServiceReference[] registeredServices = this.bundle.getRegisteredServices();
            int i2 = 0;
            while (i2 < registeredServices.length) {
                if (this.serviceDelegate == registeredServices[i2]) {
                    hasRegisteredService = true;
                }
                ++i2;
            }
            if (isUsingService || hasRegisteredService) {
                imgPath = isUsingService && hasRegisteredService ? IMG_USE_REG_SERVICE_PATH : (isUsingService ? IMG_USE_SERVICE_PATH : IMG_REG_SERVICE_PATH);
            }
        }
        return FileLocator.find((Bundle)Activator.getBundle(), (IPath)new Path(imgPath), null);
    }

    protected Object[] getChildren() {
        Object[] ret = null;
        if (this.serviceDelegate.getUsingBundles() != null) {
            ret = new Object[this.serviceDelegate.getUsingBundles().length + 1];
            System.arraycopy(this.serviceDelegate.getUsingBundles(), 0, ret, 0, this.serviceDelegate.getUsingBundles().length);
        } else {
            ret = new Object[1];
        }
        System.arraycopy(new Object[]{this.serviceDelegate.getBundle()}, 0, ret, this.serviceDelegate.getUsingBundles() == null ? 0 : this.serviceDelegate.getUsingBundles().length, 1);
        return ret;
    }

    protected Object invokeOperation(String operationName, Object[] args, String[] argTypes) {
        Object ret = null;
        BundleContext context = Activator.getBundleContext();
        if (context != null) {
            ServiceTracker st = new ServiceTracker(context, this.serviceDelegate, null);
            st.open();
            Object serviceImpl = st.getService(this.serviceDelegate);
            if (serviceImpl != null) {
                try {
                    Method[] methods = serviceImpl.getClass().getMethods();
                    int i = 0;
                    while (i < methods.length) {
                        if (methods[i].getName().equals(operationName)) {
                            ret = methods[i].invoke(serviceImpl, args);
                            break;
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    ret = e.getMessage();
                }
                st.close();
                st = null;
            }
        } else {
            ret = new String(ServiceContributionMessages.controlling_bundle_stopped);
        }
        return ret;
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        return null;
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
    }

    public AttributeList getAttributes(String[] attributes) {
        return null;
    }

    public AttributeList setAttributes(AttributeList attributes) {
        return null;
    }

    public MBeanInfo getMBeanInfo(Object delegate) {
        return this.mbeanInfo;
    }

    public void serviceChanged(ServiceEvent event) {
        if (this.serviceDelegate != event.getServiceReference()) {
            return;
        }
        ContributionNotificationEvent cEvent = null;
        switch (event.getType()) {
            case 2: {
                cEvent = new ContributionNotificationEvent("contribution.updated");
                break;
            }
            case 4: {
                cEvent = new ContributionNotificationEvent("contribution.removed");
                break;
            }
            default: {
                return;
            }
        }
        super.contributionStateChanged(cEvent);
    }

    public static String getServiceReferenceName(ServiceReference serviceReference) {
        String[] props;
        Object prop = serviceReference.getProperty("objectClass");
        if (prop instanceof String[] && (props = (String[])prop).length == 1) {
            return props[0];
        }
        return serviceReference.toString();
    }
}

