/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import org.mortbay.http.HttpHandler;
import org.mortbay.jetty.servlet.Holder;
import org.mortbay.jetty.servlet.WebApplicationHandler;

public class FilterHolder
extends Holder {
    private transient Filter _filter;
    private transient Config _config;

    public FilterHolder() {
    }

    public FilterHolder(HttpHandler httpHandler, String name, String className) {
        super(httpHandler, name, className);
    }

    public void start() throws Exception {
        super.start();
        if (!Filter.class.isAssignableFrom(this._class)) {
            super.stop();
            throw new IllegalStateException(this._class + " is not a javax.servlet.Filter");
        }
        this._filter = (Filter)this.newInstance();
        this._config = new Config();
        this._filter.init((FilterConfig)this._config);
    }

    public void stop() {
        if (this._filter != null) {
            this._filter.destroy();
        }
        this._filter = null;
        this._config = null;
        super.stop();
    }

    public Filter getFilter() {
        return this._filter;
    }

    public String toString() {
        return this.getName();
    }

    class Config
    implements FilterConfig {
        Config() {
        }

        public String getFilterName() {
            return FilterHolder.this.getName();
        }

        public ServletContext getServletContext() {
            return ((WebApplicationHandler)FilterHolder.this._httpHandler).getServletContext();
        }

        public String getInitParameter(String param) {
            return FilterHolder.this.getInitParameter(param);
        }

        public Enumeration getInitParameterNames() {
            return FilterHolder.this.getInitParameterNames();
        }
    }
}

