/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.internal.caching;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.eclipse.equinox.weaving.internal.caching.CacheItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheWriter {
    private final Thread writerThread;

    public CacheWriter(final BlockingQueue<CacheItem> cacheQueue) {
        this.writerThread = new Thread(new Runnable(){

            public void run() {
                try {
                    while (true) {
                        CacheItem item = (CacheItem)cacheQueue.take();
                        try {
                            CacheWriter.this.store(item);
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        });
        this.writerThread.setPriority(1);
    }

    public void start() {
        this.writerThread.start();
    }

    public void stop() {
        this.writerThread.interrupt();
    }

    protected void store(CacheItem item) throws IOException {
        Map<String, byte[]> generatedClasses = item.getGeneratedClasses();
        if (generatedClasses != null) {
            for (String className : generatedClasses.keySet()) {
                byte[] classBytes = generatedClasses.get(className);
                this.storeSingleClass(className, classBytes, item.getDirectory());
            }
        }
        this.storeSingleClass(item.getName(), item.getCachedBytes(), item.getDirectory());
    }

    private void storeSingleClass(String className, byte[] classBytes, String cacheDirectory) throws FileNotFoundException, IOException {
        DataOutputStream outCache = null;
        FileOutputStream fosCache = null;
        try {
            File directory = new File(cacheDirectory);
            if (!directory.exists()) {
                directory.mkdirs();
            }
            fosCache = new FileOutputStream(new File(directory, className));
            outCache = new DataOutputStream(new BufferedOutputStream(fosCache));
            outCache.write(classBytes);
        }
        catch (Throwable throwable) {
            if (outCache != null) {
                try {
                    outCache.flush();
                    fosCache.getFD().sync();
                }
                catch (IOException iOException) {}
                try {
                    outCache.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (outCache != null) {
            try {
                outCache.flush();
                fosCache.getFD().sync();
            }
            catch (IOException iOException) {}
            try {
                outCache.close();
            }
            catch (IOException iOException) {}
        }
    }
}

