/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.impl;

import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.emfstore.internal.client.model.AdminBroker;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.ServerInfo;
import org.eclipse.emf.emfstore.internal.server.exceptions.ConnectionException;
import org.eclipse.emf.emfstore.internal.server.model.ProjectId;
import org.eclipse.emf.emfstore.internal.server.model.ProjectInfo;
import org.eclipse.emf.emfstore.internal.server.model.SessionId;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACGroup;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnit;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnitId;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.roles.Role;
import org.eclipse.emf.emfstore.server.exceptions.ESException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminBrokerImpl
implements AdminBroker {
    private final SessionId sessionId;

    public AdminBrokerImpl(ServerInfo serverInfo, SessionId sessionId) throws ConnectionException {
        this.sessionId = sessionId;
        ESWorkspaceProviderImpl.getInstance().getAdminConnectionManager().initConnection(serverInfo, sessionId);
    }

    @Override
    public void addParticipant(ProjectId projectId, ACOrgUnitId participant, EClass role) throws ESException {
        ESWorkspaceProviderImpl.getInstance().getAdminConnectionManager().addParticipant(this.getSessionId(), projectId, participant, role);
    }

    @Override
    public void changeRole(ProjectId projectId, ACOrgUnitId orgUnit, EClass role) throws ESException {
        ESWorkspaceProviderImpl.getInstance().getAdminConnectionManager().changeRole(this.getSessionId(), projectId, orgUnit, role);
    }

    @Override
    public List<ACGroup> getGroups() throws ESException {
        return ESWorkspaceProviderImpl.getInstance().getAdminConnectionManager().getGroups(this.getSessionId());
    }

    @Override
    public List<ACGroup> getGroups(ACOrgUnitId user) throws ESException {
        return ESWorkspaceProviderImpl.getInstance().getAdminConnectionManager().getGroups(this.getSessionId(), user);
    }

    @Override
    public List<ACOrgUnit> getOrgUnits() throws ESException {
        return ESWorkspaceProviderImpl.getInstance().getAdminConnectionManager().getOrgUnits(this.getSessionId());
    }

    @Override
    public List<ACOrgUnit> getParticipants(ProjectId projectId) throws ESException {
        return ESWorkspaceProviderImpl.getInstance().getAdminConnectionManager().getParticipants(this.getSessionId(), projectId);
    }

    @Override
    public List<ACOrgUnit> getMembers(ACOrgUnitId groupId) throws ESException {
        return ESWorkspaceProviderImpl.getInstance().getAdminConnectionManager().getMembers(this.getSessionId(), groupId);
    }

    @Override
    public List<ProjectInfo> getProjectInfos() throws ESException {
        return ESWorkspaceProviderImpl.getInstance().getAdminConnectionManager().getProjectInfos(this.getSessionId());
    }

    @Override
    public Role getRole(ProjectId projectId, ACOrgUnitId orgUnit) throws ESException {
        return ESWorkspaceProviderImpl.getInstance().getAdminConnectionManager().getRole(this.getSessionId(), projectId, orgUnit);
    }

    @Override
    public List<ACUser> getUsers() throws ESException {
        return ESWorkspaceProviderImpl.getInstance().getAdminConnectionManager().getUsers(this.getSessionId());
    }

    @Override
    public void removeGroup(ACOrgUnitId user, ACOrgUnitId group) throws ESException {
        ESWorkspaceProviderImpl.getInstance().getAdminConnectionManager().removeGroup(this.getSessionId(), user, group);
    }

    @Override
    public void removeParticipant(ProjectId projectId, ACOrgUnitId participant) throws ESException {
        ESWorkspaceProviderImpl.getInstance().getAdminConnectionManager().removeParticipant(this.getSessionId(), projectId, participant);
    }

    private SessionId getSessionId() {
        return this.sessionId;
    }

    @Override
    public ACOrgUnitId createGroup(String name) throws ESException {
        return ESWorkspaceProviderImpl.getInstance().getAdminConnectionManager().createGroup(this.getSessionId(), name);
    }

    @Override
    public ACOrgUnitId createUser(String name) throws ESException {
        return ESWorkspaceProviderImpl.getInstance().getAdminConnectionManager().createUser(this.getSessionId(), name);
    }

    @Override
    public void deleteGroup(ACOrgUnitId group) throws ESException {
        ESWorkspaceProviderImpl.getInstance().getAdminConnectionManager().deleteGroup(this.getSessionId(), group);
    }

    @Override
    public void deleteUser(ACOrgUnitId user) throws ESException {
        ESWorkspaceProviderImpl.getInstance().getAdminConnectionManager().deleteUser(this.getSessionId(), user);
    }

    @Override
    public void addMember(ACOrgUnitId group, ACOrgUnitId member) throws ESException {
        ESWorkspaceProviderImpl.getInstance().getAdminConnectionManager().addMember(this.getSessionId(), group, member);
    }

    @Override
    public void removeMember(ACOrgUnitId group, ACOrgUnitId member) throws ESException {
        ESWorkspaceProviderImpl.getInstance().getAdminConnectionManager().removeMember(this.getSessionId(), group, member);
    }

    @Override
    public void changeOrgUnit(ACOrgUnitId orgUnitId, String name, String description) throws ESException {
        ESWorkspaceProviderImpl.getInstance().getAdminConnectionManager().changeOrgUnit(this.getSessionId(), orgUnitId, name, description);
    }

    @Override
    public void changeUser(ACOrgUnitId userId, String name, String password) throws ESException {
        ESWorkspaceProviderImpl.getInstance().getAdminConnectionManager().changeUser(this.getSessionId(), userId, name, password);
    }

    @Override
    public ACOrgUnit getOrgUnit(ACOrgUnitId orgUnitId) throws ESException {
        return ESWorkspaceProviderImpl.getInstance().getAdminConnectionManager().getOrgUnit(this.sessionId, orgUnitId);
    }

    @Override
    public void assignRole(ACOrgUnitId orgUnitId, EClass role) throws ESException {
        ESWorkspaceProviderImpl.getInstance().getAdminConnectionManager().assignRole(this.getSessionId(), orgUnitId, role);
    }

    @Override
    public void addInitialParticipant(ProjectId projectId, ACOrgUnitId participantId, EClass role) throws ESException {
        ESWorkspaceProviderImpl.getInstance().getAdminConnectionManager().addInitialParticipant(this.getSessionId(), projectId, participantId, role);
    }
}

