/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.modelmutator;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.change.FeatureMapEntry;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AbstractOverrideableCommand;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.emfstore.internal.modelmutator.api.Messages;
import org.eclipse.emf.emfstore.internal.modelmutator.intern.attribute.AttributeSetter;
import org.eclipse.emf.emfstore.internal.modelmutator.intern.attribute.AttributeSetterEBigDecimal;
import org.eclipse.emf.emfstore.internal.modelmutator.intern.attribute.AttributeSetterEBigInteger;
import org.eclipse.emf.emfstore.internal.modelmutator.intern.attribute.AttributeSetterEBoolean;
import org.eclipse.emf.emfstore.internal.modelmutator.intern.attribute.AttributeSetterEByte;
import org.eclipse.emf.emfstore.internal.modelmutator.intern.attribute.AttributeSetterEByteArray;
import org.eclipse.emf.emfstore.internal.modelmutator.intern.attribute.AttributeSetterEChar;
import org.eclipse.emf.emfstore.internal.modelmutator.intern.attribute.AttributeSetterEDate;
import org.eclipse.emf.emfstore.internal.modelmutator.intern.attribute.AttributeSetterEDouble;
import org.eclipse.emf.emfstore.internal.modelmutator.intern.attribute.AttributeSetterEEnum;
import org.eclipse.emf.emfstore.internal.modelmutator.intern.attribute.AttributeSetterEFeatureMapEntry;
import org.eclipse.emf.emfstore.internal.modelmutator.intern.attribute.AttributeSetterEFloat;
import org.eclipse.emf.emfstore.internal.modelmutator.intern.attribute.AttributeSetterEInt;
import org.eclipse.emf.emfstore.internal.modelmutator.intern.attribute.AttributeSetterELong;
import org.eclipse.emf.emfstore.internal.modelmutator.intern.attribute.AttributeSetterEShort;
import org.eclipse.emf.emfstore.internal.modelmutator.intern.attribute.AttributeSetterEString;
import org.eclipse.emf.emfstore.internal.modelmutator.mutation.MutationPredicates;
import org.eclipse.emf.emfstore.modelmutator.ESModelMutatorConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ESModelMutatorUtil {
    public static final int DELETE_DELETE_COMMAND = 0;
    public static final int DELETE_CUT_CONTAINMENT = 1;
    public static final int DELETE_ECORE = 2;
    private final Set<Object> registeredIDs = new LinkedHashSet<Object>();
    private Map<EClassifier, AttributeSetter<?>> attributeSetters;
    private final Map<EObject, List<EReference>> validContainmentReferences = new LinkedHashMap<EObject, List<EReference>>();
    private final Map<EObject, List<EReference>> validCrossReferencesByEObject = new LinkedHashMap<EObject, List<EReference>>();
    private final Map<EReference, List<EClass>> allContainments = new LinkedHashMap<EReference, List<EClass>>();
    private final Map<EClass, List<EClass>> allSubClasses = new LinkedHashMap<EClass, List<EClass>>();
    private final Map<EPackage, List<EClass>> allClassesInPackage = new LinkedHashMap<EPackage, List<EClass>>();
    private final ESModelMutatorConfiguration config;
    private final Map<EStructuralFeature, List<EObject>> featureToOfferingObjects = new LinkedHashMap<EStructuralFeature, List<EObject>>();
    private final Map<EStructuralFeature, List<EObject>> featureToSuitableObjects = new LinkedHashMap<EStructuralFeature, List<EObject>>();
    private List<EClass> allEClasses;

    public ESModelMutatorUtil(ESModelMutatorConfiguration config) {
        this.config = config;
    }

    public static EPackage getEPackage(String nsURI) {
        return EPackage.Registry.INSTANCE.getEPackage(nsURI);
    }

    public List<EReference> getValidContainmentReferences(EObject eObject) {
        List<EReference> list = this.validContainmentReferences.get(eObject);
        if (list == null) {
            list = new ArrayList<EReference>();
            for (EReference reference : eObject.eClass().getEAllReferences()) {
                if (!reference.isContainment() || !this.isValid((EStructuralFeature)reference, eObject)) continue;
                list.add(reference);
            }
            this.validContainmentReferences.put(eObject, list);
        }
        return list;
    }

    public List<EReference> getValidCrossReferences(EObject eObject) {
        List<EReference> crossReferences = this.validCrossReferencesByEObject.get(eObject);
        if (crossReferences == null) {
            crossReferences = new ArrayList<EReference>();
            for (EReference reference : eObject.eClass().getEAllReferences()) {
                if (reference.isContainer() || reference.isContainment() || !this.isValid((EStructuralFeature)reference, eObject)) continue;
                crossReferences.add(reference);
            }
            this.validCrossReferencesByEObject.put(eObject, crossReferences);
        }
        return crossReferences;
    }

    public boolean isValid(EStructuralFeature feature, EObject eObject) {
        boolean result;
        block3: {
            result = false;
            if (!feature.isMany()) break block3;
            Collection referencedItems = (Collection)eObject.eGet(feature);
            if (feature.getUpperBound() < 0 || referencedItems.size() < feature.getUpperBound()) break block3;
            return false;
        }
        try {
            result = feature.isChangeable() && !feature.isVolatile() && !feature.isDerived();
        }
        catch (RuntimeException e) {
            ESModelMutatorUtil.handle(e, this.config);
        }
        return result;
    }

    private static void handle(RuntimeException exception, ESModelMutatorConfiguration config) {
        if (!config.isIgnoreAndLog()) {
            throw exception;
        }
        config.getExceptionLog().add(exception);
    }

    public List<EClass> getAllEContainments(EReference reference) {
        List<EClass> list = this.allContainments.get(reference);
        if (list == null) {
            list = new ArrayList<EClass>();
            EClass referenceType = reference.getEReferenceType();
            if (EcorePackage.eINSTANCE.getEObject().equals(referenceType)) {
                for (EPackage ePackage : this.config.getModelPackages()) {
                    list.addAll(this.getAllEClasses(ePackage));
                }
            }
            if (ESModelMutatorUtil.canHaveInstance(referenceType)) {
                list.add(referenceType);
            }
            list.addAll(this.getAllSubEClasses(referenceType));
            this.allContainments.put(reference, list);
        }
        return list;
    }

    public static boolean canHaveInstance(EClass eClass) {
        return !eClass.isInterface() && !eClass.isAbstract();
    }

    public List<EClass> getAllSubEClasses(EClass eClass) {
        List<EClass> list = this.allSubClasses.get(eClass);
        if (list == null) {
            list = new ArrayList<EClass>();
            List<EClass> allEClasses = this.getAllEClasses(this.config.getModelPackages());
            for (EClass possibleSubClass : allEClasses) {
                if (!eClass.isSuperTypeOf(possibleSubClass) || !ESModelMutatorUtil.canHaveInstance(possibleSubClass)) continue;
                list.add(possibleSubClass);
            }
            this.allSubClasses.put(eClass, list);
        }
        return list;
    }

    public List<EClass> getAllEClasses() {
        if (this.allEClasses == null) {
            this.allEClasses = new ArrayList<EClass>();
            EPackage.Registry registry = EPackage.Registry.INSTANCE;
            for (Map.Entry entry : new LinkedHashSet(registry.entrySet())) {
                EPackage ePackage = registry.getEPackage((String)entry.getKey());
                for (EClass eClass : this.getAllEClasses(ePackage)) {
                    if (!ESModelMutatorUtil.canHaveInstance(eClass)) continue;
                    this.allEClasses.add(eClass);
                }
            }
        }
        return this.allEClasses;
    }

    public List<EClass> getAllEClasses(Collection<EPackage> ePackages) {
        ArrayList<EClass> eClasses = new ArrayList<EClass>();
        for (EPackage ePackage : ePackages) {
            eClasses.addAll(this.getAllEClasses(ePackage));
        }
        return eClasses;
    }

    public List<EClass> getAllEClasses(EPackage ePackage) {
        List<EClass> list = this.allClassesInPackage.get(ePackage);
        if (list == null) {
            list = new ArrayList<EClass>();
            for (EPackage subPackage : ePackage.getESubpackages()) {
                list.addAll(this.getAllEClasses(subPackage));
            }
            for (EClassifier classifier : ePackage.getEClassifiers()) {
                if (!(classifier instanceof EClass)) continue;
                list.add((EClass)classifier);
            }
            this.allClassesInPackage.put(ePackage, list);
        }
        return list;
    }

    public static Map<EClass, List<EObject>> getAllClassesAndObjects(EObject rootObject) {
        LinkedHashMap<EClass, List<EObject>> result = new LinkedHashMap<EClass, List<EObject>>();
        TreeIterator allContents = rootObject.eAllContents();
        ArrayList<EObject> newList = new ArrayList<EObject>();
        newList.add(rootObject);
        result.put(rootObject.eClass(), newList);
        while (allContents.hasNext()) {
            EObject eObject = (EObject)allContents.next();
            if (result.containsKey(eObject.eClass())) {
                ((List)result.get(eObject.eClass())).add(eObject);
                continue;
            }
            newList = new ArrayList();
            newList.add(eObject);
            result.put(eObject.eClass(), newList);
        }
        return result;
    }

    public void addPerCommand(EObject eObject, EStructuralFeature feature, Object newValue, Integer index) {
        try {
            if (feature.isUnique() && ((Collection)eObject.eGet(feature)).contains(newValue)) {
                return;
            }
            EditingDomain domain = this.config.getEditingDomain();
            if (index == null) {
                domain.getCommandStack().execute((Command)new AddCommand(domain, eObject, feature, newValue));
            } else {
                domain.getCommandStack().execute((Command)new AddCommand(domain, eObject, feature, newValue, index.intValue()));
            }
        }
        catch (RuntimeException e) {
            ESModelMutatorUtil.handle(e, this.config);
        }
    }

    public void addPerCommand(EObject eObject, EStructuralFeature feature, Collection<?> objects) {
        try {
            for (Object object : objects) {
                if (!feature.isUnique() || !((Collection)eObject.eGet(feature)).contains(object)) continue;
                objects.remove(object);
            }
            if (objects.isEmpty()) {
                return;
            }
            EditingDomain domain = this.config.getEditingDomain();
            domain.getCommandStack().execute((Command)new AddCommand(domain, eObject, feature, objects));
        }
        catch (RuntimeException e) {
            ESModelMutatorUtil.handle(e, this.config);
        }
    }

    public void movePerCommand(EObject parent, EStructuralFeature feature, Object objectToMove, Integer index) {
        try {
            Collection containments = (Collection)parent.eGet(feature);
            if (!containments.contains(objectToMove)) {
                return;
            }
            EditingDomain domain = this.config.getEditingDomain();
            domain.getCommandStack().execute((Command)new MoveCommand(domain, parent, feature, objectToMove, index.intValue()));
        }
        catch (RuntimeException e) {
            ESModelMutatorUtil.handle(e, this.config);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EObject setPerCommand(EObject eObject, EStructuralFeature feature, Object newValue, Integer index) {
        if (newValue == null && this.config.getRandom().nextBoolean()) {
            newValue = SetCommand.UNSET_VALUE;
        }
        try {
            EditingDomain domain = this.config.getEditingDomain();
            if (index != null) {
                if (feature.isUnique() && ((Collection)eObject.eGet(feature)).contains(newValue)) {
                    return null;
                }
                domain.getCommandStack().execute((Command)new SetCommand(domain, eObject, feature, newValue, index.intValue()));
            } else {
                domain.getCommandStack().execute((Command)new SetCommand(domain, eObject, feature, newValue));
            }
            if (newValue instanceof EObject) {
                return (EObject)newValue;
            }
            return null;
        }
        catch (RuntimeException e) {
            ESModelMutatorUtil.handle(e, this.config);
            return null;
        }
    }

    public EObject setPerCommand(EObject eObject, EStructuralFeature feature, Object newValue) {
        return this.setPerCommand(eObject, feature, newValue, null);
    }

    public void removePerCommand(EObject eObject, EStructuralFeature feature, Collection<?> objects) {
        try {
            EditingDomain domain = this.config.getEditingDomain();
            domain.getCommandStack().execute((Command)new RemoveCommand(domain, eObject, feature, objects));
        }
        catch (RuntimeException e) {
            ESModelMutatorUtil.handle(e, this.config);
        }
    }

    public void removeFullPerCommand(EObject eObject, int howToDelete) {
        block8: {
            try {
                EditingDomain domain = this.config.getEditingDomain();
                if (howToDelete == 0) {
                    domain.getCommandStack().execute((Command)new DeleteCommand(domain, Collections.singleton(eObject)));
                    break block8;
                }
                if (1 == howToDelete) {
                    EStructuralFeature feature = eObject.eContainingFeature();
                    if (feature == null) {
                        EcoreUtil.delete((EObject)eObject, (boolean)true);
                        return;
                    }
                    EObject eContainer = eObject.eContainer();
                    if (feature.isMany()) {
                        ((EList)eContainer.eGet(feature)).remove((Object)eObject);
                    } else {
                        eContainer.eSet(feature, null);
                    }
                    break block8;
                }
                if (2 == howToDelete) {
                    EcoreUtil.delete((EObject)eObject, (boolean)false);
                    break block8;
                }
                throw new IllegalArgumentException(MessageFormat.format(Messages.getString("ModelMutatorUtil.InvalidDeleteMode"), howToDelete));
            }
            catch (RuntimeException e) {
                ESModelMutatorUtil.handle(e, this.config);
            }
        }
    }

    public void setEObjectAttributes(EObject eObject) {
        this.setEObjectAttributes(eObject, Integer.MAX_VALUE, Collections.<EStructuralFeature>emptySet());
    }

    public void setEObjectAttributes(EObject eObject, int maxNumber, Set<EStructuralFeature> ignoredFeatures) {
        Random random = this.config.getRandom();
        int numAttrLeft = maxNumber;
        for (EAttribute attribute : eObject.eClass().getEAllAttributes()) {
            AttributeSetter<?> attributeSetter;
            if (ignoredFeatures.contains(attribute)) continue;
            EDataType attributeType = attribute.getEAttributeType();
            if (random.nextBoolean() && eObject.eIsSet((EStructuralFeature)attribute) && attribute.isMany()) {
                this.removePerCommand(eObject, (EStructuralFeature)attribute, (Collection)eObject.eGet((EStructuralFeature)attribute));
            }
            if (!this.isValid((EStructuralFeature)attribute, eObject) || (attributeSetter = this.getAttributeSetter((EClassifier)attributeType)) == null) continue;
            if (attribute.isMany()) {
                this.setManyAttribute(eObject, random, attribute, attributeSetter);
            } else {
                this.setMonoAttribute(eObject, attribute, attributeSetter);
            }
            if (--numAttrLeft != 0) continue;
            return;
        }
    }

    private void setMonoAttribute(EObject eObject, EAttribute attribute, AttributeSetter<?> attributeSetter) {
        this.setPerCommand(eObject, (EStructuralFeature)attribute, attributeSetter.createNewAttribute());
    }

    private void setManyAttribute(EObject eObject, Random random, EAttribute attribute, AttributeSetter<?> attributeSetter) {
        block6: {
            int size;
            block4: {
                int numberOfAttributes;
                block5: {
                    numberOfAttributes = ESModelMutatorUtil.computeFeatureAmount((EStructuralFeature)attribute, random);
                    size = ((Collection)eObject.eGet((EStructuralFeature)attribute)).size();
                    if (size != 0) break block4;
                    if (!ESModelMutatorUtil.isFeatureMap(attribute)) break block5;
                    EClass eClass = (EClass)attribute.eContainer();
                    List<FeatureMapEntry> entries = this.initFeatureMapEntries(random, attributeSetter.createNewAttributes(numberOfAttributes), numberOfAttributes, eClass);
                    if (entries.isEmpty()) break block6;
                    ArrayList toBeRemoved = new ArrayList();
                    entries.removeAll(toBeRemoved);
                    if (entries.isEmpty()) break block6;
                    this.addPerCommand(eObject, (EStructuralFeature)attribute, entries);
                    break block6;
                }
                this.addPerCommand(eObject, (EStructuralFeature)attribute, attributeSetter.createNewAttributes(numberOfAttributes));
                break block6;
            }
            if (ESModelMutatorUtil.isFeatureMap(attribute)) {
                FeatureMapEntry entry = this.initializeFeatureMapEntry(eObject, random, attribute, (FeatureMapEntry)attributeSetter.createNewAttribute());
                this.setPerCommand(eObject, (EStructuralFeature)attribute, entry);
                return;
            }
            int i = 0;
            while (i < size) {
                if (random.nextBoolean()) {
                    this.setPerCommand(eObject, (EStructuralFeature)attribute, attributeSetter.createNewAttribute(), i);
                } else {
                    Object attributeToMove = ((Collection)eObject.eGet((EStructuralFeature)attribute)).toArray()[random.nextInt(size)];
                    this.movePerCommand(eObject, (EStructuralFeature)attribute, attributeToMove, random.nextInt(size));
                }
                ++i;
            }
        }
    }

    private boolean isReference(EStructuralFeature feature) {
        return EReference.class.isInstance(feature);
    }

    private boolean isContaimentReference(EStructuralFeature feature) {
        return EReference.class.isInstance(feature) && ((EReference)EReference.class.cast(feature)).isContainment();
    }

    private FeatureMapEntry initializeFeatureMapEntry(EObject eObject, Random random, EAttribute attribute, FeatureMapEntry uninitializedFeatureMapEntry) {
        EClass eClass = (EClass)attribute.eContainer();
        List<FeatureMapEntry> entries = this.initFeatureMapEntries(random, Collections.singleton(uninitializedFeatureMapEntry), 1, eClass);
        return entries.get(0);
    }

    private static boolean isFeatureMap(EAttribute eAttribute) {
        return eAttribute.getEAttributeType().equals(EcorePackage.eINSTANCE.getEFeatureMapEntry());
    }

    private List<EStructuralFeature> getAvailableFeatureKeys(EClass eClass) {
        ArrayList<EStructuralFeature> eStructuralFeatures = new ArrayList<EStructuralFeature>((Collection<EStructuralFeature>)eClass.getEStructuralFeatures());
        Iterator iterator = eStructuralFeatures.iterator();
        while (iterator.hasNext()) {
            EStructuralFeature eStructuralFeature = (EStructuralFeature)iterator.next();
            if (!eStructuralFeature.getEType().equals(EcorePackage.eINSTANCE.getEFeatureMapEntry())) continue;
            iterator.remove();
        }
        Collections.shuffle(eStructuralFeatures);
        return eStructuralFeatures;
    }

    private List<FeatureMapEntry> initFeatureMapEntries(Random random, Collection<FeatureMapEntry> uninitializedFeatureMapEntries, int numberOfAttributes, EClass eClass) {
        List<EStructuralFeature> features = this.getAvailableFeatureKeys(eClass);
        LinkedHashMap occupiedEObjects = Maps.newLinkedHashMap();
        ArrayList entries = Lists.newArrayList();
        for (FeatureMapEntry entry : uninitializedFeatureMapEntries) {
            Collections.shuffle(features);
            EStructuralFeature feature = features.get(0);
            if (this.isReference(feature) && !this.isContaimentReference(feature)) {
                EReference reference = (EReference)EReference.class.cast(feature);
                EObject selectedEObject = this.selectUnusedEObject(random, reference.getEReferenceType(), ESModelMutatorUtil.getAllObjects(this.getModelMutatorConfiguration().getRootEObject()), occupiedEObjects);
                if (selectedEObject == null) continue;
                entry.setFeature(feature);
                entry.setReferenceValue(selectedEObject);
                if (!occupiedEObjects.containsKey(reference)) {
                    occupiedEObjects.put(reference, Lists.newArrayList());
                }
                if (((List)occupiedEObjects.get(reference)).contains(selectedEObject)) continue;
                ((List)occupiedEObjects.get(reference)).add(selectedEObject);
                entries.add(entry);
                continue;
            }
            if (this.isContaimentReference(feature)) {
                entry.setFeature(feature);
                entry.setReferenceValue(this.createOfType(((EReference)EReference.class.cast(feature)).getEReferenceType()));
                entries.add(entry);
                continue;
            }
            EAttribute attribute = (EAttribute)EAttribute.class.cast(feature);
            AttributeSetter<?> setter = this.getAttributeSetter((EClassifier)attribute.getEAttributeType());
            entry.setFeature(feature);
            Object attributeValue = null;
            while (attributeValue == null) {
                attributeValue = setter.createNewAttribute();
            }
            entry.setDataValue(attributeValue.toString());
            entries.add(entry);
        }
        return entries;
    }

    private EObject selectUnusedEObject(Random random, EClass desiredClass, Map<EClass, List<EObject>> allEObjects, Map<EStructuralFeature, List<EObject>> eObjectsInUse) {
        EObject eObject;
        List<EObject> p = allEObjects.get(desiredClass);
        if (desiredClass == null || p == null || p.isEmpty()) {
            return null;
        }
        ArrayList<EObject> possibleEObjects = new ArrayList<EObject>(p);
        ArrayList reservedEObjects = eObjectsInUse.get(desiredClass);
        if (reservedEObjects == null) {
            reservedEObjects = Lists.newArrayList();
        }
        while (true) {
            if (possibleEObjects.isEmpty()) {
                return null;
            }
            eObject = (EObject)possibleEObjects.get(random.nextInt(possibleEObjects.size()));
            if (!reservedEObjects.contains(eObject)) break;
            possibleEObjects.remove(eObject);
        }
        return eObject;
    }

    private EObject createOfType(EClass eClass) {
        EObject eObjectToAdd = EcoreUtil.create((EClass)eClass);
        this.setEObjectAttributes(eObjectToAdd);
        return eObjectToAdd;
    }

    public static Map<EClass, List<EObject>> getAllObjects(EObject root) {
        LinkedHashMap<EClass, List<EObject>> map = new LinkedHashMap<EClass, List<EObject>>();
        TreeIterator eAllContents = root.eAllContents();
        while (eAllContents.hasNext()) {
            EObject eObject = (EObject)eAllContents.next();
            EClass eClass = eObject.eClass();
            if (!map.containsKey(eClass)) {
                map.put(eClass, Lists.newArrayList());
            }
            ((List)map.get(eClass)).add(eObject);
        }
        return map;
    }

    private static boolean isEnum(EClassifier attributeType) {
        return EcorePackage.eINSTANCE.getEEnum().isInstance((Object)attributeType);
    }

    private static int computeFeatureAmount(EStructuralFeature feature, Random random) {
        if (!feature.isMany()) {
            return 1;
        }
        if (feature.getUpperBound() < feature.getLowerBound()) {
            return random.nextInt(10);
        }
        return feature.getLowerBound() + random.nextInt(feature.getUpperBound() - feature.getLowerBound() + 1);
    }

    public Map<EClassifier, AttributeSetter<?>> getAttributeSetters() {
        if (this.attributeSetters == null) {
            Random random = this.config.getRandom();
            EcorePackage ecoreInstance = EcorePackage.eINSTANCE;
            this.attributeSetters = new LinkedHashMap();
            AttributeSetter oAttributeSetter = new AttributeSetterEBoolean(random);
            this.attributeSetters.put((EClassifier)ecoreInstance.getEBoolean(), oAttributeSetter);
            this.attributeSetters.put((EClassifier)ecoreInstance.getEBooleanObject(), oAttributeSetter);
            this.attributeSetters.put((EClassifier)ecoreInstance.getEByteArray(), new AttributeSetterEByteArray(random, 100));
            this.attributeSetters.put((EClassifier)ecoreInstance.getEString(), new AttributeSetterEString(random));
            oAttributeSetter = new AttributeSetterEInt(random);
            this.attributeSetters.put((EClassifier)ecoreInstance.getEInt(), oAttributeSetter);
            this.attributeSetters.put((EClassifier)ecoreInstance.getEIntegerObject(), oAttributeSetter);
            this.attributeSetters.put((EClassifier)ecoreInstance.getEFeatureMapEntry(), new AttributeSetterEFeatureMapEntry(random));
            this.attributeSetters.put((EClassifier)ecoreInstance.getEDate(), new AttributeSetterEDate(random));
            oAttributeSetter = new AttributeSetterELong(random);
            this.attributeSetters.put((EClassifier)ecoreInstance.getELong(), oAttributeSetter);
            this.attributeSetters.put((EClassifier)ecoreInstance.getELongObject(), oAttributeSetter);
            oAttributeSetter = new AttributeSetterEByte(random);
            this.attributeSetters.put((EClassifier)ecoreInstance.getEByte(), oAttributeSetter);
            this.attributeSetters.put((EClassifier)ecoreInstance.getEByteObject(), oAttributeSetter);
            oAttributeSetter = new AttributeSetterEChar(random);
            this.attributeSetters.put((EClassifier)ecoreInstance.getEChar(), oAttributeSetter);
            this.attributeSetters.put((EClassifier)ecoreInstance.getECharacterObject(), oAttributeSetter);
            oAttributeSetter = new AttributeSetterEDouble(random);
            this.attributeSetters.put((EClassifier)ecoreInstance.getEDouble(), oAttributeSetter);
            this.attributeSetters.put((EClassifier)ecoreInstance.getEDoubleObject(), oAttributeSetter);
            oAttributeSetter = new AttributeSetterEFloat(random);
            this.attributeSetters.put((EClassifier)ecoreInstance.getEFloat(), oAttributeSetter);
            this.attributeSetters.put((EClassifier)ecoreInstance.getEFloatObject(), oAttributeSetter);
            oAttributeSetter = new AttributeSetterEShort(random);
            this.attributeSetters.put((EClassifier)ecoreInstance.getEShort(), oAttributeSetter);
            this.attributeSetters.put((EClassifier)ecoreInstance.getEShortObject(), oAttributeSetter);
            this.attributeSetters.put((EClassifier)ecoreInstance.getEBigInteger(), new AttributeSetterEBigInteger(random));
            this.attributeSetters.put((EClassifier)ecoreInstance.getEBigDecimal(), new AttributeSetterEBigDecimal(random));
        }
        return this.attributeSetters;
    }

    private AttributeSetter<?> getAttributeSetter(EClassifier attributeType) {
        this.getAttributeSetters();
        if (this.attributeSetters.containsKey(attributeType)) {
            return this.attributeSetters.get(attributeType);
        }
        if (ESModelMutatorUtil.isEnum(attributeType)) {
            return new AttributeSetterEEnum((EEnum)attributeType, this.config.getRandom());
        }
        return null;
    }

    public Object createNewAttribute(EAttribute eAttribute) {
        AttributeSetter<?> setter = this.getAttributeSetter(eAttribute.getEType());
        return setter.createNewAttribute();
    }

    public Set<EClass> getReferenceClasses(EReference reference, Set<EClass> allEClasses) {
        LinkedHashSet<EClass> result = new LinkedHashSet<EClass>();
        EClass referenceType = reference.getEReferenceType();
        if (referenceType.equals(EcorePackage.eINSTANCE.getEObject())) {
            return allEClasses;
        }
        for (EClass eClass : allEClasses) {
            if (!referenceType.equals(eClass) && !referenceType.isSuperTypeOf(eClass)) continue;
            result.add(eClass);
        }
        return result;
    }

    public void setReference(EObject eObject, EClass referenceClass, EReference reference, Map<EClass, List<EObject>> allEObjects) {
        Random random = this.config.getRandom();
        List<EObject> possibleReferenceObjects = allEObjects.get(referenceClass);
        Collections.shuffle(possibleReferenceObjects, random);
        if (possibleReferenceObjects.isEmpty()) {
            return;
        }
        int index = 0;
        if (reference.isMany()) {
            int numberOfReferences = ESModelMutatorUtil.computeFeatureAmount((EStructuralFeature)reference, random);
            numberOfReferences -= ((EList)eObject.eGet((EStructuralFeature)reference)).size();
            int i = 0;
            while (i < numberOfReferences) {
                EList ownerList = AbstractOverrideableCommand.getOwnerList((EObject)eObject, (EStructuralFeature)reference);
                int size = ownerList.size();
                if (size > 0 && random.nextBoolean()) {
                    if (random.nextBoolean()) {
                        Integer newIndex = reference.isOrdered() ? null : Integer.valueOf(random.nextInt(size));
                        EObject target = possibleReferenceObjects.get(index);
                        this.setPerCommand(eObject, (EStructuralFeature)reference, target, newIndex);
                    } else {
                        Object objectToMove = ownerList.get(random.nextInt(size));
                        this.movePerCommand(eObject, (EStructuralFeature)reference, objectToMove, index);
                    }
                } else {
                    EObject target = possibleReferenceObjects.get(index);
                    this.addPerCommand(eObject, (EStructuralFeature)reference, target, random.nextBoolean() && size > 0 ? Integer.valueOf(random.nextInt(size)) : null);
                }
                if (++index != possibleReferenceObjects.size()) {
                    ++i;
                    continue;
                }
                break;
            }
        } else if (random.nextBoolean() || reference.isRequired()) {
            EObject target = possibleReferenceObjects.get(index);
            this.setPerCommand(eObject, (EStructuralFeature)reference, target);
        }
    }

    public static int getAllObjectsCount(EObject obj) {
        TreeIterator eAllContents = obj.eAllContents();
        int i = 0;
        while (eAllContents.hasNext()) {
            ++i;
            eAllContents.next();
        }
        return i;
    }

    public void setEObjectAttributes(EObject eObject, Set<EStructuralFeature> ignoredFeatures) {
        this.setEObjectAttributes(eObject, Integer.MAX_VALUE, ignoredFeatures);
    }

    public ESModelMutatorConfiguration getModelMutatorConfiguration() {
        return this.config;
    }

    private Map<EStructuralFeature, List<EObject>> getOrBuildFeatureToOfferingObjectsMap() {
        if (this.featureToOfferingObjects.isEmpty()) {
            this.buildFeatureToOfferingObjectsMap();
        }
        return this.featureToOfferingObjects;
    }

    public Iterable<EStructuralFeature> getAvailableFeatures() {
        return this.getOrBuildFeatureToOfferingObjectsMap().keySet();
    }

    public Iterable<EStructuralFeature> getAvailableFeatures(Predicate<? super EStructuralFeature> predicate) {
        return Iterables.filter(this.getAvailableFeatures(), predicate);
    }

    public Iterable<EObject> getOfferingEObjectsForAvailableFeature(EStructuralFeature feature) {
        List<EObject> objectsOfferingFeature = this.getOrBuildFeatureToOfferingObjectsMap().get(feature);
        if (objectsOfferingFeature == null) {
            return Collections.emptyList();
        }
        return objectsOfferingFeature;
    }

    public Iterable<EObject> getOfferingEObjectsForAvailableFeature(EStructuralFeature feature, Predicate<? super EObject> predicate) {
        return Iterables.filter(this.getOfferingEObjectsForAvailableFeature(feature), predicate);
    }

    private void buildFeatureToOfferingObjectsMap() {
        this.featureToOfferingObjects.clear();
        EObject rootEObject = this.config.getRootEObject();
        this.addToFeatureToOfferingObjectsMap(rootEObject);
        TreeIterator iter = rootEObject.eAllContents();
        while (iter.hasNext()) {
            this.addToFeatureToOfferingObjectsMap((EObject)iter.next());
        }
    }

    private void addToFeatureToOfferingObjectsMap(EObject eObject) {
        EClass eClassOfObject = eObject.eClass();
        EList featuresOfObject = eClassOfObject.getEAllStructuralFeatures();
        for (EStructuralFeature feature : featuresOfObject) {
            this.addToFeatureToOfferingObjectsMap(feature, eObject);
        }
    }

    private void addToFeatureToOfferingObjectsMap(EStructuralFeature feature, EObject eObject) {
        if (!this.featureToOfferingObjects.containsKey(feature)) {
            this.featureToOfferingObjects.put(feature, new ArrayList());
        }
        this.featureToOfferingObjects.get(feature).add(eObject);
    }

    private void removeFromFeatureToOfferingObjectsMap(EStructuralFeature feature, EObject eObject) {
        if (this.featureToOfferingObjects.containsKey(feature)) {
            this.featureToOfferingObjects.get(feature).remove(eObject);
        }
    }

    public Iterable<EObject> getSuitableEObjectsForAvailableFeature(EStructuralFeature feature) {
        List<EObject> suitableEObjectsForFeature = this.getOrBuildFeatureToSuitableObjectsMap().get(feature);
        if (suitableEObjectsForFeature == null) {
            return Collections.emptyList();
        }
        return suitableEObjectsForFeature;
    }

    public Iterable<EObject> getSuitableEObjectsForAvailableFeature(EStructuralFeature feature, Predicate<? super EObject> predicate) {
        return Iterables.filter(this.getSuitableEObjectsForAvailableFeature(feature), predicate);
    }

    private Map<EStructuralFeature, List<EObject>> getOrBuildFeatureToSuitableObjectsMap() {
        if (this.featureToSuitableObjects.isEmpty()) {
            this.buildFeatureToSuitableObjectsMap();
        }
        return this.featureToSuitableObjects;
    }

    private void buildFeatureToSuitableObjectsMap() {
        this.featureToSuitableObjects.clear();
        EObject rootEObject = this.config.getRootEObject();
        this.addToFeatureToSuitableObjectsMap(rootEObject);
        TreeIterator iter = rootEObject.eAllContents();
        while (iter.hasNext()) {
            this.addToFeatureToSuitableObjectsMap((EObject)iter.next());
        }
    }

    private void addToFeatureToSuitableObjectsMap(EObject eObject) {
        for (EStructuralFeature feature : this.getAvailableFeatures(MutationPredicates.IS_REFERENCE)) {
            if (!feature.getEType().isInstance((Object)eObject)) continue;
            this.addToFeatureToSuitableObjectsMap(feature, eObject);
        }
    }

    private void addToFeatureToSuitableObjectsMap(EStructuralFeature feature, EObject eObject) {
        if (!this.featureToSuitableObjects.containsKey(feature)) {
            this.featureToSuitableObjects.put(feature, new ArrayList());
        }
        this.featureToSuitableObjects.get(feature).add(eObject);
    }

    public void addedEObject(EObject addedEObject) {
        this.addToFeatureToOfferingObjectsMap(addedEObject);
        this.addToFeatureToSuitableObjectsMap(addedEObject);
    }

    public void deletedEObject(EObject deletedEObject) {
        this.removeFromFeatureToOfferingObjectsMap(deletedEObject);
        this.removeFromFeatureToSuitableObjectMap(deletedEObject);
    }

    private void removeFromFeatureToOfferingObjectsMap(EObject deletedEObject) {
        EClass eClassOfDeletedObject = deletedEObject.eClass();
        EList objectsFeatures = eClassOfDeletedObject.getEAllStructuralFeatures();
        for (EStructuralFeature feature : objectsFeatures) {
            this.removeFromFeatureToOfferingObjectsMap(feature, deletedEObject);
        }
    }

    private void removeFromFeatureToSuitableObjectMap(EObject deletedEObject) {
        for (EStructuralFeature feature : this.featureToSuitableObjects.keySet()) {
            this.featureToSuitableObjects.get(feature).remove(deletedEObject);
        }
    }

    public List<Integer> getDeleteModes() {
        ArrayList<Integer> deleteModes = new ArrayList<Integer>();
        deleteModes.add(0);
        deleteModes.add(1);
        if (this.config.isUseEcoreUtilDelete()) {
            deleteModes.add(2);
        }
        return deleteModes;
    }

    public int getRandomDeleteMode() {
        return this.getDeleteModes().get(this.config.getRandom().nextInt(this.getDeleteModes().size()));
    }

    public boolean isUniqueID(Object id) {
        return !this.registeredIDs.contains(id);
    }

    public void registerID(Object id) {
        this.registeredIDs.add(id);
    }
}

