/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.accesscontrol.authentication.verifiers;

import java.util.regex.Pattern;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.authentication.verifiers.Messages;
import org.eclipse.emf.emfstore.internal.server.exceptions.ClientVersionOutOfDateException;
import org.eclipse.emf.emfstore.internal.server.model.ClientVersionInfo;

public final class VersionVerifier {
    private VersionVerifier() {
    }

    public static void verify(String[] versions, ClientVersionInfo clientVersionInfo) throws ClientVersionOutOfDateException {
        if (clientVersionInfo == null) {
            throw new ClientVersionOutOfDateException(Messages.VersionVerifier_NoClientVersionReceived);
        }
        if (versions == null) {
            String msg = Messages.VersionVerifier_NoServerVersionsSupplied;
            ModelUtil.logWarning((String)msg, (Throwable)new ClientVersionOutOfDateException(msg));
            return;
        }
        if (!VersionVerifier.isWildcardVersion(versions)) {
            String[] stringArray = versions;
            int n = versions.length;
            int n2 = 0;
            while (n2 < n) {
                String version = stringArray[n2];
                if (VersionVerifier.matchesClientVersion(version, clientVersionInfo) || VersionVerifier.matchesAny(version)) {
                    return;
                }
                ++n2;
            }
            StringBuffer acceptedVersions = new StringBuffer();
            String[] stringArray2 = versions;
            int n3 = versions.length;
            n = 0;
            while (n < n3) {
                String str = stringArray2[n];
                if (versions.length == 1) {
                    acceptedVersions.append(String.valueOf(str) + ". ");
                } else {
                    acceptedVersions.append(String.valueOf(str) + ", ");
                }
                ++n;
            }
            acceptedVersions.replace(acceptedVersions.length() - 2, acceptedVersions.length(), ".");
            throw new ClientVersionOutOfDateException(String.valueOf(Messages.VersionVerifier_ClientVersion) + clientVersionInfo.getVersion() + " - " + Messages.VersionVerifier_AcceptedVersions + acceptedVersions);
        }
        VersionVerifier.matchesWildcard(versions[0], clientVersionInfo);
    }

    private static void matchesWildcard(String version, ClientVersionInfo clientVersionInfo) throws ClientVersionOutOfDateException {
        int index = version.lastIndexOf(42);
        String quoted = Pattern.quote(version.substring(0, index));
        String end = Pattern.quote(version.substring(index + 1, version.length()));
        if (!clientVersionInfo.getVersion().matches(String.valueOf(quoted) + ".*" + end)) {
            throw new ClientVersionOutOfDateException("Client version: " + clientVersionInfo.getVersion() + " - " + "Accepted versions: " + version);
        }
    }

    private static boolean isWildcardVersion(String[] versions) {
        return versions.length == 1 && versions[0].contains("*");
    }

    private static boolean matchesClientVersion(String version, ClientVersionInfo clientVersionInfo) {
        return version.equals(clientVersionInfo.getVersion());
    }

    private static boolean matchesAny(String version) {
        return version.equals("any");
    }
}

