/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.modelmutator.mutation;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.emfstore.modelmutator.ESModelMutatorUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MutationPredicates {
    public static final String EXTENDED_META_DATA = "http:///org/eclipse/emf/ecore/util/ExtendedMetaData";
    public static final String KIND = "kind";
    public static final String GROUP = "group";
    public static final Predicate<? super EStructuralFeature> IS_REFERENCE = new Predicate<EStructuralFeature>(){

        public boolean apply(EStructuralFeature input) {
            return input != null && input instanceof EReference;
        }
    };
    public static final Predicate<? super EStructuralFeature> IS_CONTAINMENT_REFERENCE = new Predicate<EStructuralFeature>(){

        public boolean apply(EStructuralFeature input) {
            return IS_REFERENCE.apply((Object)input) && ((EReference)input).isContainment();
        }
    };
    public static final Predicate<? super EStructuralFeature> IS_CONTAINMENT_OR_OPPOSITE_OF_CONTAINMENT_REFERENCE = new Predicate<EStructuralFeature>(){

        public boolean apply(EStructuralFeature input) {
            return IS_CONTAINMENT_REFERENCE.apply((Object)input) || IS_OPPOSITE_OF_CONTAINMENT_REFERENCE.apply((Object)input);
        }
    };
    public static final Predicate<? super EStructuralFeature> IS_OPPOSITE_OF_CONTAINMENT_REFERENCE = new Predicate<EStructuralFeature>(){

        public boolean apply(EStructuralFeature input) {
            return input != null && input instanceof EReference && ((EReference)input).getEOpposite() != null && ((EReference)input).getEOpposite().isContainment();
        }
    };
    public static final Predicate<? super EStructuralFeature> IS_MUTABLE_CONTAINMENT_REFERENCE = new Predicate<EStructuralFeature>(){

        public boolean apply(EStructuralFeature input) {
            return IS_MUTABLE.apply((Object)input) && IS_CONTAINMENT_REFERENCE.apply((Object)input);
        }
    };
    public static final Predicate<? super EStructuralFeature> IS_MUTABLE = new Predicate<EStructuralFeature>(){

        public boolean apply(EStructuralFeature input) {
            return input != null && input.isChangeable();
        }
    };
    public static final Predicate<? super EStructuralFeature> IS_MULTI_VALUED = new Predicate<EStructuralFeature>(){

        public boolean apply(EStructuralFeature input) {
            return input != null && input.isMany();
        }
    };
    public static final Predicate<? super EStructuralFeature> IS_MUTABLE_ATTRIBUTE = new Predicate<EStructuralFeature>(){

        public boolean apply(EStructuralFeature input) {
            return IS_MUTABLE.apply((Object)input) && input instanceof EAttribute;
        }
    };
    public static final Predicate<? super EStructuralFeature> IS_MUTABLE_REFERENCE = new Predicate<EStructuralFeature>(){

        public boolean apply(EStructuralFeature input) {
            return IS_MUTABLE.apply((Object)input) && input instanceof EReference;
        }
    };
    public static final Predicate<? super EStructuralFeature> HAS_FEATURE_MAP_ENTRY_TYPE = new Predicate<EStructuralFeature>(){

        public boolean apply(EStructuralFeature input) {
            return input != null && EcorePackage.eINSTANCE.getEFeatureMapEntry().equals(input.getEType());
        }
    };
    public static final Predicate<? super EStructuralFeature> HAS_GROUP_FEATURE_MAP_ENTRY_TYPE = new Predicate<EStructuralFeature>(){

        public boolean apply(EStructuralFeature input) {
            return HAS_FEATURE_MAP_ENTRY_TYPE.apply((Object)input) && input.getEAnnotation(MutationPredicates.EXTENDED_META_DATA) != null && input.getEAnnotation(MutationPredicates.EXTENDED_META_DATA).getDetails().get((Object)MutationPredicates.KIND) != null && ((String)input.getEAnnotation(MutationPredicates.EXTENDED_META_DATA).getDetails().get((Object)MutationPredicates.KIND)).equals(MutationPredicates.GROUP);
        }
    };
    public static final Predicate<? super Object> IS_NON_EMPTY_VALUE_OR_LIST = new Predicate<Object>(){

        public boolean apply(Object input) {
            return input != null && !MutationPredicates.isEmptyList(input);
        }
    };
    public static final Predicate<? super Object> IS_NON_EMPTY_FEATURE_MAP = new Predicate<Object>(){

        public boolean apply(Object input) {
            return input != null && input instanceof FeatureMap && ((FeatureMap)input).size() > 0;
        }
    };
    public static final Predicate<? super Object> IS_NON_EMPTY_EOBJECT_OR_LIST = new Predicate<Object>(){

        public boolean apply(Object input) {
            return IS_NON_NULL_EOBJECT.apply(input) || IS_NON_EMPTY_EOBJECT_LIST.apply(input);
        }
    };
    public static final Predicate<? super Object> IS_NON_NULL_EOBJECT = new Predicate<Object>(){

        public boolean apply(Object input) {
            return input != null && input instanceof EObject;
        }
    };
    public static final Predicate<? super Object> IS_NON_EMPTY_EOBJECT_LIST = new Predicate<Object>(){

        public boolean apply(Object input) {
            return input instanceof List && MutationPredicates.isNonEmptyEObjectList((List)input);
        }
    };
    public static final Predicate<? super Object> IS_NULL_OR_LIST = new Predicate<Object>(){

        public boolean apply(Object input) {
            return input == null || IS_LIST.apply(input);
        }
    };
    public static final Predicate<? super Object> IS_LIST = new Predicate<Object>(){

        public boolean apply(Object input) {
            return input instanceof List;
        }
    };

    private MutationPredicates() {
    }

    public static Predicate<? super EStructuralFeature> mayTakeEObjectAsValue(final EObject eObject) {
        return new Predicate<EStructuralFeature>(){

            public boolean apply(EStructuralFeature input) {
                if (input != null && input instanceof EReference) {
                    EReference eReference = (EReference)input;
                    return eReference.getEType().isInstance((Object)eObject);
                }
                return false;
            }
        };
    }

    public static Predicate<? super EStructuralFeature> hasCompatibleType(final EStructuralFeature feature) {
        return new Predicate<EStructuralFeature>(){

            public boolean apply(EStructuralFeature input) {
                return input != null && (input.getEType() == feature.getEType() || MutationPredicates.isSubTypeOf(input.getEType(), feature.getEType()));
            }
        };
    }

    private static boolean isSubTypeOf(EClassifier eType, EClassifier eType2) {
        if (eType instanceof EClass && eType2 instanceof EClass) {
            EClass eClass1 = (EClass)eType;
            EClass eClass2 = (EClass)eType2;
            return eClass2.isSuperTypeOf(eClass1);
        }
        return false;
    }

    public static Predicate<? super EStructuralFeature> isCompatibleWithAnyFeatureOfEClass(final EClass eClass) {
        return new Predicate<EStructuralFeature>(){

            public boolean apply(EStructuralFeature input) {
                return input != null && Iterables.any((Iterable)eClass.getEStructuralFeatures(), MutationPredicates.hasCompatibleType(input));
            }
        };
    }

    public static Predicate<? super EObject> mayBeContainedByFeature(final EStructuralFeature feature) {
        return new Predicate<EObject>(){

            public boolean apply(EObject input) {
                return MutationPredicates.mayTakeEObjectAsValue(input).apply((Object)feature);
            }
        };
    }

    public static Predicate<? super EObject> mayBeContainedByAnyOfTheseReferences(final Iterable<EReference> references) {
        return new Predicate<EObject>(){

            public boolean apply(EObject input) {
                return input != null && Iterables.any((Iterable)references, MutationPredicates.mayTakeEObjectAsValue(input));
            }
        };
    }

    public static Predicate<? super EObject> isNotTheSame(final EObject eObject) {
        return new Predicate<EObject>(){

            public boolean apply(EObject input) {
                return input != null && input != eObject;
            }
        };
    }

    public static Predicate<? super EObject> isChild(final EObject eObject) {
        return new Predicate<EObject>(){

            public boolean apply(EObject input) {
                return input != null && EcoreUtil.isAncestor((EObject)eObject, (EObject)input);
            }
        };
    }

    public static Predicate<? super EObject> isAncestor(final EObject eObject) {
        return new Predicate<EObject>(){

            public boolean apply(EObject input) {
                return input != null && EcoreUtil.isAncestor((EObject)input, (EObject)eObject);
            }
        };
    }

    public static Predicate<? super EObject> isContainedByFeature(final EStructuralFeature feature) {
        return new Predicate<EObject>(){

            public boolean apply(EObject input) {
                return input != null && input.eContainingFeature() == feature;
            }
        };
    }

    public static Predicate<? super EObject> isContainedByEObject(final EObject eContainer) {
        return new Predicate<EObject>(){

            public boolean apply(EObject input) {
                return input != null && input.eContainer() == eContainer;
            }
        };
    }

    private static boolean isEmptyList(Object input) {
        if (input instanceof List) {
            List list = (List)input;
            return list.isEmpty();
        }
        return false;
    }

    private static boolean isNonEmptyEObjectList(List<?> input) {
        return !input.isEmpty() && Iterables.all(input, IS_NON_NULL_EOBJECT);
    }

    public static Predicate<? super Object> containsEObjectWithMaxNumberOfContainments(final int maxNumberOfContainments) {
        return new Predicate<Object>(){

            public boolean apply(Object input) {
                return input != null && Predicates.or(MutationPredicates.isListContainingEObjectWithMaxNumberOfContainments(maxNumberOfContainments), MutationPredicates.isEObjectWithMaxNumberOfContainments(maxNumberOfContainments)).apply(input);
            }
        };
    }

    public static Predicate<? super Object> isListContainingEObjectWithMaxNumberOfContainments(final int maxNumberOfContainments) {
        return new Predicate<Object>(){

            public boolean apply(Object input) {
                return input instanceof List && Iterables.any((Iterable)((List)input), MutationPredicates.hasMaxNumberOfContainments(maxNumberOfContainments));
            }
        };
    }

    public static Predicate<? super Object> isEObjectWithMaxNumberOfContainments(final int maxNumberOfContainments) {
        return new Predicate<Object>(){

            public boolean apply(Object input) {
                return input instanceof EObject && MutationPredicates.hasMaxNumberOfContainments(maxNumberOfContainments).apply((Object)((EObject)input));
            }
        };
    }

    public static Predicate<? super EObject> hasMaxNumberOfContainments(final int maxNumberOfContainments) {
        return new Predicate<EObject>(){

            public boolean apply(EObject input) {
                return ESModelMutatorUtil.getAllObjectsCount(input) <= maxNumberOfContainments;
            }
        };
    }

    public static Predicate<? super Object> isListWithSpecifiedSize(final int size) {
        return new Predicate<Object>(){

            public boolean apply(Object originalValue) {
                if (originalValue instanceof List) {
                    List originalValueList = (List)originalValue;
                    return originalValueList.size() == size;
                }
                return false;
            }
        };
    }
}

